/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.ruby;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.text.Position;
import org.jrubyparser.ast.Node;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.UiUtils;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.ruby.RetoucheUtils;
import org.netbeans.modules.refactoring.ruby.RubyElementCtx;
import org.netbeans.modules.refactoring.ruby.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.ruby.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;

    public WhereUsedElement(PositionBounds bounds, String displayText, FileObject parentFile, String name, OffsetRange range, Icon icon) {
        this.bounds = bounds;
        this.displayText = displayText;
        this.parentFile = parentFile;
        ElementGripFactory.getDefault().put(parentFile, name, range, icon);
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        ElementGrip composite = ElementGripFactory.getDefault().get(this.parentFile, this.bounds.getBegin().getOffset());
        if (composite == null) {
            composite = this.parentFile;
        }
        return Lookups.singleton((Object)composite);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    public static WhereUsedElement create(RubyElementCtx tree) {
        ParserResult info = tree.getInfo();
        OffsetRange range = AstUtilities.getNameRange((Node)tree.getNode());
        assert (range != OffsetRange.NONE);
        range = LexUtilities.getLexerOffsets((Parser.Result)info, (OffsetRange)range);
        assert (range != OffsetRange.NONE) : tree;
        Set modifiers = Collections.emptySet();
        if (tree.getElement() != null) {
            modifiers = tree.getElement().getModifiers();
        }
        ImageIcon icon = UiUtils.getElementIcon((ElementKind)tree.getKind(), (Collection)modifiers);
        return WhereUsedElement.create(info, tree.getName(), range, icon);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WhereUsedElement create(ParserResult parserResult, String name, OffsetRange range, Icon icon) {
        FileObject fo = RubyUtils.getFileObject((Parser.Result)parserResult);
        int start = range.getStart();
        int end = range.getEnd();
        int sta = start;
        int en = start;
        String content = null;
        BaseDocument bdoc = GsfUtilities.getDocument((FileObject)RubyUtils.getFileObject((Parser.Result)parserResult), (boolean)true);
        try {
            bdoc.readLock();
            content = bdoc.getText(0, bdoc.getLength());
            sta = Utilities.getRowFirstNonWhite((BaseDocument)bdoc, (int)start);
            if (sta == -1) {
                sta = Utilities.getRowStart((BaseDocument)bdoc, (int)start);
            }
            en = (en = Utilities.getRowLastNonWhite((BaseDocument)bdoc, (int)start)) == -1 ? Utilities.getRowEnd((BaseDocument)bdoc, (int)start) : ++en;
            if (end > en && (end = start + name.length()) > bdoc.getLength()) {
                end = bdoc.getLength();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            bdoc.readUnlock();
        }
        StringBuilder sb = new StringBuilder();
        if (start < sta) {
            System.out.println("Problem!");
            start = sta;
        }
        if (en < end) {
            System.out.println("Problem!");
            en = end;
        }
        CharSequence subSequence = content.subSequence(sta, start);
        sb.append(RetoucheUtils.getHtml(((Object)subSequence).toString()));
        sb.append("<b>");
        sb.append(content.subSequence(start, end));
        sb.append("</b>");
        sb.append(RetoucheUtils.getHtml(((Object)content.subSequence(end, en)).toString()));
        CloneableEditorSupport ces = RetoucheUtils.findCloneableEditorSupport(parserResult);
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        return new WhereUsedElement(bounds, sb.toString().trim(), fo, name, new OffsetRange(start, end), icon);
    }

    public static WhereUsedElement create(ParserResult parserResult, String name, String html, OffsetRange range, Icon icon) {
        FileObject fo = RubyUtils.getFileObject((Parser.Result)parserResult);
        int start = range.getStart();
        int end = range.getEnd();
        CloneableEditorSupport ces = RetoucheUtils.findCloneableEditorSupport(parserResult);
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        return new WhereUsedElement(bounds, html, fo, name, new OffsetRange(start, end), icon);
    }
}

