/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ClassPresenterPanel
extends JPanel
implements HeapFragmentWalker.StateListener {
    private static final String INSTANCES_COUNT_STRING = NbBundle.getMessage(ClassPresenterPanel.class, (String)"ClassPresenterPanel_InstancesCountString");
    private static final String INSTANCE_SIZE_STRING = NbBundle.getMessage(ClassPresenterPanel.class, (String)"ClassPresenterPanel_InstanceSizeString");
    private static final String TOTAL_SIZE_STRING = NbBundle.getMessage(ClassPresenterPanel.class, (String)"ClassPresenterPanel_TotalSizeString");
    private static final String RETAINED_SIZES_STRING = NbBundle.getMessage(ClassPresenterPanel.class, (String)"ClassPresenterPanel_RetainedSizesString");
    private static ImageIcon ICON_CLASS = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/heapwalk/ui/resources/class.png", (boolean)false);
    private HeaderRenderer headerRenderer;
    private JLabel detailsRenderer;
    private HTMLLabel actionsRenderer;
    private HeapFragmentWalker heapFragmentWalker;

    public ClassPresenterPanel() {
        this.initComponents();
    }

    public void setJavaClass(JavaClass javaClass) {
        if (javaClass != null) {
            String className = javaClass.getName();
            String instancesCount = MessageFormat.format(INSTANCES_COUNT_STRING, javaClass.getInstancesCount());
            String instanceSize = javaClass.getInstanceSize() != -1 ? "  |  " + MessageFormat.format(INSTANCE_SIZE_STRING, javaClass.getInstanceSize()) : "";
            String allInstancesSize = javaClass.getAllInstancesSize() != -1L ? "  |  " + MessageFormat.format(TOTAL_SIZE_STRING, javaClass.getAllInstancesSize()) : "";
            String classDetails = javaClass.isArray() ? instancesCount + allInstancesSize : instancesCount + instanceSize + allInstancesSize;
            this.headerRenderer.setText(className);
            this.detailsRenderer.setText(classDetails);
            this.actionsRenderer.setPreferredSize(new Dimension(this.actionsRenderer.getPreferredSize().width, this.detailsRenderer.getPreferredSize().height));
        }
    }

    public void setHeapFragmentWalker(HeapFragmentWalker heapFragmentWalker) {
        if (this.heapFragmentWalker != null) {
            this.heapFragmentWalker.removeStateListener(this);
        }
        this.heapFragmentWalker = heapFragmentWalker;
        if (this.heapFragmentWalker != null) {
            this.heapFragmentWalker.addStateListener(this);
            this.updateActions(heapFragmentWalker.getRetainedSizesStatus());
        } else {
            this.updateActions(-1);
        }
    }

    @Override
    public void stateChanged(HeapFragmentWalker.StateEvent e) {
        this.updateActions(e.getRetainedSizesStatus());
    }

    public void updateActions(int retainedSizesStatus) {
        switch (retainedSizesStatus) {
            case -1: 
            case 3: {
                this.actionsRenderer.setVisible(false);
                break;
            }
            case 0: 
            case 1: {
                this.actionsRenderer.setVisible(true);
                this.actionsRenderer.setEnabled(true);
                break;
            }
            case 2: {
                this.actionsRenderer.setVisible(true);
                this.actionsRenderer.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        Color borderColor = UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(borderColor), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.setOpaque(true);
        this.setBackground(new Color(245, 245, 245));
        this.headerRenderer = new HeaderRenderer();
        this.headerRenderer.setIcon(ICON_CLASS);
        this.headerRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.headerRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.headerRenderer.setOpaque(false);
        this.detailsRenderer = new JLabel();
        this.detailsRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.detailsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.detailsRenderer.setOpaque(false);
        this.actionsRenderer = new HTMLLabel(){

            protected void showURL(URL url) {
                if (ClassPresenterPanel.this.heapFragmentWalker != null) {
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            ClassPresenterPanel.this.heapFragmentWalker.computeRetainedSizes(true);
                        }
                    });
                }
            }
        };
        this.actionsRenderer.setBorder(BorderFactory.createEmptyBorder());
        this.actionsRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.actionsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.actionsRenderer.setText("&nbsp;&nbsp;|&nbsp;&nbsp;<a href='#'>" + RETAINED_SIZES_STRING + "</a>");
        this.actionsRenderer.setOpaque(false);
        this.actionsRenderer.setVisible(false);
        JPanel detailsContainer = new JPanel(new FlowLayout(3, 0, 0));
        detailsContainer.setOpaque(false);
        detailsContainer.add(this.detailsRenderer);
        detailsContainer.add((Component)this.actionsRenderer);
        this.add((Component)this.headerRenderer, "West");
        this.add((Component)detailsContainer, "East");
    }

    private class HeaderRenderer
    extends JLabel {
        private HeaderRenderer() {
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(0, super.getMinimumSize().height);
        }

        @Override
        public void setText(String text) {
            int classNameIndex = text.lastIndexOf(".");
            if (classNameIndex == -1) {
                super.setText(text);
            } else {
                String htmlText = "<html>" + text.substring(0, ++classNameIndex) + "<b>" + text.substring(classNameIndex) + "</b>" + "</html>";
                super.setText(htmlText);
            }
        }
    }
}

