/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractTopLevelController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.NavigationHistoryManager;
import org.netbeans.modules.profiler.heapwalk.memorylint.MemoryLint;
import org.netbeans.modules.profiler.heapwalk.memorylint.Rule;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.ui.AnalysisControllerUI;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class AnalysisController
extends AbstractTopLevelController
implements NavigationHistoryManager.NavigationHistoryCapable {
    private static final String CANNOT_RESOLVE_CLASS_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveClassMsg");
    private static final String CANNOT_RESOLVE_INSTANCE_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveInstanceMsg");
    private HeapFragmentWalker heapFragmentWalker;
    private List<Rule> rules = null;
    private MemoryLint runningMemoryLint;
    private boolean analysisRunning = false;

    public AnalysisController(HeapFragmentWalker heapFragmentWalker) {
        this.heapFragmentWalker = heapFragmentWalker;
    }

    public boolean isAnalysisRunning() {
        return this.analysisRunning;
    }

    @Override
    public NavigationHistoryManager.Configuration getCurrentConfiguration() {
        return new NavigationHistoryManager.Configuration();
    }

    public HeapFragmentWalker getHeapFragmentWalker() {
        return this.heapFragmentWalker;
    }

    public List<Rule> getRules() {
        if (this.rules == null) {
            this.rules = new ArrayList<Rule>(MemoryLint.createRules());
        }
        return this.rules;
    }

    public void cancelAnalysis() {
        if (this.runningMemoryLint != null) {
            this.runningMemoryLint.interrupt();
            this.analysisRunning = false;
            this.runningMemoryLint = null;
        }
    }

    @Override
    public void configure(NavigationHistoryManager.Configuration configuration) {
        this.heapFragmentWalker.switchToHistoryAnalysisView();
    }

    public BoundedRangeModel performAnalysis(boolean[] rulesSelection) {
        final ArrayList<Rule> selectedRules = new ArrayList<Rule>();
        List<Rule> allRules = this.getRules();
        for (int i = 0; i < rulesSelection.length; ++i) {
            if (!rulesSelection[i]) continue;
            selectedRules.add(allRules.get(i));
        }
        if (selectedRules.size() > 0) {
            MemoryLint ml;
            this.analysisRunning = true;
            this.runningMemoryLint = ml = new MemoryLint(this.heapFragmentWalker.getHeapFragment());
            BrowserUtils.performTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        ml.process(selectedRules);
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().log(65536, e.getMessage());
                    }
                    AnalysisController.this.rules = null;
                    AnalysisController.this.analysisRunning = false;
                    AnalysisController.this.runningMemoryLint = null;
                    AnalysisControllerUI ui = (AnalysisControllerUI)AnalysisController.this.getPanel();
                    ui.displayNewRules();
                    if (!ml.isInterruped()) {
                        ui.setResult(ml.getResults());
                    }
                }
            });
            return ml.getGlobalProgress();
        }
        return null;
    }

    public void showURL(URL url) {
        String urls = url.toString();
        if (urls.startsWith("file://instance/")) {
            urls = urls.substring("file://instance/".length());
            String[] id = urls.split("/");
            JavaClass c = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(id[0]);
            if (c != null) {
                List instances = c.getInstances();
                Instance i = null;
                int instanceNumber = Integer.parseInt(id[1]);
                if (instanceNumber <= instances.size()) {
                    i = (Instance)instances.get(instanceNumber - 1);
                }
                if (i != null) {
                    this.heapFragmentWalker.getClassesController().showInstance(i);
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_INSTANCE_MSG, id[1], c.getName()));
                }
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, id[0]));
            }
        } else if (urls.startsWith("file://class/")) {
            urls = urls.substring("file://class/".length());
            JavaClass c = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(urls);
            if (c != null) {
                this.heapFragmentWalker.getClassesController().showClass(c);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, urls));
            }
        }
    }

    @Override
    protected AbstractButton[] createClientPresenters() {
        return new AbstractButton[0];
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((AnalysisControllerUI)this.getPanel()).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new AnalysisControllerUI(this);
    }
}

