/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config.mdb;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.spi.MessageDestinationDeployment;
import org.netbeans.modules.j2ee.jboss4.config.mdb.JBossMessageDestination;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

public final class JBossMessageDestinationDeployment
implements MessageDestinationDeployment {
    private FileObject deployDir;

    public JBossMessageDestinationDeployment(String string) {
        String string2 = InstanceProperties.getInstanceProperties((String)string).getProperty("deploy-dir");
        this.deployDir = FileUtil.toFileObject((File)new File(string2));
    }

    public Set<MessageDestination> getMessageDestinations() throws ConfigurationException {
        HashSet<MessageDestination> hashSet = new HashSet<MessageDestination>();
        hashSet.add(new JBossMessageDestination("SampleServerQueue", MessageDestination.Type.QUEUE));
        hashSet.add(new JBossMessageDestination("SampleServerTopic", MessageDestination.Type.TOPIC));
        return hashSet;
    }

    public void deployMessageDestinations(Set<MessageDestination> set) throws ConfigurationException {
    }

    private void writeFile(final File file, final BaseBean baseBean) throws ConfigurationException {
        try {
            FileSystem fileSystem = this.deployDir.getFileSystem();
            fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    OutputStream outputStream = null;
                    FileLock fileLock = null;
                    try {
                        String string = file.getName();
                        FileObject fileObject = JBossMessageDestinationDeployment.this.deployDir.getFileObject(string);
                        if (fileObject == null) {
                            fileObject = JBossMessageDestinationDeployment.this.deployDir.createData(string);
                        }
                        fileLock = fileObject.lock();
                        outputStream = new BufferedOutputStream(fileObject.getOutputStream(fileLock), 4096);
                        if (baseBean != null) {
                            baseBean.write(outputStream);
                        }
                    }
                    finally {
                        if (outputStream != null) {
                            try {
                                outputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
            });
        }
        catch (IOException iOException) {
            throw new ConfigurationException(iOException.getLocalizedMessage());
        }
    }
}

