/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.j2ee.api.ejbjar.Ear;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.maven.j2ee.SelectProjectPanel;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SelectAppServerPanel
extends JPanel {
    private NotificationLineSupport nls;
    private Project project;
    private JButton btChange;
    private ButtonGroup buttonGroup1;
    private JComboBox comServer;
    private JLabel lblProject;
    private JLabel lblServer;
    JRadioButton rbIgnore;
    JRadioButton rbPermanent;
    JRadioButton rbSession;

    public SelectAppServerPanel(boolean bl, Project project) {
        this.project = project;
        this.initComponents();
        this.buttonGroup1.add(this.rbSession);
        this.buttonGroup1.add(this.rbPermanent);
        this.loadComboModel();
        if (bl) {
            this.buttonGroup1.add(this.rbIgnore);
            this.checkIgnoreEnablement();
            this.comServer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SelectAppServerPanel.this.checkIgnoreEnablement();
                }
            });
            this.rbIgnore.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectAppServerPanel.this.printIgnoreWarning();
                }
            });
        } else {
            this.rbIgnore.setVisible(false);
        }
        this.updateProjectLbl();
        this.rbPermanentStateChanged(null);
    }

    String getSelectedServerType() {
        Wrapper wrapper = (Wrapper)this.comServer.getSelectedItem();
        return wrapper.getServerID();
    }

    String getSelectedServerInstance() {
        Wrapper wrapper = (Wrapper)this.comServer.getSelectedItem();
        return wrapper.getServerInstanceID();
    }

    boolean isPermanent() {
        return this.rbPermanent.isSelected();
    }

    boolean isIgnored() {
        return this.rbIgnore.isSelected();
    }

    Project getChosenProject() {
        return this.project;
    }

    private void loadComboModel() {
        J2eeModule.Type type;
        Ear ear = Ear.getEar((FileObject)this.project.getProjectDirectory());
        EjbJar ejbJar = EjbJar.getEjbJar((FileObject)this.project.getProjectDirectory());
        WebModule webModule = WebModule.getWebModule((FileObject)this.project.getProjectDirectory());
        J2eeModule.Type type2 = ear != null ? J2eeModule.Type.EAR : (webModule != null ? J2eeModule.Type.WAR : (type = ejbJar != null ? J2eeModule.Type.EJB : J2eeModule.Type.CAR));
        Profile profile = ear != null ? ear.getJ2eeProfile() : (webModule != null ? webModule.getJ2eeProfile() : (ejbJar != null ? ejbJar.getJ2eeProfile() : Profile.JAVA_EE_6_FULL));
        String[] stringArray = Deployment.getDefault().getServerInstanceIDs(Collections.singletonList(type), profile);
        ArrayList<Wrapper> arrayList = new ArrayList<Wrapper>();
        arrayList.add(new Wrapper("DEV-NULL"));
        for (int i = 0; i < stringArray.length; ++i) {
            Wrapper wrapper = new Wrapper(stringArray[i]);
            arrayList.add(wrapper);
        }
        this.comServer.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.rbSession = new JRadioButton();
        this.rbPermanent = new JRadioButton();
        this.rbIgnore = new JRadioButton();
        this.lblProject = new JLabel();
        this.btChange = new JButton();
        this.lblServer.setLabelFor(this.comServer);
        Mnemonics.setLocalizedText((JLabel)this.lblServer, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.lblServer.text"));
        this.rbSession.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSession, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.rbSession.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.rbPermanent, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.rbPermanent.text"));
        this.rbPermanent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SelectAppServerPanel.this.rbPermanentStateChanged(changeEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.rbIgnore, (String)NbBundle.getBundle(SelectAppServerPanel.class).getString("SelectAppServerPanel.rbIgnore.text"));
        this.lblProject.setFont(this.lblProject.getFont().deriveFont((float)this.lblProject.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.lblProject, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.lblProject.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btChange, (String)NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.btChange.text"));
        this.btChange.setToolTipText(NbBundle.getMessage(SelectAppServerPanel.class, (String)"SelectAppServerPanel.btChange.toolTipText"));
        this.btChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SelectAppServerPanel.this.btChangeActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add(12, 12, 12).add((Component)this.lblProject)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblServer).addPreferredGap(0).add((Component)this.comServer, 0, 363, Short.MAX_VALUE)).add(1, (Component)this.rbSession).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbPermanent).addPreferredGap(0, 168, Short.MAX_VALUE).add((Component)this.btChange)).add(1, (Component)this.rbIgnore)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblServer).add((Component)this.comServer, -2, -1, -2)).add(18, 18, 18).add((Component)this.rbSession).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.rbPermanent).addPreferredGap(0).add((Component)this.lblProject)).add((Component)this.btChange)).add(18, 18, 18).add((Component)this.rbIgnore).addContainerGap(20, Short.MAX_VALUE)));
    }

    private void rbPermanentStateChanged(ChangeEvent changeEvent) {
        boolean bl = this.rbPermanent.isSelected();
        this.btChange.setEnabled(bl);
        this.lblProject.setEnabled(bl);
        if (this.nls != null) {
            if (bl) {
                this.nls.setInformationMessage(NbBundle.getMessage(SelectAppServerPanel.class, (String)"MSG_ParentHint"));
            } else {
                this.nls.clearMessages();
            }
        }
    }

    private void btChangeActionPerformed(ActionEvent actionEvent) {
        SelectProjectPanel selectProjectPanel = new SelectProjectPanel(this.project);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)selectProjectPanel, NbBundle.getMessage(SelectAppServerPanel.class, (String)"TIT_ChooseParent"));
        selectProjectPanel.attachDD(dialogDescriptor);
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (object == NotifyDescriptor.OK_OPTION) {
            this.project = selectProjectPanel.getSelectedProject();
            this.updateProjectLbl();
        }
    }

    private void checkIgnoreEnablement() {
        Wrapper wrapper = (Wrapper)this.comServer.getSelectedItem();
        if ("DEV-NULL".equals(wrapper.getServerID())) {
            this.rbIgnore.setEnabled(true);
        } else {
            if (this.rbIgnore.isSelected()) {
                this.rbSession.setSelected(true);
            }
            this.rbIgnore.setEnabled(false);
        }
    }

    void setNLS(NotificationLineSupport notificationLineSupport) {
        this.nls = notificationLineSupport;
    }

    private void printIgnoreWarning() {
        if (this.rbIgnore.isSelected()) {
            this.nls.setWarningMessage(NbBundle.getMessage(SelectAppServerPanel.class, (String)"WARN_Ignore_Server"));
        } else {
            this.nls.clearMessages();
        }
    }

    private void updateProjectLbl() {
        ProjectInformation projectInformation = (ProjectInformation)this.project.getLookup().lookup(ProjectInformation.class);
        if (projectInformation != null) {
            this.lblProject.setText(NbBundle.getMessage(SelectAppServerPanel.class, (String)"MSG_InProject", (Object)projectInformation.getDisplayName()));
        }
    }
}

