/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.spi.project.support.GenericSources;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class J2eeMavenSourcesImpl
implements Sources {
    public static final String TYPE_DOC_ROOT = "doc_root";
    public static final String TYPE_WEB_INF = "web_inf";
    private final Project project;
    private final List<ChangeListener> listeners;
    private SourceGroup webDocSrcGroup;
    private final Object lock = new Object();
    private NbMavenProject mavenproject;

    public J2eeMavenSourcesImpl(Project project) {
        this.project = project;
        this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        this.listeners = new ArrayList<ChangeListener>();
        NbMavenProject.addPropertyChangeListener((Project)this.project, (PropertyChangeListener)new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("MavenProject".equals(propertyChangeEvent.getPropertyName())) {
                    J2eeMavenSourcesImpl.this.checkChanges(true);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkChanges(boolean bl) {
        boolean bl2 = false;
        Object object = this.lock;
        synchronized (object) {
            MavenProject mavenProject = this.mavenproject.getMavenProject();
            FileObject fileObject = null;
            if (mavenProject != null) {
                fileObject = FileUtilities.convertURItoFileObject((URI)this.mavenproject.getWebAppDirectory());
            }
            bl2 = this.checkWebDocGroupCache(fileObject);
        }
        if (bl2) {
            if (bl) {
                this.fireChange();
            } else {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        J2eeMavenSourcesImpl.this.fireChange();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        ArrayList<ChangeListener> arrayList;
        Object object = this.listeners;
        synchronized (object) {
            arrayList = new ArrayList<ChangeListener>(this.listeners);
        }
        object = new ChangeEvent(this);
        for (ChangeListener changeListener : arrayList) {
            changeListener.stateChanged((ChangeEvent)object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        List<ChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(changeListener);
        }
    }

    public SourceGroup[] getSourceGroups(String string) {
        if (TYPE_DOC_ROOT.equals(string)) {
            return this.createWebDocRoot();
        }
        return new SourceGroup[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SourceGroup[] createWebDocRoot() {
        FileObject fileObject = FileUtilities.convertURItoFileObject((URI)this.mavenproject.getWebAppDirectory());
        SourceGroup sourceGroup = null;
        Object object = this.lock;
        synchronized (object) {
            this.checkWebDocGroupCache(fileObject);
            sourceGroup = this.webDocSrcGroup;
        }
        if (sourceGroup != null) {
            return new SourceGroup[]{sourceGroup};
        }
        return new SourceGroup[0];
    }

    private boolean checkWebDocGroupCache(FileObject fileObject) {
        if (fileObject == null && this.webDocSrcGroup != null) {
            this.webDocSrcGroup = null;
            return true;
        }
        if (fileObject == null) {
            return false;
        }
        boolean bl = false;
        if (this.webDocSrcGroup == null || !this.webDocSrcGroup.getRootFolder().equals(fileObject)) {
            this.webDocSrcGroup = GenericSources.group((Project)this.project, (FileObject)fileObject, (String)TYPE_DOC_ROOT, (String)NbBundle.getMessage(J2eeMavenSourcesImpl.class, (String)"LBL_WebPages"), null, null);
            bl = true;
        }
        return bl;
    }
}

