/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.winsys;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.winsys.NewTCIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.AsyncGUIJob;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class BasicSettingsPanel
extends BasicWizardIterator.Panel {
    private NewTCIterator.DataModel data;
    private static final String[] DEFAULT_MODES = new String[]{"editor"};
    private boolean loadedComboBox = false;
    private JCheckBox cbClosingNotAllowed;
    private JCheckBox cbDraggingNotAllowed;
    private JCheckBox cbKeepPrefSize;
    private JCheckBox cbMaximizationNotAllowed;
    private JCheckBox cbOpenedOnStart;
    private JCheckBox cbSlidingNotAllowed;
    private JCheckBox cbUndockingNotAllowed;
    private JComboBox comMode;
    private JLabel lblMode;

    public BasicSettingsPanel(WizardDescriptor setting, NewTCIterator.DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.setupCombo();
        this.putClientProperty("NewFileWizard_Title", BasicSettingsPanel.getMessage("LBL_TCWizardTitle"));
    }

    private void checkValidity() {
        if (this.loadedComboBox) {
            this.markValid();
        } else {
            this.markInvalid();
        }
    }

    private void setupCombo() {
        final Cursor currentCursor = this.getCursor();
        this.setCursor(Utilities.createProgressCursor((Component)this));
        Utilities.attachInitJob((Component)this.comMode, (AsyncGUIJob)new AsyncGUIJob(){
            String[] modes = null;

            public void construct() {
                try {
                    FileSystem fs = LayerUtils.getEffectiveSystemFilesystem(BasicSettingsPanel.this.data.getProject());
                    FileObject foRoot = fs.getRoot().getFileObject("Windows2/Modes");
                    if (foRoot != null) {
                        FileObject[] fos = foRoot.getChildren();
                        ArrayList<String> col = new ArrayList<String>();
                        for (FileObject fo : fos) {
                            if (!fo.isData() || !"wsmode".equals(fo.getExt())) continue;
                            col.add(fo.getName());
                        }
                        this.modes = col.toArray(new String[col.size()]);
                    } else {
                        this.modes = DEFAULT_MODES;
                    }
                }
                catch (IOException exc) {
                    this.modes = DEFAULT_MODES;
                }
            }

            public void finished() {
                BasicSettingsPanel.this.comMode.setModel(new DefaultComboBoxModel<String>(this.modes));
                BasicSettingsPanel.this.setComModeSelectedItem();
                BasicSettingsPanel.this.windowPosChanged(null);
                BasicSettingsPanel.this.setCursor(currentCursor);
                BasicSettingsPanel.this.loadedComboBox = true;
                BasicSettingsPanel.this.checkValidity();
            }
        });
    }

    @Override
    protected void storeToDataModel() {
        this.data.setOpened(this.cbOpenedOnStart.isSelected());
        this.data.setKeepPrefSize(this.cbKeepPrefSize.isSelected());
        this.data.setClosingNotAllowed(this.cbClosingNotAllowed.isSelected());
        this.data.setDraggingNotAllowed(this.cbDraggingNotAllowed.isSelected());
        this.data.setMaximizationNotAllowed(this.cbMaximizationNotAllowed.isSelected());
        this.data.setSlidingNotAllowed(this.cbSlidingNotAllowed.isSelected());
        this.data.setUndockingNotAllowed(this.cbUndockingNotAllowed.isSelected());
        this.data.setMode((String)this.comMode.getSelectedItem());
    }

    @Override
    protected void readFromDataModel() {
        this.cbOpenedOnStart.setSelected(this.data.isOpened());
        this.cbKeepPrefSize.setSelected(this.data.isKeepPrefSize());
        this.cbClosingNotAllowed.setSelected(this.data.isClosingNotAllowed());
        this.cbDraggingNotAllowed.setSelected(this.data.isDraggingNotAllowed());
        this.cbMaximizationNotAllowed.setSelected(this.data.isMaximizationNotAllowed());
        this.cbSlidingNotAllowed.setSelected(this.data.isSlidingNotAllowed());
        this.cbUndockingNotAllowed.setSelected(this.data.isUndockingNotAllowed());
        this.setComModeSelectedItem();
        this.windowPosChanged(null);
        this.checkValidity();
    }

    private void setComModeSelectedItem() {
        if (this.data.getMode() != null) {
            this.comMode.setSelectedItem(this.data.getMode());
        } else {
            this.comMode.setSelectedItem("output");
        }
    }

    @Override
    protected String getPanelName() {
        return BasicSettingsPanel.getMessage("LBL_BasicSettings_Title");
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(BasicSettingsPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(BasicSettingsPanel.class, (String)key);
    }

    private void initComponents() {
        this.lblMode = new JLabel();
        this.comMode = new JComboBox();
        this.cbOpenedOnStart = new JCheckBox();
        this.cbKeepPrefSize = new JCheckBox();
        this.cbSlidingNotAllowed = new JCheckBox();
        this.cbClosingNotAllowed = new JCheckBox();
        this.cbUndockingNotAllowed = new JCheckBox();
        this.cbDraggingNotAllowed = new JCheckBox();
        this.cbMaximizationNotAllowed = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.lblMode.setLabelFor(this.comMode);
        Mnemonics.setLocalizedText((JLabel)this.lblMode, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"LBL_Mode"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.lblMode, gridBagConstraints);
        this.comMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                BasicSettingsPanel.this.windowPosChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 6);
        this.add((Component)this.comMode, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbOpenedOnStart, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"LBL_OpenOnStart"));
        this.cbOpenedOnStart.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbOpenedOnStart.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.cbOpenedOnStart, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbKeepPrefSize, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"LBL_KeepPrefSize"));
        this.cbKeepPrefSize.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbKeepPrefSize.setEnabled(false);
        this.cbKeepPrefSize.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.cbKeepPrefSize, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbSlidingNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_SlidingNotAllowed"));
        this.cbSlidingNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbSlidingNotAllowed.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.cbSlidingNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbClosingNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_ClosingNotAllowed"));
        this.cbClosingNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.cbClosingNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbUndockingNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_UndockingNotAllowed"));
        this.cbUndockingNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.cbUndockingNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbDraggingNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_DraggingNotAllowed"));
        this.cbDraggingNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.cbDraggingNotAllowed, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbMaximizationNotAllowed, (String)NbBundle.getMessage(BasicSettingsPanel.class, (String)"CTL_MaximizationNotAllowed"));
        this.cbMaximizationNotAllowed.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.insets = new Insets(12, 6, 0, 0);
        this.add((Component)this.cbMaximizationNotAllowed, gridBagConstraints);
    }

    private void windowPosChanged(ItemEvent evt) {
        this.cbKeepPrefSize.setEnabled(!"editor".equals(this.comMode.getSelectedItem()));
        if (!this.cbKeepPrefSize.isEnabled()) {
            this.cbKeepPrefSize.setSelected(false);
        }
        this.cbSlidingNotAllowed.setEnabled(!"editor".equals(this.comMode.getSelectedItem()));
        if (!this.cbSlidingNotAllowed.isEnabled()) {
            this.cbSlidingNotAllowed.setSelected(false);
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_BasicSettingsPanel"));
        this.cbOpenedOnStart.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_CTL_OpenOnStart"));
        this.cbKeepPrefSize.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_CTL_KeepPrefSize"));
        this.comMode.getAccessibleContext().setAccessibleDescription(BasicSettingsPanel.getMessage("ACS_CTL_Mode"));
    }
}

