/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.branding.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicCustomizer;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class SuiteCustomizerBasicBranding
extends NbPropertyPanel.Suite {
    private BasicCustomizer.SubCategoryProvider prov;
    private JRadioButton addOn;
    private ButtonGroup buttonGroup1;
    private JLabel lblSpacer;
    private JLabel name;
    private JTextField nameValue;
    private JRadioButton standaloneApp;

    public SuiteCustomizerBasicBranding(SuiteProperties suiteProps, ProjectCustomizer.Category cat, BasicCustomizer.SubCategoryProvider prov) {
        super(suiteProps, SuiteCustomizerBasicBranding.class, cat);
        this.initComponents();
        this.prov = prov;
        this.refresh();
        this.checkValidity();
        UIUtil.DocumentAdapter textFieldChangeListener = new UIUtil.DocumentAdapter(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SuiteCustomizerBasicBranding.this.checkValidity();
            }
        };
        this.nameValue.getDocument().addDocumentListener(textFieldChangeListener);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.prov != null) {
            this.showSubCategory(this.prov);
            this.prov = null;
        }
    }

    protected void checkValidity() {
        boolean panelValid = true;
        if (panelValid && this.nameValue.getText().trim().length() == 0) {
            this.category.setErrorMessage(NbBundle.getMessage(SuiteCustomizerBasicBranding.class, (String)"ERR_EmptyName"));
            panelValid = false;
        }
        if (panelValid && !this.nameValue.getText().trim().matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
            this.category.setErrorMessage(NbBundle.getMessage(SuiteCustomizerBasicBranding.class, (String)"ERR_InvalidName"));
            panelValid = false;
        }
        if (panelValid) {
            this.category.setErrorMessage(null);
        }
        this.category.setValid(panelValid);
    }

    @Override
    protected void refresh() {
        this.getBrandingModel().brandingEnabledRefresh();
        this.getBrandingModel().initName(true);
        this.getBrandingModel().initTitle(true);
        this.standaloneApp.setSelected(this.getBrandingModel().isBrandingEnabled());
        this.addOn.setSelected(!this.getBrandingModel().isBrandingEnabled());
        this.nameValue.setText(this.getBrandingModel().getName());
        this.enableOrDisableComponents();
    }

    @Override
    public void store() {
        this.getBrandingModel().setName(this.nameValue.getText());
    }

    private void enableOrDisableComponents() {
        this.nameValue.setEnabled(this.standaloneApp.isSelected());
        this.name.setEnabled(this.standaloneApp.isSelected());
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.name = new JLabel();
        this.nameValue = new JTextField();
        this.addOn = new JRadioButton();
        this.standaloneApp = new JRadioButton();
        this.lblSpacer = new JLabel();
        this.setLayout(new GridBagLayout());
        this.name.setLabelFor(this.nameValue);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/branding/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.name, (String)bundle.getString("LBL_AppName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.name, gridBagConstraints);
        this.name.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.add((Component)this.nameValue, gridBagConstraints);
        this.buttonGroup1.add(this.addOn);
        Mnemonics.setLocalizedText((AbstractButton)this.addOn, (String)bundle.getString("LBL_AppAddOn"));
        this.addOn.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.addOn.setMargin(new Insets(0, 0, 0, 0));
        this.addOn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerBasicBranding.this.addOnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.addOn, gridBagConstraints);
        this.addOn.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_AddOn"));
        this.buttonGroup1.add(this.standaloneApp);
        Mnemonics.setLocalizedText((AbstractButton)this.standaloneApp, (String)bundle.getString("LBL_AppStandAlone"));
        this.standaloneApp.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.standaloneApp.setMargin(new Insets(0, 0, 0, 0));
        this.standaloneApp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerBasicBranding.this.standaloneAppActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.standaloneApp, gridBagConstraints);
        this.standaloneApp.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_StandAloneApp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.lblSpacer, gridBagConstraints);
    }

    private void standaloneAppActionPerformed(ActionEvent evt) {
        this.enableOrDisableComponents();
        this.getBrandingModel().setBrandingEnabled(this.standaloneApp.isSelected());
    }

    private void addOnActionPerformed(ActionEvent evt) {
        this.enableOrDisableComponents();
        this.getBrandingModel().setBrandingEnabled(this.standaloneApp.isSelected());
    }

    private BasicBrandingModel getBrandingModel() {
        return this.getProperties().getBrandingModel();
    }

    private void showSubCategory(BasicCustomizer.SubCategoryProvider prov) {
        if ("Application".equals(prov.getCategory()) && "standaloneApp".equals(prov.getSubcategory())) {
            this.standaloneApp.requestFocus();
        }
    }
}

