/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.branding;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.suite.BrandingSupport;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BasicBrandingModel {
    private BrandingSupport branding;
    private final SuiteProperties suiteProps;
    private final Project project;
    private final String brandingPath;
    public static final String NAME_PROPERTY = "app.name";
    public static final String TITLE_PROPERTY = "app.title";
    public static final String ICON_LOCATION_PROPERTY = "app.icon";
    public static final String BRANDING_TOKEN_PROPERTY = "branding.token";
    private boolean brandingEnabled;
    private boolean brandingChanged = false;
    private String name;
    private String title;
    @NullAllowed
    private BrandingSupport.BrandedFile icon48 = null;
    private BrandingSupport.BrandedFile icon16 = null;
    private BrandingSupport.BrandedFile icon32 = null;
    private BrandingSupport.BundleKey productInformation = null;
    private BrandingSupport.BundleKey mainWindowTitle = null;
    private BrandingSupport.BundleKey splashWindowTitle = null;
    private BrandingSupport.BundleKey mainWindowTitleNoProject = null;
    private BrandingSupport.BundleKey currentVersion = null;
    private BrandingSupport.BrandedFile splash = null;
    private BrandingSupport.BundleKey splashWidth = null;
    private BrandingSupport.BundleKey splashHeight = null;
    private BrandingSupport.BundleKey splashShowProgressBar = null;
    private BrandingSupport.BundleKey splashRunningTextBounds = null;
    private BrandingSupport.BundleKey splashProgressBarBounds = null;
    private BrandingSupport.BundleKey splashRunningTextFontSize = null;
    private BrandingSupport.BundleKey splashRunningTextColor = null;
    private BrandingSupport.BundleKey splashProgressBarColor = null;
    private BrandingSupport.BundleKey splashProgressBarEdgeColor = null;
    private BrandingSupport.BundleKey splashProgressBarCornerColor = null;
    private final Set<BrandingSupport.BundleKey> splashKeys = new HashSet<BrandingSupport.BundleKey>();
    private BrandingSupport.BundleKey wsEnableDragAndDrop = null;
    private BrandingSupport.BundleKey wsEnableFloating = null;
    private BrandingSupport.BundleKey wsEnableSliding = null;
    private BrandingSupport.BundleKey wsEnableClosingViews = null;
    private BrandingSupport.BundleKey wsEnableClosingEditors = null;
    private BrandingSupport.BundleKey wsEnableResizing = null;
    private BrandingSupport.BundleKey wsEnableMinimumSize = null;
    private BrandingSupport.BundleKey wsEnableMaximization = null;
    private final Set<BrandingSupport.BundleKey> winsysKeys = new HashSet<BrandingSupport.BundleKey>();
    private final Set<BrandingSupport.BundleKey> generalResourceBundleKeys = new HashSet<BrandingSupport.BundleKey>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public BasicBrandingModel(SuiteProperties suiteProps) {
        assert (null != suiteProps);
        this.suiteProps = suiteProps;
        this.project = null;
        this.brandingPath = null;
        this.init();
    }

    public BasicBrandingModel(Project p, String brandingPath) {
        assert (null != p);
        assert (null != brandingPath);
        assert (!brandingPath.isEmpty());
        this.suiteProps = null;
        this.project = p;
        this.brandingPath = brandingPath;
        this.init();
    }

    public boolean isBrandingEnabled() {
        return this.brandingEnabled;
    }

    public void setBrandingEnabled(boolean brandingEnabled) {
        if (this.brandingEnabled != brandingEnabled) {
            this.brandingEnabled = brandingEnabled;
            this.brandingChanged = true;
            this.changeSupport.fireChange();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.isBrandingEnabled()) {
            this.name = name;
            if (null != this.suiteProps) {
                this.suiteProps.setProperty(NAME_PROPERTY, this.getName());
                this.suiteProps.setProperty(BRANDING_TOKEN_PROPERTY, "${app.name}");
            }
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void setTitle(String title) {
        if (this.isBrandingEnabled()) {
            this.title = title;
            if (this.productInformation != null) {
                this.productInformation.setValue(title);
            }
            if (this.mainWindowTitle != null) {
                this.mainWindowTitle.setValue(title + " {0}");
            }
            if (this.splashWindowTitle != null) {
                StringBuilder sb = new StringBuilder();
                sb.append(NbBundle.getMessage(BasicBrandingModel.class, (String)"LBL_splash_window_title_prefix"));
                sb.append(" ").append(title);
                this.splashWindowTitle.setValue(sb.toString());
            }
            if (this.mainWindowTitleNoProject != null) {
                this.mainWindowTitleNoProject.setValue(title + " {0}");
            }
            if (this.currentVersion != null) {
                this.currentVersion.setValue(title + " {0}");
            }
            if (null != this.suiteProps) {
                this.suiteProps.setProperty(TITLE_PROPERTY, this.getTitle());
            }
        }
    }

    public URL getIconSource(int size) {
        switch (size) {
            case 16: {
                return this.icon16 != null ? this.icon16.getBrandingSource() : null;
            }
            case 32: {
                return this.icon32 != null ? this.icon32.getBrandingSource() : null;
            }
            case 48: {
                return this.icon48 != null ? this.icon48.getBrandingSource() : null;
            }
        }
        throw new IllegalArgumentException("Invalid icon size: " + size);
    }

    public void setIconSource(int size, URL url) {
        if (this.isBrandingEnabled()) {
            BrandingSupport.BrandedFile icon = null;
            switch (size) {
                case 16: {
                    icon = this.icon16;
                    break;
                }
                case 32: {
                    icon = this.icon32;
                    break;
                }
                case 48: {
                    icon = this.icon48;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid icon size: " + size);
                }
            }
            if (icon != null) {
                icon.setBrandingSource(url);
            }
            if (null != this.suiteProps) {
                this.suiteProps.setProperty(ICON_LOCATION_PROPERTY, this.getIconLocation());
            }
        }
    }

    @CheckForNull
    public String getIconLocation() {
        if (this.icon48 == null) {
            return null;
        }
        File prj = this.getProjectDirectoryFile();
        String relativePath = PropertyUtils.relativizeFile((File)prj, (File)this.icon48.getFileLocation());
        return relativePath;
    }

    @CheckForNull
    public String getSplashLocation() {
        File prj = this.getProjectDirectoryFile();
        String relativePath = PropertyUtils.relativizeFile((File)prj, (File)this.splash.getFileLocation());
        return relativePath;
    }

    public Project getProject() {
        return null != this.suiteProps ? this.suiteProps.getProject() : this.project;
    }

    public Set<File> getBrandableJars() {
        return this.getBranding().getBrandableJars();
    }

    private File getProjectDirectoryFile() {
        if (null == this.suiteProps) {
            return FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        }
        return this.suiteProps.getProjectDirectoryFile();
    }

    public void store() throws IOException {
        if (this.brandingEnabled) {
            this.getBranding().brandBundleKey(this.productInformation);
            this.getBranding().brandBundleKey(this.mainWindowTitle);
            this.getBranding().brandBundleKey(this.splashWindowTitle);
            this.getBranding().brandBundleKey(this.mainWindowTitleNoProject);
            this.getBranding().brandBundleKey(this.currentVersion);
            if (this.icon48 != null) {
                this.getBranding().brandFile(this.icon48, BasicBrandingModel.getScaleAndStoreIconTask(this.icon48, 48, 48));
            }
            if (this.icon16 != null) {
                this.getBranding().brandFile(this.icon16, BasicBrandingModel.getScaleAndStoreIconTask(this.icon16, 16, 16));
            }
            if (this.icon32 != null) {
                this.getBranding().brandFile(this.icon32, BasicBrandingModel.getScaleAndStoreIconTask(this.icon32, 32, 32));
            }
            this.getBranding().brandBundleKeys(this.splashKeys);
            if (this.splash != null) {
                this.getBranding().brandFile(this.splash);
            }
            this.getBranding().brandBundleKeys(this.winsysKeys);
            this.getBranding().brandBundleKeys(this.generalResourceBundleKeys);
            FileObject root = FileUtil.toFileObject((File)this.getBranding().getBrandingRoot());
            if (null != root) {
                root.refresh();
            }
        } else if (this.brandingChanged && null != this.suiteProps) {
            this.suiteProps.removeProperty(BRANDING_TOKEN_PROPERTY);
            this.suiteProps.removeProperty(NAME_PROPERTY);
            this.suiteProps.removeProperty(TITLE_PROPERTY);
            this.suiteProps.removeProperty(ICON_LOCATION_PROPERTY);
        }
    }

    private static Runnable getScaleAndStoreIconTask(final BrandingSupport.BrandedFile icon, final int width, final int height) throws IOException {
        return new Runnable(){

            @Override
            public void run() {
                BufferedImage bi = new BufferedImage(width, height, 2);
                Graphics2D g2 = bi.createGraphics();
                ImageIcon image = new ImageIcon(icon.getBrandingSource());
                g2.drawImage(image.getImage(), 0, 0, width, height, null);
                g2.dispose();
                try {
                    FileObject fo;
                    File iconLocation = icon.getFileLocation();
                    if (!iconLocation.exists()) {
                        iconLocation.createNewFile();
                    }
                    ImageIO.write((RenderedImage)bi, "png", null == (fo = FileUtil.toFileObject((File)iconLocation)) ? new FileOutputStream(iconLocation) : fo.getOutputStream());
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
        };
    }

    private BrandingSupport getBranding() {
        if (this.branding == null) {
            try {
                this.branding = null == this.suiteProps ? BrandingSupport.getInstance(this.project, this.brandingPath) : BrandingSupport.getInstance(this.suiteProps);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                throw new IllegalStateException(ex.getLocalizedMessage());
            }
        }
        return this.branding;
    }

    private void init() {
        this.initBundleKeys();
        this.initName(false);
        this.initTitle(false);
        this.brandingEnabledRefresh();
        this.brandingChanged = false;
    }

    void brandingEnabledRefresh() {
        this.brandingEnabled = null == this.suiteProps || this.suiteProps.getProperty(BRANDING_TOKEN_PROPERTY) != null;
    }

    private String getSimpleName() {
        if (null == this.suiteProps) {
            String res = this.mainWindowTitle.getValue();
            if (null != res && res.endsWith(" {0}")) {
                res = res.substring(0, res.lastIndexOf(" {0}"));
            }
            if (null == res) {
                res = this.getProjectDirectoryFile().getName();
            }
            return res;
        }
        Element nameEl = XMLUtil.findElement((Element)this.suiteProps.getProject().getHelper().getPrimaryConfigurationData(true), (String)"name", (String)"http://www.netbeans.org/ns/nb-module-suite-project/1");
        String text = nameEl != null ? XMLUtil.findText((Node)nameEl) : null;
        return text != null ? text : "???";
    }

    void initName(boolean reread) {
        if ((this.name == null || reread) && null != this.suiteProps) {
            this.name = this.suiteProps.getProperty(NAME_PROPERTY);
        }
        if (this.name == null) {
            this.name = this.getSimpleName().toLowerCase(Locale.ENGLISH).replaceAll("[^a-z0-9]", "_");
            if (!this.name.matches("[a-z][a-z0-9]*(_[a-z][a-z0-9]*)*")) {
                this.name = "app";
            }
        }
        assert (this.name != null);
    }

    void initTitle(boolean reread) {
        if (this.title == null || reread) {
            String initTitle;
            String string = initTitle = null == this.suiteProps ? null : this.suiteProps.getProperty(TITLE_PROPERTY);
            if (initTitle == null && Character.isLowerCase((initTitle = this.getSimpleName()).charAt(0))) {
                initTitle = String.valueOf(Character.toLowerCase(initTitle.charAt(0))) + initTitle.substring(1);
            }
            assert (initTitle != null);
            this.title = initTitle;
        }
    }

    private void initBundleKeys() {
        this.productInformation = this.getBranding().getBundleKey("org.netbeans.core", "org/netbeans/core/ui/Bundle.properties", "LBL_ProductInformation");
        this.mainWindowTitle = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title");
        this.splashWindowTitle = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "LBL_splash_window_title");
        this.mainWindowTitleNoProject = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/view/ui/Bundle.properties", "CTL_MainWindow_Title_No_Project");
        this.currentVersion = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "currentVersion");
        this.icon48 = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame48.gif");
        this.icon16 = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame.gif");
        this.icon32 = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/frame32.gif");
        this.splash = this.getBranding().getBrandedFile("org.netbeans.core.startup", "org/netbeans/core/startup/splash.gif");
        this.splashWidth = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_WIDTH");
        this.splashHeight = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SPLASH_HEIGHT");
        this.splashShowProgressBar = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashShowProgressBar");
        this.splashRunningTextFontSize = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextFontSize");
        this.splashProgressBarBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarBounds");
        this.splashRunningTextBounds = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextBounds");
        this.splashRunningTextColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashRunningTextColor");
        this.splashProgressBarColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarColor");
        this.splashProgressBarEdgeColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarEdgeColor");
        this.splashProgressBarCornerColor = this.getBranding().getBundleKey("org.netbeans.core.startup", "org/netbeans/core/startup/Bundle.properties", "SplashProgressBarCornerColor");
        this.splashKeys.clear();
        if (this.splashWidth != null) {
            this.splashKeys.add(this.splashWidth);
        }
        if (this.splashHeight != null) {
            this.splashKeys.add(this.splashHeight);
        }
        if (this.splashShowProgressBar != null) {
            this.splashKeys.add(this.splashShowProgressBar);
        }
        if (this.splashRunningTextBounds != null) {
            this.splashKeys.add(this.splashRunningTextBounds);
        }
        if (this.splashProgressBarBounds != null) {
            this.splashKeys.add(this.splashProgressBarBounds);
        }
        if (this.splashRunningTextFontSize != null) {
            this.splashKeys.add(this.splashRunningTextFontSize);
        }
        if (this.splashRunningTextColor != null) {
            this.splashKeys.add(this.splashRunningTextColor);
        }
        if (this.splashProgressBarColor != null) {
            this.splashKeys.add(this.splashProgressBarColor);
        }
        if (this.splashProgressBarEdgeColor != null) {
            this.splashKeys.add(this.splashProgressBarEdgeColor);
        }
        if (this.splashProgressBarCornerColor != null) {
            this.splashKeys.add(this.splashProgressBarCornerColor);
        }
        this.splashKeys.remove(null);
        this.wsEnableClosingEditors = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Editor.TopComponent.Closing.Enabled");
        this.wsEnableClosingViews = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "View.TopComponent.Closing.Enabled");
        this.wsEnableDragAndDrop = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.DragAndDrop.Enabled");
        this.wsEnableFloating = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Undocking.Enabled");
        this.wsEnableMinimumSize = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "Splitter.Respect.MinimumSize.Enabled");
        this.wsEnableResizing = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Resizing.Enabled");
        this.wsEnableSliding = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Sliding.Enabled");
        this.wsEnableMaximization = this.getBranding().getBundleKey("org.netbeans.core.windows", "org/netbeans/core/windows/Bundle.properties", "TopComponent.Maximization.Enabled");
        this.winsysKeys.clear();
        if (this.wsEnableClosingEditors != null) {
            this.winsysKeys.add(this.wsEnableClosingEditors);
        }
        if (this.wsEnableClosingViews != null) {
            this.winsysKeys.add(this.wsEnableClosingViews);
        }
        if (this.wsEnableDragAndDrop != null) {
            this.winsysKeys.add(this.wsEnableDragAndDrop);
        }
        if (this.wsEnableFloating != null) {
            this.winsysKeys.add(this.wsEnableFloating);
        }
        if (this.wsEnableMaximization != null) {
            this.winsysKeys.add(this.wsEnableMaximization);
        }
        if (this.wsEnableMinimumSize != null) {
            this.winsysKeys.add(this.wsEnableMinimumSize);
        }
        if (this.wsEnableResizing != null) {
            this.winsysKeys.add(this.wsEnableResizing);
        }
        if (this.wsEnableSliding != null) {
            this.winsysKeys.add(this.wsEnableSliding);
        }
        this.winsysKeys.remove(null);
        this.generalResourceBundleKeys.clear();
    }

    private String backslashesToSlashes(String text) {
        return text.replace('\\', '/');
    }

    private BrandingSupport.BundleKey findInModifiedGeneralBundleKeys(String codenamebase, String bundlepath, String key) {
        for (BrandingSupport.BundleKey bundleKey : this.generalResourceBundleKeys) {
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return bundleKey;
        }
        return null;
    }

    public void addModifiedGeneralBundleKey(BrandingSupport.BundleKey key) {
        this.generalResourceBundleKeys.add(key);
    }

    public BrandingSupport.BundleKey getGeneralBundleKeyForModification(String codenamebase, String bundlepath, String key) {
        BrandingSupport.BundleKey bKey = this.findInModifiedGeneralBundleKeys(codenamebase, bundlepath, key);
        return null != bKey ? bKey : this.getBranding().getBundleKey(codenamebase, bundlepath, key);
    }

    public String getKeyValue(String bundlepath, String codenamebase, String key) {
        BrandingSupport.BundleKey bKey = this.findInModifiedGeneralBundleKeys(codenamebase, bundlepath, key);
        return null != bKey ? bKey.getValue() : this.getBranding().getBundleKey(codenamebase, bundlepath, key).getValue();
    }

    public boolean isKeyBranded(String bundlepath, String codenamebase, String key) {
        for (BrandingSupport.BundleKey bundleKey : this.generalResourceBundleKeys) {
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        Set<BrandingSupport.BundleKey> bundleKeys = this.getBranding().getBrandedBundleKeys();
        for (BrandingSupport.BundleKey bundleKey : bundleKeys) {
            if (!key.equals(bundleKey.getKey()) || !this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    public boolean isBundleBranded(String bundlepath, String codenamebase) {
        for (BrandingSupport.BundleKey bundleKey : this.generalResourceBundleKeys) {
            if (!this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        Set<BrandingSupport.BundleKey> bundleKeys = this.getBranding().getBrandedBundleKeys();
        for (BrandingSupport.BundleKey bundleKey : bundleKeys) {
            if (!this.backslashesToSlashes(bundleKey.getBundleFilePath()).endsWith(bundlepath) || !codenamebase.equals(bundleKey.getModuleEntry().getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashWidth() {
        return this.splashWidth;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashHeight() {
        return this.splashHeight;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashShowProgressBar() {
        return this.splashShowProgressBar;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashRunningTextBounds() {
        return this.splashRunningTextBounds;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashProgressBarBounds() {
        return this.splashProgressBarBounds;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashRunningTextFontSize() {
        return this.splashRunningTextFontSize;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashRunningTextColor() {
        return this.splashRunningTextColor;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashProgressBarColor() {
        return this.splashProgressBarColor;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashProgressBarEdgeColor() {
        return this.splashProgressBarEdgeColor;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getSplashProgressBarCornerColor() {
        return this.splashProgressBarCornerColor;
    }

    @CheckForNull
    public BrandingSupport.BrandedFile getSplash() {
        return this.splash;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getWsEnableClosingEditors() {
        return this.wsEnableClosingEditors;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getWsEnableClosingViews() {
        return this.wsEnableClosingViews;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getWsEnableDragAndDrop() {
        return this.wsEnableDragAndDrop;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getWsEnableFloating() {
        return this.wsEnableFloating;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getWsEnableMaximization() {
        return this.wsEnableMaximization;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getWsEnableMinimumSize() {
        return this.wsEnableMinimumSize;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getWsEnableResizing() {
        return this.wsEnableResizing;
    }

    @CheckForNull
    public BrandingSupport.BundleKey getWsEnableSliding() {
        return this.wsEnableSliding;
    }

    SuiteProperties getSuiteProperties() {
        return this.suiteProps;
    }
}

