/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.retriever.catalog.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.xml.retriever.catalog.CatalogElement;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogEntryImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapper;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogFileWrapperDOMImpl;
import org.netbeans.modules.xml.retriever.catalog.impl.CatalogModelImpl;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CatalogWriteModelImpl
extends CatalogModelImpl
implements CatalogWriteModel {
    public static final String PROPERTY_CHANGE_PROPERTY_KEY = "CatalogModelImpl.PropertyChange.Property";
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static Logger logger = Logger.getLogger(CatalogWriteModelImpl.class.getName());
    private Model.State currentStateOfCatalog;
    private CatalogFileWrapper catalogWrapper = null;
    boolean unitTestSaveStrategy = false;

    protected CatalogWriteModelImpl(Project prj) throws IOException {
        super(prj);
    }

    protected CatalogWriteModelImpl(FileObject catalogFileObject) throws IOException {
        super(catalogFileObject);
    }

    public CatalogWriteModelImpl(File myProjectRootFile) throws IOException {
        super(myProjectRootFile);
        this.unitTestSaveStrategy = true;
    }

    public CatalogWriteModelImpl() {
    }

    @Override
    public URI searchURI(URI locationURI) {
        File publicCatalogFile;
        if (locationURI == null) {
            return null;
        }
        this.bootStrapCatalog();
        URI strRes = null;
        if (this.catalogFileObject != null && (publicCatalogFile = FileUtil.toFile((FileObject)this.catalogFileObject)).isFile()) {
            try {
                strRes = this.resolveUsingApacheCatalog(publicCatalogFile, locationURI.toString());
            }
            catch (IOException ex) {
                return null;
            }
            catch (CatalogModelException ex) {
                return null;
            }
        }
        return strRes;
    }

    @Override
    public Model.State getState() {
        return this.currentStateOfCatalog;
    }

    @Override
    public synchronized void addURI(URI locationURI, FileObject fileObj) throws IOException {
        URI fileObjURI = FileUtil.toFile((FileObject)fileObj).toURI();
        this.addURI(locationURI, fileObjURI);
    }

    @Override
    public synchronized void addURI(URI locationURI, URI fileObjURI) throws IOException {
        if (this.catalogFileObject == null) {
            return;
        }
        this.removeURI(locationURI);
        this.bootStrapCatalog();
        URI master = FileUtil.toFile((FileObject)this.catalogFileObject).toURI();
        String finalDestStr = Utilities.relativize(master, fileObjURI);
        CatalogEntryImpl catEnt = new CatalogEntryImpl(CatalogElement.system, locationURI.toString(), finalDestStr);
        this.catalogWrapper.addSystem(catEnt);
    }

    public String toString() {
        return "This Public Catalog FO:" + this.catalogFileObject;
    }

    @Override
    public synchronized void removeURI(URI locationURI) throws IOException {
        logger.finer("ENTRING:" + locationURI);
        if (this.catalogFileObject == null) {
            return;
        }
        this.bootStrapCatalog();
        List<CatalogEntry> catEntList = this.catalogWrapper.getSystems();
        if (catEntList == null) {
            return;
        }
        CatalogEntry remVal = null;
        for (CatalogEntry catEnt : catEntList) {
            if (!catEnt.getSource().equals(locationURI.toString())) continue;
            remVal = catEnt;
        }
        logger.finer("Removing Value: " + remVal);
        if (remVal == null) {
            return;
        }
        int index = catEntList.indexOf(remVal);
        this.catalogWrapper.deleteSystem(index);
        if (catEntList.size() == 1) {
            logger.finer("There are no more entries so removing catalog file");
        }
        logger.finer("RETURN: " + catEntList.size());
    }

    @Override
    public Collection<CatalogEntry> getCatalogEntries() {
        if (this.catalogFileObject == null) {
            return Collections.emptyList();
        }
        this.bootStrapCatalog();
        List<CatalogEntry> catEntList = this.catalogWrapper.getSystems();
        if (catEntList == null) {
            return Collections.emptyList();
        }
        for (CatalogEntry catEnt : catEntList) {
            ((CatalogEntryImpl)catEnt).setCatalogModel(this);
        }
        return catEntList;
    }

    @Override
    public boolean isWellformed() {
        this.bootStrapCatalog();
        this.currentStateOfCatalog = this.catalogWrapper.getCatalogState();
        return this.currentStateOfCatalog != Model.State.NOT_WELL_FORMED;
    }

    @Override
    public FileObject getCatalogFileObject() {
        return this.catalogFileObject;
    }

    @Override
    public void addPropertychangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(PROPERTY_CHANGE_PROPERTY_KEY, pcl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(PROPERTY_CHANGE_PROPERTY_KEY, pcl);
    }

    private synchronized void bootStrapCatalog() {
        if (this.catalogWrapper == null) {
            try {
                this.catalogWrapper = CatalogFileWrapperDOMImpl.getInstance(this.catalogFileObject, this.unitTestSaveStrategy);
                if (this.catalogWrapper == null) {
                    throw new IllegalStateException("Could not get CatalogFileWrapper");
                }
                this.currentStateOfCatalog = this.catalogWrapper.getCatalogState();
                this.catalogWrapper.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        CatalogWriteModelImpl.this.pcs.firePropertyChange(evt);
                        CatalogWriteModelImpl.this.currentStateOfCatalog = CatalogWriteModelImpl.this.catalogWrapper.getCatalogState();
                    }
                });
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (this.catalogWrapper != null && this.catalogWrapper.getCatalogState() == Model.State.NOT_WELL_FORMED) {
            throw new IllegalStateException("Catalog file not wellformed");
        }
    }

    @Override
    public void addNextCatalog(URI nextCatalogFileURI, boolean relativize) throws IOException {
        if (this.catalogFileObject == null) {
            return;
        }
        String nextCatalogFileURIStr = nextCatalogFileURI.toString();
        if (nextCatalogFileURI.isAbsolute() && relativize) {
            nextCatalogFileURIStr = Utilities.relativize(FileUtil.toFile((FileObject)this.catalogFileObject).toURI(), nextCatalogFileURI);
        }
        try {
            this.removeNextCatalog(new URI(nextCatalogFileURIStr));
        }
        catch (URISyntaxException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.bootStrapCatalog();
        CatalogEntryImpl catEnt = new CatalogEntryImpl(CatalogElement.nextCatalog, nextCatalogFileURIStr, null);
        this.catalogWrapper.addNextCatalog(catEnt);
    }

    @Override
    public void removeNextCatalog(URI nextCatalogFileRelativeURI) throws IOException {
        logger.finer("ENTRING:" + nextCatalogFileRelativeURI);
        if (this.catalogFileObject == null) {
            return;
        }
        this.bootStrapCatalog();
        List<CatalogEntry> catEntList = this.catalogWrapper.getNextCatalogs();
        if (catEntList == null) {
            return;
        }
        CatalogEntry remVal = null;
        for (CatalogEntry catEnt : catEntList) {
            if (!catEnt.getSource().equals(nextCatalogFileRelativeURI.toString())) continue;
            remVal = catEnt;
        }
        logger.finer("Removing Value: " + remVal);
        if (remVal == null) {
            return;
        }
        int index = catEntList.indexOf(remVal);
        this.catalogWrapper.deleteNextCatalog(index);
        if (catEntList.size() == 1) {
            logger.finer("There are no more entries so removing catalog file");
        }
        logger.finer("RETURN: " + catEntList.size());
    }
}

