/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.elements.AstElement;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.openide.filesystems.FileObject;

public class GroovyRefactoringElement
extends AstElement {
    private final ModuleNode root;
    private final FileObject fileObject;
    private final AstPath path;

    public GroovyRefactoringElement(GroovyParserResult groovyParserResult, ModuleNode moduleNode, ASTNode aSTNode, FileObject fileObject) {
        super(groovyParserResult, aSTNode);
        this.root = moduleNode;
        this.fileObject = fileObject;
        this.path = new AstPath((ASTNode)moduleNode, aSTNode.getLineNumber(), aSTNode.getColumnNumber());
    }

    public String getFindName() {
        if (this.node instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)this.node;
            return fieldNode.getType().getNameWithoutPackage();
        }
        if (this.node instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)this.node;
            return variableExpression.getType().getNameWithoutPackage();
        }
        return this.getNode().getText();
    }

    public String getName() {
        if (this.node instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)this.node;
            return fieldNode.getName();
        }
        if (this.node instanceof VariableExpression) {
            VariableExpression variableExpression = (VariableExpression)this.node;
            return variableExpression.getName();
        }
        return this.getNode().getText();
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public Object getSimpleName() {
        if (this.node instanceof FieldNode) {
            return ((FieldNode)this.node).getName();
        }
        if (this.node instanceof MethodNode) {
            return ((MethodNode)this.node).getName();
        }
        if (this.node instanceof ClassNode) {
            return ((ClassNode)this.node).getNameWithoutPackage();
        }
        return this.getName();
    }

    public String getDefClass() {
        return AstUtilities.getFqnName((AstPath)this.path);
    }

    public ElementKind getKind() {
        if (this.node instanceof FieldNode) {
            return ElementKind.FIELD;
        }
        if (this.node instanceof MethodNode) {
            return ElementKind.METHOD;
        }
        if (this.node instanceof ClassNode) {
            return ElementKind.CLASS;
        }
        return super.getKind();
    }
}

