/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.WeakSharedSet;

public abstract class APTStringManager {
    private static final Map<String, APTStringManager> instances = Collections.synchronizedMap(new HashMap());
    private static final int STRING_MANAGER_DEFAULT_CAPACITY;
    private static final int STRING_MANAGER_DEFAULT_SLICED_NUMBER;
    static final String TEXT_MANAGER = "Manager of sharable texts";
    static final int TEXT_MANAGER_INITIAL_CAPACITY;
    static final String FILE_PATH_MANAGER = "Manager of sharable file paths";
    static final int FILE_PATH_MANAGER_INITIAL_CAPACITY;

    public abstract CharSequence getString(CharSequence var1);

    public abstract void dispose();

    public static APTStringManager instance(String name, CacheKind kind) {
        switch (kind) {
            case Single: {
                return APTStringManager.instance(name, STRING_MANAGER_DEFAULT_CAPACITY);
            }
            case Sliced: {
                return APTStringManager.instance(name, STRING_MANAGER_DEFAULT_SLICED_NUMBER, STRING_MANAGER_DEFAULT_CAPACITY);
            }
        }
        throw new IllegalArgumentException();
    }

    private static APTStringManager instance(String name, int initialCapacity) {
        APTStringManager instance = instances.get(name);
        if (instance == null) {
            instance = new APTSingleStringManager(name, initialCapacity);
            instances.put(name, instance);
        }
        return instance;
    }

    private static APTStringManager instance(String name, int sliceNumber, int initialCapacity) {
        APTStringManager instance = instances.get(name);
        if (instance == null) {
            instance = new APTCompoundStringManager(name, sliceNumber, initialCapacity);
            instances.put(name, instance);
        }
        return instance;
    }

    static {
        int nrProc = CndUtils.getConcurrencyLevel();
        if (nrProc <= 4) {
            STRING_MANAGER_DEFAULT_SLICED_NUMBER = 32;
            STRING_MANAGER_DEFAULT_CAPACITY = 512;
        } else {
            STRING_MANAGER_DEFAULT_SLICED_NUMBER = 128;
            STRING_MANAGER_DEFAULT_CAPACITY = 128;
        }
        TEXT_MANAGER_INITIAL_CAPACITY = STRING_MANAGER_DEFAULT_CAPACITY;
        FILE_PATH_MANAGER_INITIAL_CAPACITY = STRING_MANAGER_DEFAULT_CAPACITY;
    }

    static final class APTCompoundStringManager
    extends APTStringManager {
        private final APTStringManager[] instances;
        private final int segmentMask;
        private final String name;

        APTCompoundStringManager(String name, int sliceNumber) {
            this(name, sliceNumber, TEXT_MANAGER_INITIAL_CAPACITY);
        }

        APTCompoundStringManager(String name, int sliceNumber, int initialCapacity) {
            int ssize;
            for (ssize = 1; ssize < sliceNumber; ssize <<= 1) {
            }
            this.segmentMask = ssize - 1;
            this.instances = new APTStringManager[ssize];
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i] = new APTSingleStringManager(name, initialCapacity);
            }
            this.name = name;
        }

        private APTStringManager getDelegate(CharSequence text) {
            if (text == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            int index = text.hashCode() & this.segmentMask;
            return this.instances[index];
        }

        @Override
        public final CharSequence getString(CharSequence text) {
            return this.getDelegate(text).getString(text);
        }

        @Override
        public final void dispose() {
            for (int i = 0; i < this.instances.length; ++i) {
                this.instances[i].dispose();
            }
        }
    }

    static final class APTSingleStringManager
    extends APTStringManager {
        private final WeakSharedSet<CharSequence> storage;
        private final int initialCapacity;
        private final String name;
        private final Object lock = new Lock();

        private APTSingleStringManager(String name, int initialCapacity) {
            this.storage = new WeakSharedSet(initialCapacity);
            this.initialCapacity = initialCapacity;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final CharSequence getString(CharSequence text) {
            if (text == null) {
                throw new NullPointerException("null string is illegal to share");
            }
            CharSequence outText = null;
            Object object = this.lock;
            synchronized (object) {
                outText = this.storage.putIfAbsent(text);
            }
            assert (outText != null);
            assert (outText.equals(text));
            return outText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void dispose() {
            if (CndTraceFlags.TRACE_SLICE_DISTIBUTIONS) {
                Object[] arr;
                Object object = this.lock;
                synchronized (object) {
                    arr = this.storage.toArray();
                }
                System.out.println("Dispose cache " + this.name + " " + arr.length + " " + this.getClass().getName());
                HashMap classes = new HashMap();
                for (Object o : arr) {
                    if (o == null) continue;
                    Integer i = (Integer)classes.get(o.getClass());
                    i = i != null ? Integer.valueOf(i + 1) : Integer.valueOf(1);
                    classes.put(o.getClass(), i);
                }
                for (Map.Entry e : classes.entrySet()) {
                    System.out.println("   " + e.getValue() + " of " + ((Class)e.getKey()).getName());
                }
            }
            if (this.storage.size() > 0) {
                this.storage.clear();
                this.storage.resize(this.initialCapacity);
            }
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    public static enum CacheKind {
        Single,
        Sliced;

    }
}

