/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.navigation.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.java.navigation.ClassMemberFilters;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public abstract class SortActionSupport
extends AbstractAction
implements Presenter.Popup {
    private JRadioButtonMenuItem menuItem;
    protected ClassMemberFilters filters;
    public static final String SELECTED = "selected";

    public SortActionSupport(ClassMemberFilters filters) {
        this.filters = filters;
    }

    public final JMenuItem getPopupPresenter() {
        JRadioButtonMenuItem result = this.obtainMenuItem();
        this.updateMenuItem();
        return result;
    }

    protected final JRadioButtonMenuItem obtainMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            this.menuItem.setAction(this);
        }
        return this.menuItem;
    }

    protected abstract void updateMenuItem();

    public static final class SortBySourceAction
    extends SortActionSupport {
        public SortBySourceAction(ClassMemberFilters filters) {
            super(filters);
            this.putValue("Name", NbBundle.getMessage(SortBySourceAction.class, (String)"LBL_SortBySource"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/sortPosition.png", (boolean)false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filters.setNaturalSort(true);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(this.filters.isNaturalSort());
        }
    }

    public static final class SortByNameAction
    extends SortActionSupport {
        public SortByNameAction(ClassMemberFilters filters) {
            super(filters);
            this.putValue("Name", NbBundle.getMessage(SortByNameAction.class, (String)"LBL_SortByName"));
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/java/navigation/resources/sortAlpha.png", (boolean)false));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filters.setNaturalSort(false);
            this.updateMenuItem();
        }

        @Override
        protected void updateMenuItem() {
            JRadioButtonMenuItem mi = this.obtainMenuItem();
            mi.setSelected(!this.filters.isNaturalSort());
        }
    }
}

