/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import com.jrjackson.RubyKeyConverter;
import com.jrjackson.RubyStringConverter;
import com.jrjackson.RubySymbolConverter;
import com.jrjackson.RubyUtils;
import java.io.IOException;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyHash;
import org.jruby.RubyObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyObjectDeserializer
extends StdDeserializer<RubyObject> {
    private static final long serialVersionUID = 1L;
    private Ruby _ruby;
    private RubyKeyConverter key_converter;
    private final RubyStringConverter str_converter = new RubyStringConverter();

    public RubyObjectDeserializer() {
        super(RubyObject.class);
    }

    public RubyObjectDeserializer withRuby(Ruby ruby) {
        this._ruby = ruby;
        return this;
    }

    public RubyObjectDeserializer setStringStrategy() {
        this.key_converter = this.str_converter;
        return this;
    }

    public RubyObjectDeserializer setSymbolStrategy() {
        this.key_converter = new RubySymbolConverter();
        return this;
    }

    @Override
    public RubyObject deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        switch (jp.getCurrentToken()) {
            case START_OBJECT: {
                return this.mapObject(jp, ctxt);
            }
            case START_ARRAY: {
                return this.mapArray(jp, ctxt);
            }
            case FIELD_NAME: {
                return this.key_converter.convert(this._ruby, jp);
            }
            case VALUE_EMBEDDED_OBJECT: {
                return RubyUtils.rubyObject(this._ruby, jp.getEmbeddedObject());
            }
            case VALUE_STRING: {
                return this.str_converter.convert(this._ruby, jp);
            }
            case VALUE_NUMBER_INT: {
                JsonParser.NumberType numberType = jp.getNumberType();
                if (ctxt.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS) || numberType == JsonParser.NumberType.BIG_INTEGER) {
                    return RubyUtils.rubyBignum(this._ruby, jp.getBigIntegerValue());
                }
                return RubyUtils.rubyFixnum(this._ruby, jp.getLongValue());
            }
            case VALUE_NUMBER_FLOAT: {
                if (ctxt.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return RubyUtils.rubyBigDecimal(this._ruby, jp.getDecimalValue());
                }
                return RubyUtils.rubyFloat(this._ruby, jp.getDoubleValue());
            }
            case VALUE_TRUE: {
                return this._ruby.newBoolean(Boolean.TRUE.booleanValue());
            }
            case VALUE_FALSE: {
                return this._ruby.newBoolean(Boolean.FALSE.booleanValue());
            }
            case VALUE_NULL: {
                return (RubyObject)this._ruby.getNil();
            }
        }
        throw ctxt.mappingException(Object.class);
    }

    protected RubyObject mapArray(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.nextToken() == JsonToken.END_ARRAY) {
            return RubyArray.newArray((Ruby)this._ruby);
        }
        ObjectBuffer buffer = ctxt.leaseObjectBuffer();
        Object[] values = buffer.resetAndStart();
        int ptr = 0;
        long totalSize = 0L;
        do {
            RubyObject value = this.deserialize(jp, ctxt);
            ++totalSize;
            if (ptr >= values.length) {
                values = buffer.appendCompletedChunk(values);
                ptr = 0;
            }
            values[ptr++] = value;
        } while (jp.nextToken() != JsonToken.END_ARRAY);
        RubyArray result = RubyArray.newArray((Ruby)this._ruby, (long)(totalSize + (totalSize >> 3) + 1L));
        buffer.completeAndClearBuffer(values, ptr, (List<Object>)result);
        return result;
    }

    protected RubyObject mapObject(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.START_OBJECT) {
            t = jp.nextToken();
        }
        if (t != JsonToken.FIELD_NAME) {
            return RubyHash.newHash((Ruby)this._ruby);
        }
        RubyObject field1 = this.key_converter.convert(this._ruby, jp);
        jp.nextToken();
        RubyObject value1 = this.deserialize(jp, ctxt);
        if (jp.nextToken() != JsonToken.FIELD_NAME) {
            return RuntimeHelpers.constructHash((Ruby)this._ruby, (IRubyObject)field1, (IRubyObject)value1);
        }
        RubyObject field2 = this.key_converter.convert(this._ruby, jp);
        jp.nextToken();
        RubyObject value2 = this.deserialize(jp, ctxt);
        if (jp.nextToken() != JsonToken.FIELD_NAME) {
            return RuntimeHelpers.constructHash((Ruby)this._ruby, (IRubyObject)field1, (IRubyObject)value1, (IRubyObject)field2, (IRubyObject)value2);
        }
        RubyHash result = RuntimeHelpers.constructHash((Ruby)this._ruby, (IRubyObject)field1, (IRubyObject)value1, (IRubyObject)field2, (IRubyObject)value2);
        do {
            RubyObject fieldName = this.key_converter.convert(this._ruby, jp);
            jp.nextToken();
            result.fastASetCheckString(this._ruby, (IRubyObject)fieldName, (IRubyObject)this.deserialize(jp, ctxt));
        } while (jp.nextToken() != JsonToken.END_OBJECT);
        return result;
    }
}

