/*
 * Decompiled with CFR 0.152.
 */
package com.jrjackson;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.jrjackson.RubyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.ext.bigdecimal.RubyBigDecimal;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyAnySerializer
extends StdSerializer<IRubyObject> {
    public static final RubyAnySerializer instance = new RubyAnySerializer();
    private static final HashMap<Class, Class> class_maps = new HashMap();

    public RubyAnySerializer() {
        super(IRubyObject.class);
    }

    private Class<?> rubyJavaClassLookup(Class target) {
        return class_maps.get(target);
    }

    private void serializeUnknownRubyObject(ThreadContext ctx, IRubyObject rubyObject, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        RubyClass meta = rubyObject.getMetaClass();
        DynamicMethod method = meta.searchMethod("to_time");
        if (!method.isUndefined()) {
            RubyTime dt = (RubyTime)method.call(ctx, rubyObject, (RubyModule)meta, "to_time");
            String time = RubyUtils.jodaTimeString(dt.getDateTime());
            jgen.writeString(time);
            return;
        }
        method = meta.searchMethod("to_h");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_h");
            provider.findTypedValueSerializer(Map.class, true, null).serialize(obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_hash");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_hash");
            provider.findTypedValueSerializer(Map.class, true, null).serialize(obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_a");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_a");
            provider.findTypedValueSerializer(List.class, true, null).serialize(obj, jgen, provider);
            return;
        }
        method = meta.searchMethod("to_json");
        if (!method.isUndefined()) {
            RubyObject obj = (RubyObject)method.call(ctx, rubyObject, (RubyModule)meta, "to_json");
            if (obj instanceof RubyString) {
                jgen.writeRawValue(obj.toString());
            } else {
                provider.defaultSerializeValue(obj, jgen);
            }
            return;
        }
        throw new JsonGenerationException("Cannot find Serializer for class: " + rubyObject.getClass().getName());
    }

    @Override
    public void serialize(IRubyObject value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        ThreadContext ctx = value.getRuntime().getCurrentContext();
        if (value.isNil()) {
            jgen.writeNull();
        } else if (value instanceof RubyString) {
            jgen.writeString(value.toString());
        } else if (value instanceof RubySymbol) {
            jgen.writeString(value.toString());
        } else if (value instanceof RubyBoolean) {
            jgen.writeBoolean(value.isTrue());
        } else if (value instanceof RubyFloat) {
            jgen.writeNumber(RubyNumeric.num2dbl((IRubyObject)value));
        } else if (value instanceof RubyFixnum) {
            jgen.writeNumber(RubyNumeric.num2long((IRubyObject)value));
        } else if (value instanceof RubyBignum) {
            jgen.writeNumber(((RubyBignum)value).getBigIntegerValue());
        } else if (value instanceof RubyBigDecimal) {
            jgen.writeNumber(((RubyBigDecimal)value).getBigDecimalValue());
        } else if (value instanceof RubyHash) {
            provider.findTypedValueSerializer(value.getJavaClass(), true, null).serialize(value, jgen, provider);
        } else if (value instanceof RubyArray) {
            provider.findTypedValueSerializer(value.getJavaClass(), true, null).serialize(value, jgen, provider);
        } else if (value instanceof RubyStruct) {
            IRubyObject obj = value.callMethod(ctx, "to_a");
            provider.findTypedValueSerializer(obj.getJavaClass(), true, null).serialize(obj, jgen, provider);
        } else {
            Class<?> cls = this.rubyJavaClassLookup(value.getClass());
            if (cls != null) {
                Object val = value.toJava(cls);
                if (val != null) {
                    provider.defaultSerializeValue(val, jgen);
                } else {
                    this.serializeUnknownRubyObject(ctx, value, jgen, provider);
                }
            } else {
                this.serializeUnknownRubyObject(ctx, value, jgen, provider);
            }
        }
    }

    @Override
    public void serializeWithType(IRubyObject value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
        typeSer.writeTypePrefixForScalar(value, jgen);
        this.serialize(value, jgen, provider);
        typeSer.writeTypeSuffixForScalar(value, jgen);
    }

    static {
        class_maps.put(RubyBoolean.class, Boolean.class);
        class_maps.put(RubyFloat.class, Double.class);
        class_maps.put(RubyFixnum.class, Long.class);
        class_maps.put(RubyBignum.class, BigInteger.class);
        class_maps.put(RubyBigDecimal.class, BigDecimal.class);
    }
}

