/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class StringFieldPropertyWriter
extends OptimizedBeanPropertyWriter<StringFieldPropertyWriter> {
    public StringFieldPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new StringFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public StringFieldPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new StringFieldPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
            return;
        }
        try {
            String value = this._propertyAccessor.stringField(bean, this._propertyIndex);
            if (value == null) {
                if (!this._suppressNulls) {
                    jgen.writeFieldName(this._name);
                    prov.defaultSerializeNull(jgen);
                }
                return;
            }
            if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? value.length() == 0 : this._suppressableValue.equals(value))) {
                return;
            }
            jgen.writeFieldName(this._name);
            jgen.writeString(value);
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (!this.broken) {
            try {
                String value = this._propertyAccessor.stringField(bean, this._propertyIndex);
                if (value == null) {
                    if (this._suppressNulls) {
                        this.serializeAsPlaceholder(bean, jgen, prov);
                    } else {
                        prov.defaultSerializeNull(jgen);
                    }
                    return;
                }
                if (this._suppressableValue != null) {
                    if (MARKER_FOR_EMPTY == this._suppressableValue) {
                        if (value.length() == 0) {
                            this.serializeAsPlaceholder(bean, jgen, prov);
                            return;
                        }
                    } else if (this._suppressableValue.equals(value)) {
                        this.serializeAsPlaceholder(bean, jgen, prov);
                        return;
                    }
                }
                jgen.writeString(value);
                return;
            }
            catch (IllegalAccessError e) {
                this._reportProblem(bean, e);
            }
            catch (SecurityException e) {
                this._reportProblem(bean, e);
            }
        }
        this.fallbackWriter.serializeAsElement(bean, jgen, prov);
    }
}

