/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class LongFieldPropertyWriter
extends OptimizedBeanPropertyWriter<LongFieldPropertyWriter> {
    private final long _suppressableLong;
    private final boolean _suppressableLongSet;

    public LongFieldPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (MARKER_FOR_EMPTY == this._suppressableValue) {
            this._suppressableLong = 0L;
            this._suppressableLongSet = true;
        } else if (this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableLongSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableLongSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new LongFieldPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public LongFieldPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new LongFieldPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
            return;
        }
        try {
            long value = this._propertyAccessor.longField(bean, this._propertyIndex);
            if (!this._suppressableLongSet || this._suppressableLong != value) {
                jgen.writeFieldName(this._name);
                jgen.writeNumber(value);
            }
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, e);
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (!this.broken) {
            try {
                long value = this._propertyAccessor.longField(bean, this._propertyIndex);
                if (!this._suppressableLongSet || this._suppressableLong != value) {
                    jgen.writeNumber(value);
                } else {
                    this.serializeAsPlaceholder(bean, jgen, prov);
                }
                return;
            }
            catch (IllegalAccessError e) {
                this._reportProblem(bean, e);
            }
            catch (SecurityException e) {
                this._reportProblem(bean, e);
            }
        }
        this.fallbackWriter.serializeAsElement(bean, jgen, prov);
    }
}

