/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class IntMethodPropertyWriter
extends OptimizedBeanPropertyWriter<IntMethodPropertyWriter> {
    private final int _suppressableInt;
    private final boolean _suppressableIntSet;

    public IntMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (MARKER_FOR_EMPTY == this._suppressableValue) {
            this._suppressableInt = 0;
            this._suppressableIntSet = true;
        } else if (this._suppressableValue instanceof Integer) {
            this._suppressableInt = (Integer)this._suppressableValue;
            this._suppressableIntSet = true;
        } else {
            this._suppressableInt = 0;
            this._suppressableIntSet = false;
        }
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new IntMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public IntMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new IntMethodPropertyWriter(this, acc, this._propertyIndex, this._serializer);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, jgen, prov);
            return;
        }
        try {
            int value = this._propertyAccessor.intGetter(bean, this._propertyIndex);
            if (!this._suppressableIntSet || this._suppressableInt != value) {
                jgen.writeFieldName(this._name);
                jgen.writeNumber(value);
            }
            return;
        }
        catch (IllegalAccessError e) {
            this._reportProblem(bean, e);
        }
        catch (SecurityException e) {
            this._reportProblem(bean, e);
        }
        this.fallbackWriter.serializeAsField(bean, jgen, prov);
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (!this.broken) {
            try {
                int value = this._propertyAccessor.intGetter(bean, this._propertyIndex);
                if (!this._suppressableIntSet || this._suppressableInt != value) {
                    jgen.writeNumber(value);
                } else {
                    this.serializeAsPlaceholder(bean, jgen, prov);
                }
                return;
            }
            catch (IllegalAccessError e) {
                this._reportProblem(bean, e);
            }
            catch (SecurityException e) {
                this._reportProblem(bean, e);
            }
        }
        this.fallbackWriter.serializeAsElement(bean, jgen, prov);
    }
}

