/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CRLEntry;
import java.util.Collections;
import java.util.Set;
import org.joda.time.DateTime;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.openssl.BN;
import org.jruby.ext.openssl.ObjectSupport;
import org.jruby.ext.openssl.X509;
import org.jruby.ext.openssl.X509Extension;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class X509Revoked
extends RubyObject {
    private static final long serialVersionUID = -6238325248555061878L;
    private static ObjectAllocator X509REVOKED_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new X509Revoked(runtime, klass);
        }
    };
    BN serial;
    RubyArray extensions;
    RubyTime time;

    public static void createX509Revoked(Ruby runtime, RubyModule _X509) {
        RubyClass _Revoked = _X509.defineClassUnder("Revoked", runtime.getObject(), X509REVOKED_ALLOCATOR);
        RubyClass _OpenSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        _X509.defineClassUnder("RevokedError", _OpenSSLError, _OpenSSLError.getAllocator());
        _Revoked.defineAnnotatedMethods(X509Revoked.class);
    }

    static RubyClass _Revoked(Ruby runtime) {
        return X509._X509(runtime).getClass("Revoked");
    }

    static X509Revoked newInstance(ThreadContext context, X509CRLEntry entry) {
        Ruby runtime = context.runtime;
        X509Revoked revoked2 = new X509Revoked(runtime, X509Revoked._Revoked(runtime));
        revoked2.serial = BN.newInstance(runtime, entry.getSerialNumber());
        revoked2.time = RubyTime.newTime((Ruby)runtime, (long)entry.getRevocationDate().getTime());
        if (entry.hasExtensions()) {
            Set<String> nonCriticalExtOIDs;
            Set<String> criticalExtOIDs = entry.getCriticalExtensionOIDs();
            if (criticalExtOIDs != null) {
                for (String extOID : criticalExtOIDs) {
                    revoked2.addExtension(context, entry, extOID, true);
                }
            }
            if ((nonCriticalExtOIDs = entry.getNonCriticalExtensionOIDs()) != null) {
                for (String extOID : nonCriticalExtOIDs) {
                    revoked2.addExtension(context, entry, extOID, false);
                }
            }
        }
        return revoked2;
    }

    private void addExtension(ThreadContext context, X509CRLEntry entry, String extOID, boolean critical) {
        try {
            X509Extension extension = X509Extension.newExtension(context, extOID, entry, critical);
            if (extension != null) {
                this.extensions().append((IRubyObject)extension);
            }
        }
        catch (IOException e) {
            throw X509Extension.newExtensionError(context.runtime, e);
        }
    }

    public X509Revoked(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    @JRubyMethod(name={"initialize"}, rest=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args) {
        this.serial = BN.newInstance(context.runtime, BigInteger.ZERO);
        return this;
    }

    BigInteger getSerial() {
        return this.serial.getValue();
    }

    @JRubyMethod
    public IRubyObject serial() {
        return this.serial;
    }

    @JRubyMethod(name={"serial="})
    public IRubyObject set_serial(IRubyObject serial2) {
        if (serial2 instanceof BN) {
            this.serial = (BN)serial2;
            return this.serial;
        }
        BigInteger value2 = serial2.convertToInteger("to_i").getBigIntegerValue();
        this.serial = BN.newInstance(this.getRuntime(), value2);
        return this.serial;
    }

    DateTime getTime() {
        if (this.time == null) {
            return null;
        }
        return this.time.getDateTime();
    }

    @JRubyMethod
    public IRubyObject time() {
        return this.time == null ? this.getRuntime().getNil() : this.time;
    }

    @JRubyMethod(name={"time="})
    public IRubyObject set_time(IRubyObject time2) {
        this.time = (RubyTime)time2;
        return this.time;
    }

    boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    @JRubyMethod
    public RubyArray extensions() {
        return this.extensions == null ? (this.extensions = RubyArray.newArray((Ruby)this.getRuntime(), (int)4)) : this.extensions;
    }

    @JRubyMethod(name={"extensions="})
    public IRubyObject set_extensions(IRubyObject extensions2) {
        this.extensions = (RubyArray)extensions2;
        return this.extensions;
    }

    @JRubyMethod
    public IRubyObject add_extension(ThreadContext context, IRubyObject ext2) {
        return this.extensions().callMethod(context, "<<", ext2);
    }

    @JRubyMethod
    public IRubyObject inspect() {
        return ObjectSupport.inspect((RubyBasicObject)this, Collections.EMPTY_LIST);
    }
}

