/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.SSLSocket;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.builtin.IRubyObject;

public class SSL {
    public static final int VERIFY_NONE = 0;
    public static final int VERIFY_PEER = 1;
    public static final int VERIFY_FAIL_IF_NO_PEER_CERT = 2;
    public static final int VERIFY_CLIENT_ONCE = 4;
    public static final long OP_ALL = 4095L;
    public static final long OP_NO_TICKET = 16384L;
    public static final long OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION = 65536L;
    public static final long OP_SINGLE_ECDH_USE = 524288L;
    public static final long OP_SINGLE_DH_USE = 0x100000L;
    public static final long OP_EPHEMERAL_RSA = 0x200000L;
    public static final long OP_CIPHER_SERVER_PREFERENCE = 0x400000L;
    public static final long OP_TLS_ROLLBACK_BUG = 0x800000L;
    public static final long OP_NO_SSLv2 = 0x1000000L;
    public static final long OP_NO_SSLv3 = 0x2000000L;
    public static final long OP_NO_TLSv1 = 0x4000000L;
    public static final long OP_PKCS1_CHECK_1 = 0x8000000L;
    public static final long OP_PKCS1_CHECK_2 = 0x10000000L;
    public static final long OP_NETSCAPE_CA_DN_BUG = 0x20000000L;
    public static final long OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG = 0x40000000L;

    public static void createSSL(Ruby runtime, RubyModule OpenSSL2) {
        IRubyObject WaitWritable;
        RubyModule SSL2 = OpenSSL2.defineModuleUnder("SSL");
        RubyClass OpenSSLError = OpenSSL2.getClass("OpenSSLError");
        RubyClass SSLError = SSL2.defineClassUnder("SSLError", OpenSSLError, OpenSSLError.getAllocator());
        IRubyObject WaitReadable = runtime.getIO().getConstantAt("WaitReadable");
        if (WaitReadable != null) {
            SSL2.defineClassUnder("SSLErrorWaitReadable", SSLError, OpenSSLError.getAllocator()).include(new IRubyObject[]{WaitReadable});
        }
        if ((WaitWritable = runtime.getIO().getConstantAt("WaitWritable")) != null) {
            SSL2.defineClassUnder("SSLErrorWaitWritable", SSLError, OpenSSLError.getAllocator()).include(new IRubyObject[]{WaitWritable});
        }
        SSL2.setConstant("VERIFY_NONE", (IRubyObject)runtime.newFixnum(0));
        SSL2.setConstant("VERIFY_PEER", (IRubyObject)runtime.newFixnum(1));
        SSL2.setConstant("VERIFY_FAIL_IF_NO_PEER_CERT", (IRubyObject)runtime.newFixnum(2));
        SSL2.setConstant("VERIFY_CLIENT_ONCE", (IRubyObject)runtime.newFixnum(4));
        SSL2.setConstant("OP_ALL", (IRubyObject)runtime.newFixnum(4095L));
        SSL2.setConstant("OP_NO_TICKET", (IRubyObject)runtime.newFixnum(16384L));
        SSL2.setConstant("OP_NO_SESSION_RESUMPTION_ON_RENEGOTIATION", (IRubyObject)runtime.newFixnum(65536L));
        SSL2.setConstant("OP_SINGLE_ECDH_USE", (IRubyObject)runtime.newFixnum(524288L));
        SSL2.setConstant("OP_SINGLE_DH_USE", (IRubyObject)runtime.newFixnum(0x100000L));
        SSL2.setConstant("OP_EPHEMERAL_RSA", (IRubyObject)runtime.newFixnum(0x200000L));
        SSL2.setConstant("OP_CIPHER_SERVER_PREFERENCE", (IRubyObject)runtime.newFixnum(0x400000L));
        SSL2.setConstant("OP_TLS_ROLLBACK_BUG", (IRubyObject)runtime.newFixnum(0x800000L));
        SSL2.setConstant("OP_NO_SSLv2", (IRubyObject)runtime.newFixnum(0x1000000L));
        SSL2.setConstant("OP_NO_SSLv3", (IRubyObject)runtime.newFixnum(0x2000000L));
        SSL2.setConstant("OP_NO_TLSv1", (IRubyObject)runtime.newFixnum(0x4000000L));
        SSL2.setConstant("OP_PKCS1_CHECK_1", (IRubyObject)runtime.newFixnum(0x8000000L));
        SSL2.setConstant("OP_PKCS1_CHECK_2", (IRubyObject)runtime.newFixnum(0x10000000L));
        SSL2.setConstant("OP_NETSCAPE_CA_DN_BUG", (IRubyObject)runtime.newFixnum(0x20000000L));
        SSL2.setConstant("OP_NETSCAPE_DEMO_CIPHER_CHANGE_BUG", (IRubyObject)runtime.newFixnum(0x40000000L));
        SSLContext.createSSLContext(runtime, SSL2);
        SSLSocket.createSSLSocket(runtime, SSL2);
    }

    public static RaiseException newSSLError(Ruby runtime, Exception exception) {
        return Utils.newError(runtime, SSL._SSL(runtime).getClass("SSLError"), exception);
    }

    public static RaiseException newSSLError(Ruby runtime, String message) {
        return Utils.newError(runtime, SSL._SSL(runtime).getClass("SSLError"), message, false);
    }

    public static RaiseException newSSLErrorWaitReadable(Ruby runtime, String message) {
        return SSL.newCustomSSLError(runtime, "SSLErrorWaitReadable", message);
    }

    public static RaiseException newSSLErrorWaitWritable(Ruby runtime, String message) {
        return SSL.newCustomSSLError(runtime, "SSLErrorWaitWritable", message);
    }

    private static RaiseException newCustomSSLError(Ruby runtime, String name2, String message) {
        RubyClass errorClass = SSL._SSL(runtime).getClass(name2);
        if (errorClass == null) {
            errorClass = SSL._SSL(runtime).getClass("SSLError");
        }
        return Utils.newError(runtime, errorClass, message, false);
    }

    static RubyModule _SSL(Ruby runtime) {
        return (RubyModule)runtime.getModule("OpenSSL").getConstant("SSL");
    }
}

