/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.maven.polyglot.ruby;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.maven.model.Model;
import org.jruby.CompatVersion;
import org.jruby.embed.ScriptingContainer;
import org.sonatype.maven.polyglot.execute.ExecuteManager;
import org.sonatype.maven.polyglot.ruby.execute.RubyExecuteTaskFactory;

public class RubyParser {
    private final ScriptingContainer jruby;
    private final Object parser;
    private final ExecuteManager executeManager;
    private final RubyExecuteTaskFactory factory;

    public RubyParser(ExecuteManager executeManager) throws IOException {
        this.executeManager = executeManager;
        this.jruby = new ScriptingContainer();
        this.jruby.setCompatVersion(CompatVersion.RUBY1_9);
        this.parser = this.runScript("parser.rb");
        this.factory = new RubyExecuteTaskFactory(this.jruby);
    }

    private Object runScript(String script) throws IOException {
        InputStream stream = this.getClass().getClassLoader().getResourceAsStream(script);
        if (stream != null && (stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(script)) == null) {
            throw new FileNotFoundException("not found in classloader: " + script);
        }
        return this.jruby.runScriptlet(stream, script);
    }

    public synchronized Model parse(String ruby, File source, Map<String, ?> options) {
        Model model = (Model)this.jruby.callMethod(this.parser, "parse", new Object[]{ruby, this.factory, source != null ? source.getAbsolutePath() : null}, Model.class);
        model.setPomFile(source);
        this.executeManager.register(model, this.factory.getExecuteTasks());
        this.executeManager.install(model, options);
        return model;
    }
}

