/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.source;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchParseElement;
import org.elasticsearch.search.fetch.source.FetchSourceContext;
import org.elasticsearch.search.internal.SearchContext;

public class FetchSourceParseElement
implements SearchParseElement {
    @Override
    public void parse(XContentParser parser, SearchContext context) throws Exception {
        context.fetchSourceContext(this.parse(parser));
    }

    public FetchSourceContext parse(XContentParser parser) throws IOException {
        ArrayList<String> includes = null;
        ArrayList excludes = null;
        String currentFieldName = null;
        XContentParser.Token token = parser.currentToken();
        if (parser.isBooleanValue()) {
            return new FetchSourceContext(parser.booleanValue());
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return new FetchSourceContext(new String[]{parser.text()});
        }
        if (token == XContentParser.Token.START_ARRAY) {
            includes = new ArrayList<String>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                includes.add(parser.text());
            }
        } else if (token == XContentParser.Token.START_OBJECT) {
            ArrayList<String> currentList = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if ("includes".equals(currentFieldName) || "include".equals(currentFieldName)) {
                        currentList = includes != null ? includes : new ArrayList(2);
                        continue;
                    }
                    if ("excludes".equals(currentFieldName) || "exclude".equals(currentFieldName)) {
                        currentList = excludes != null ? excludes : new ArrayList(2);
                        continue;
                    }
                    throw new ElasticsearchParseException("Source definition may not contain " + parser.text());
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        currentList.add(parser.text());
                    }
                    continue;
                }
                if (token.isValue()) {
                    currentList.add(parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("unexpected token while parsing source settings");
            }
        } else {
            throw new ElasticsearchParseException("source element value can be of type " + token.name());
        }
        return new FetchSourceContext(includes == null ? Strings.EMPTY_ARRAY : includes.toArray(new String[includes.size()]), excludes == null ? Strings.EMPTY_ARRAY : excludes.toArray(new String[excludes.size()]));
    }
}

