/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.terms.InternalTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.support.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.support.IncludeExclude;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.format.ValueFormat;
import org.elasticsearch.search.aggregations.support.format.ValueFormatter;

public class LongTermsAggregator
extends TermsAggregator {
    protected final ValuesSource.Numeric valuesSource;
    @Nullable
    protected final ValueFormatter formatter;
    protected final LongHash bucketOrds;
    private boolean showTermDocCountError;
    private SortedNumericDocValues values;
    private IncludeExclude.LongFilter longFilter;

    public LongTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, @Nullable ValueFormat format, long estimatedBucketCount, Terms.Order order, TermsAggregator.BucketCountThresholds bucketCountThresholds, AggregationContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, IncludeExclude.LongFilter longFilter) {
        super(name, Aggregator.BucketAggregationMode.PER_BUCKET, factories, estimatedBucketCount, aggregationContext, parent, bucketCountThresholds, order, subAggCollectMode);
        this.valuesSource = valuesSource;
        this.showTermDocCountError = showTermDocCountError;
        this.formatter = format != null ? format.formatter() : null;
        this.longFilter = longFilter;
        this.bucketOrds = new LongHash(estimatedBucketCount, aggregationContext.bigArrays());
    }

    @Override
    public boolean shouldCollect() {
        return true;
    }

    protected SortedNumericDocValues getValues(ValuesSource.Numeric valuesSource) {
        return valuesSource.longValues();
    }

    @Override
    public void setNextReader(AtomicReaderContext reader) {
        this.values = this.getValues(this.valuesSource);
    }

    @Override
    public void collect(int doc, long owningBucketOrdinal) throws IOException {
        assert (owningBucketOrdinal == 0L);
        this.values.setDocument(doc);
        int valuesCount = this.values.count();
        long previous = Long.MAX_VALUE;
        for (int i = 0; i < valuesCount; ++i) {
            long val = this.values.valueAt(i);
            if (previous == val && i != 0) continue;
            if (this.longFilter == null || this.longFilter.accept(val)) {
                long bucketOrdinal = this.bucketOrds.add(val);
                if (bucketOrdinal < 0L) {
                    bucketOrdinal = -1L - bucketOrdinal;
                    this.collectExistingBucket(doc, bucketOrdinal);
                } else {
                    this.collectBucket(doc, bucketOrdinal);
                }
            }
            previous = val;
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) {
        int i;
        assert (owningBucketOrdinal == 0L);
        if (this.bucketCountThresholds.getMinDocCount() == 0L && (this.order != InternalOrder.COUNT_DESC || this.bucketOrds.size() < (long)this.bucketCountThresholds.getRequiredSize())) {
            for (AtomicReaderContext ctx : this.context.searchContext().searcher().getTopReaderContext().leaves()) {
                this.context.setNextReader(ctx);
                SortedNumericDocValues values = this.getValues(this.valuesSource);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    values.setDocument(docId);
                    int valueCount = values.count();
                    for (int i2 = 0; i2 < valueCount; ++i2) {
                        this.bucketOrds.add(values.valueAt(i2));
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long otherDocCount = 0L;
        BucketPriorityQueue ordered = new BucketPriorityQueue(size, this.order.comparator(this));
        LongTerms.Bucket spare = null;
        for (long i3 = 0L; i3 < this.bucketOrds.size(); ++i3) {
            if (spare == null) {
                spare = new LongTerms.Bucket(0L, 0L, null, this.showTermDocCountError, 0L);
            }
            spare.term = this.bucketOrds.get(i3);
            spare.docCount = this.bucketDocCount(i3);
            otherDocCount += spare.docCount;
            spare.bucketOrd = i3;
            if (this.bucketCountThresholds.getShardMinDocCount() > spare.docCount) continue;
            spare = (LongTerms.Bucket)ordered.insertWithOverflow(spare);
        }
        InternalTerms.Bucket[] list = new InternalTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            LongTerms.Bucket bucket = (LongTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[i] = bucket;
            otherDocCount -= bucket.docCount;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            list[i].aggregations = this.bucketAggregations(list[i].bucketOrd);
            list[i].docCountError = 0L;
        }
        return new LongTerms(this.name, this.order, this.formatter, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getShardSize(), this.bucketCountThresholds.getMinDocCount(), Arrays.asList(list), this.showTermDocCountError, 0L, otherDocCount);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new LongTerms(this.name, this.order, this.formatter, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getShardSize(), this.bucketCountThresholds.getMinDocCount(), Collections.emptyList(), this.showTermDocCountError, 0L, 0L);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

