/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.validate.query;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.validate.query.QueryExplanation;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.QuerySourceBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.support.RestActions;
import org.elasticsearch.rest.action.support.RestBuilderListener;

public class RestValidateQueryAction
extends BaseRestHandler {
    @Inject
    public RestValidateQueryAction(Settings settings, RestController controller, Client client) {
        super(settings, controller, client);
        controller.registerHandler(RestRequest.Method.GET, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_validate/query", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_validate/query", this);
    }

    @Override
    public void handleRequest(RestRequest request, RestChannel channel, Client client) {
        ValidateQueryRequest validateQueryRequest = new ValidateQueryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        validateQueryRequest.listenerThreaded(false);
        validateQueryRequest.indicesOptions(IndicesOptions.fromRequest(request, validateQueryRequest.indicesOptions()));
        if (request.hasContent()) {
            validateQueryRequest.source(request.content());
        } else {
            String source = request.param("source");
            if (source != null) {
                validateQueryRequest.source(source);
            } else {
                QuerySourceBuilder querySourceBuilder = RestActions.parseQuerySource(request);
                if (querySourceBuilder != null) {
                    validateQueryRequest.source(querySourceBuilder);
                }
            }
        }
        validateQueryRequest.types(Strings.splitStringByCommaToArray(request.param("type")));
        if (request.paramAsBoolean("explain", false)) {
            validateQueryRequest.explain(true);
        } else {
            validateQueryRequest.explain(false);
        }
        if (request.paramAsBoolean("rewrite", false)) {
            validateQueryRequest.rewrite(true);
        } else {
            validateQueryRequest.rewrite(false);
        }
        client.admin().indices().validateQuery(validateQueryRequest, (ActionListener<ValidateQueryResponse>)new RestBuilderListener<ValidateQueryResponse>(channel){

            @Override
            public RestResponse buildResponse(ValidateQueryResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("valid", response.isValid());
                RestActions.buildBroadcastShardsHeader(builder, response);
                if (response.getQueryExplanation() != null && !response.getQueryExplanation().isEmpty()) {
                    builder.startArray("explanations");
                    for (QueryExplanation queryExplanation : response.getQueryExplanation()) {
                        builder.startObject();
                        if (queryExplanation.getIndex() != null) {
                            builder.field("index", queryExplanation.getIndex(), XContentBuilder.FieldCaseConversion.NONE);
                        }
                        builder.field("valid", queryExplanation.isValid());
                        if (queryExplanation.getError() != null) {
                            builder.field("error", queryExplanation.getError());
                        }
                        if (queryExplanation.getExplanation() != null) {
                            builder.field("explanation", queryExplanation.getExplanation());
                        }
                        builder.endObject();
                    }
                    builder.endArray();
                }
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

