/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.collect.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.codec.postingsformat.PostingsFormatProvider;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.similarity.SimilarityProvider;
import org.elasticsearch.search.suggest.completion.AnalyzingCompletionLookupProvider;
import org.elasticsearch.search.suggest.completion.CompletionPostingsFormatProvider;
import org.elasticsearch.search.suggest.completion.CompletionTokenStream;
import org.elasticsearch.search.suggest.context.ContextBuilder;
import org.elasticsearch.search.suggest.context.ContextMapping;

public class CompletionFieldMapper
extends AbstractFieldMapper<String> {
    public static final String CONTENT_TYPE = "completion";
    public static final Set<String> ALLOWED_CONTENT_FIELD_NAMES = Sets.newHashSet("input", "output", "payload", "weight", "context");
    private static final BytesRef EMPTY = new BytesRef();
    private final CompletionPostingsFormatProvider completionPostingsFormatProvider;
    private final AnalyzingCompletionLookupProvider analyzingSuggestLookupProvider;
    private final boolean payloads;
    private final boolean preservePositionIncrements;
    private final boolean preserveSeparators;
    private int maxInputLength;
    private final SortedMap<String, ContextMapping> contextMapping;

    public CompletionFieldMapper(FieldMapper.Names names, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, PostingsFormatProvider postingsProvider, SimilarityProvider similarity, boolean payloads, boolean preserveSeparators, boolean preservePositionIncrements, int maxInputLength, AbstractFieldMapper.MultiFields multiFields, AbstractFieldMapper.CopyTo copyTo, SortedMap<String, ContextMapping> contextMappings) {
        super(names, 1.0f, Defaults.FIELD_TYPE, null, indexAnalyzer, searchAnalyzer, postingsProvider, null, similarity, null, null, null, multiFields, copyTo);
        this.analyzingSuggestLookupProvider = new AnalyzingCompletionLookupProvider(preserveSeparators, false, preservePositionIncrements, payloads);
        this.completionPostingsFormatProvider = new CompletionPostingsFormatProvider(CONTENT_TYPE, postingsProvider, this.analyzingSuggestLookupProvider);
        this.preserveSeparators = preserveSeparators;
        this.payloads = payloads;
        this.preservePositionIncrements = preservePositionIncrements;
        this.maxInputLength = maxInputLength;
        this.contextMapping = contextMappings;
    }

    @Override
    public PostingsFormatProvider postingsFormatProvider() {
        return this.completionPostingsFormatProvider;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        String surfaceForm = null;
        BytesRef payload = null;
        long weight = -1L;
        ArrayList<String> inputs = Lists.newArrayListWithExpectedSize(4);
        TreeMap<String, ContextMapping.ContextConfig> contextConfig = null;
        if (token == XContentParser.Token.VALUE_STRING) {
            inputs.add(parser.text());
            this.multiFields.parse(this, context);
        } else {
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (ALLOWED_CONTENT_FIELD_NAMES.contains(currentFieldName)) continue;
                    throw new ElasticsearchIllegalArgumentException("Unknown field name[" + currentFieldName + "], must be one of " + ALLOWED_CONTENT_FIELD_NAMES);
                }
                if ("context".equals(currentFieldName)) {
                    TreeMap<String, ContextMapping.ContextConfig> configs = Maps.newTreeMap();
                    if (token == XContentParser.Token.START_OBJECT) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            String name = parser.text();
                            ContextMapping mapping = (ContextMapping)this.contextMapping.get(name);
                            if (mapping == null) {
                                throw new ElasticsearchParseException("context [" + name + "] is not defined");
                            }
                            token = parser.nextToken();
                            configs.put(name, mapping.parseContext(context, parser));
                        }
                        contextConfig = Maps.newTreeMap();
                        for (ContextMapping mapping : this.contextMapping.values()) {
                            ContextMapping.ContextConfig config = (ContextMapping.ContextConfig)configs.get(mapping.name());
                            contextConfig.put(mapping.name(), config == null ? mapping.defaultConfig() : config);
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("context must be an object");
                }
                if ("payload".equals(currentFieldName)) {
                    if (!this.isStoringPayloads()) {
                        throw new MapperException("Payloads disabled in mapping");
                    }
                    if (token == XContentParser.Token.START_OBJECT) {
                        XContentBuilder payloadBuilder = XContentFactory.contentBuilder(parser.contentType()).copyCurrentStructure(parser);
                        payload = payloadBuilder.bytes().toBytesRef();
                        payloadBuilder.close();
                        continue;
                    }
                    if (token.isValue()) {
                        payload = parser.utf8BytesOrNull();
                        continue;
                    }
                    throw new MapperException("payload doesn't support type " + (Object)((Object)token));
                }
                if (token == XContentParser.Token.VALUE_STRING) {
                    Long weightValue;
                    if ("output".equals(currentFieldName)) {
                        surfaceForm = parser.text();
                    }
                    if ("input".equals(currentFieldName)) {
                        inputs.add(parser.text());
                    }
                    if (!"weight".equals(currentFieldName)) continue;
                    try {
                        weightValue = Long.parseLong(parser.text());
                    }
                    catch (NumberFormatException e) {
                        throw new ElasticsearchIllegalArgumentException("Weight must be a string representing a numeric value, but was [" + parser.text() + "]");
                    }
                    weight = weightValue;
                    this.checkWeight(weight);
                    continue;
                }
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    if (!"weight".equals(currentFieldName)) continue;
                    XContentParser.NumberType numberType = parser.numberType();
                    if (XContentParser.NumberType.LONG != numberType && XContentParser.NumberType.INT != numberType) {
                        throw new ElasticsearchIllegalArgumentException("Weight must be an integer, but was [" + parser.numberValue() + "]");
                    }
                    weight = parser.longValue();
                    this.checkWeight(weight);
                    continue;
                }
                if (token != XContentParser.Token.START_ARRAY || !"input".equals(currentFieldName)) continue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    inputs.add(parser.text());
                }
            }
        }
        if (contextConfig == null) {
            contextConfig = Maps.newTreeMap();
            for (ContextMapping mapping : this.contextMapping.values()) {
                contextConfig.put(mapping.name(), mapping.defaultConfig());
            }
        }
        ContextMapping.Context ctx = new ContextMapping.Context(contextConfig, context.doc());
        BytesRef bytesRef = payload = payload == null ? EMPTY : payload;
        if (surfaceForm == null) {
            for (String input : inputs) {
                if (input.length() == 0) continue;
                BytesRef suggestPayload = this.analyzingSuggestLookupProvider.buildPayload(new BytesRef((CharSequence)input), weight, payload);
                context.doc().add((IndexableField)this.getCompletionField(ctx, input, suggestPayload));
            }
        } else {
            BytesRef suggestPayload = this.analyzingSuggestLookupProvider.buildPayload(new BytesRef((CharSequence)surfaceForm), weight, payload);
            for (String input : inputs) {
                if (input.length() == 0) continue;
                context.doc().add((IndexableField)this.getCompletionField(ctx, input, suggestPayload));
            }
        }
    }

    private void checkWeight(long weight) {
        if (weight < 0L || weight > Integer.MAX_VALUE) {
            throw new ElasticsearchIllegalArgumentException("Weight must be in the interval [0..2147483647], but was [" + weight + "]");
        }
    }

    public SortedMap<String, ContextMapping> getContextMapping() {
        return this.contextMapping;
    }

    public boolean requiresContext() {
        return !this.contextMapping.isEmpty();
    }

    public Field getCompletionField(String input, BytesRef payload) {
        return this.getCompletionField(ContextMapping.EMPTY_CONTEXT, input, payload);
    }

    public Field getCompletionField(ContextMapping.Context ctx, String input, BytesRef payload) {
        String originalInput = input;
        if (input.length() > this.maxInputLength) {
            int len = CompletionFieldMapper.correctSubStringLen(input, Math.min(this.maxInputLength, input.length()));
            input = input.substring(0, len);
        }
        for (int i = 0; i < input.length(); ++i) {
            if (!CompletionFieldMapper.isReservedChar(input.charAt(i))) continue;
            throw new ElasticsearchIllegalArgumentException("Illegal input [" + originalInput + "] UTF-16 codepoint  [0x" + Integer.toHexString(input.charAt(i)).toUpperCase(Locale.ROOT) + "] at position " + i + " is a reserved character");
        }
        return new SuggestField(this.names.indexName(), ctx, input, this.fieldType, payload, this.analyzingSuggestLookupProvider);
    }

    public static int correctSubStringLen(String input, int len) {
        if (Character.isHighSurrogate(input.charAt(len - 1))) {
            assert (input.length() >= len + 1 && Character.isLowSurrogate(input.charAt(len)));
            return len + 1;
        }
        return len;
    }

    public BytesRef buildPayload(BytesRef surfaceForm, long weight, BytesRef payload) throws IOException {
        return this.analyzingSuggestLookupProvider.buildPayload(surfaceForm, weight, payload);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name()).field("type", CONTENT_TYPE);
        if (this.indexAnalyzer.name().equals(this.searchAnalyzer.name())) {
            builder.field("analyzer", this.indexAnalyzer.name());
        } else {
            builder.field(Fields.INDEX_ANALYZER.getPreferredName(), this.indexAnalyzer.name()).field(Fields.SEARCH_ANALYZER.getPreferredName(), this.searchAnalyzer.name());
        }
        builder.field("payloads", this.payloads);
        builder.field(Fields.PRESERVE_SEPARATORS.getPreferredName(), this.preserveSeparators);
        builder.field(Fields.PRESERVE_POSITION_INCREMENTS.getPreferredName(), this.preservePositionIncrements);
        builder.field(Fields.MAX_INPUT_LENGTH.getPreferredName(), this.maxInputLength);
        this.multiFields.toXContent(builder, params);
        if (!this.contextMapping.isEmpty()) {
            builder.startObject("context");
            for (ContextMapping mapping : this.contextMapping.values()) {
                builder.value(mapping);
            }
            builder.endObject();
        }
        return builder.endObject();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public boolean hasDocValues() {
        return false;
    }

    @Override
    public boolean supportsNullValue() {
        return false;
    }

    @Override
    public FieldType defaultFieldType() {
        return Defaults.FIELD_TYPE;
    }

    @Override
    public FieldDataType defaultFieldDataType() {
        return null;
    }

    @Override
    public String value(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public boolean isStoringPayloads() {
        return this.payloads;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        CompletionFieldMapper fieldMergeWith = (CompletionFieldMapper)mergeWith;
        if (this.payloads != fieldMergeWith.payloads) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different payload values");
        }
        if (this.preservePositionIncrements != fieldMergeWith.preservePositionIncrements) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different 'preserve_position_increments' values");
        }
        if (this.preserveSeparators != fieldMergeWith.preserveSeparators) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different 'preserve_separators' values");
        }
        if (!ContextMapping.mappingsAreEqual(this.getContextMapping(), fieldMergeWith.getContextMapping())) {
            mergeContext.addConflict("mapper [" + this.names.fullName() + "] has different 'context_mapping' values");
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.maxInputLength = fieldMergeWith.maxInputLength;
        }
    }

    public static boolean isReservedChar(char character) {
        switch (character) {
            case '\u0000': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                return true;
            }
        }
        return false;
    }

    private static final class SuggestField
    extends Field {
        private final BytesRef payload;
        private final CompletionTokenStream.ToFiniteStrings toFiniteStrings;
        private final ContextMapping.Context ctx;

        public SuggestField(String name, ContextMapping.Context ctx, String value, FieldType type, BytesRef payload, CompletionTokenStream.ToFiniteStrings toFiniteStrings) {
            super(name, value, type);
            this.payload = payload;
            this.toFiniteStrings = toFiniteStrings;
            this.ctx = ctx;
        }

        public TokenStream tokenStream(Analyzer analyzer, TokenStream previous) throws IOException {
            TokenStream ts = this.ctx.wrapTokenStream(super.tokenStream(analyzer, previous));
            return new CompletionTokenStream(ts, this.payload, this.toFiniteStrings);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.completionField(name);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("type")) continue;
                if (fieldName.equals("analyzer")) {
                    NamedAnalyzer analyzer = this.getNamedAnalyzer(parserContext, fieldNode.toString());
                    builder.indexAnalyzer(analyzer);
                    builder.searchAnalyzer(analyzer);
                    continue;
                }
                if (Fields.INDEX_ANALYZER.match(fieldName)) {
                    builder.indexAnalyzer(this.getNamedAnalyzer(parserContext, fieldNode.toString()));
                    continue;
                }
                if (Fields.SEARCH_ANALYZER.match(fieldName)) {
                    builder.searchAnalyzer(this.getNamedAnalyzer(parserContext, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("payloads")) {
                    builder.payloads(Boolean.parseBoolean(fieldNode.toString()));
                    continue;
                }
                if (Fields.PRESERVE_SEPARATORS.match(fieldName)) {
                    builder.preserveSeparators(Boolean.parseBoolean(fieldNode.toString()));
                    continue;
                }
                if (Fields.PRESERVE_POSITION_INCREMENTS.match(fieldName)) {
                    builder.preservePositionIncrements(Boolean.parseBoolean(fieldNode.toString()));
                    continue;
                }
                if (Fields.MAX_INPUT_LENGTH.match(fieldName)) {
                    builder.maxInputLength(Integer.parseInt(fieldNode.toString()));
                    continue;
                }
                if ("fields".equals(fieldName) || "path".equals(fieldName)) {
                    TypeParsers.parseMultiField(builder, name, parserContext, fieldName, fieldNode);
                    continue;
                }
                if (fieldName.equals("context")) {
                    builder.contextMapping(ContextBuilder.loadMappings(fieldNode));
                    continue;
                }
                throw new MapperParsingException("Unknown field [" + fieldName + "]");
            }
            if (builder.searchAnalyzer == null) {
                builder.searchAnalyzer(parserContext.analysisService().analyzer("simple"));
            }
            if (builder.indexAnalyzer == null) {
                builder.indexAnalyzer(parserContext.analysisService().analyzer("simple"));
            }
            builder.postingsFormat(parserContext.postingFormatService().get("default"));
            return builder;
        }

        private NamedAnalyzer getNamedAnalyzer(Mapper.TypeParser.ParserContext parserContext, String name) {
            NamedAnalyzer analyzer = parserContext.analysisService().analyzer(name);
            if (analyzer == null) {
                throw new ElasticsearchIllegalArgumentException("Can't find default or mapped analyzer with name [" + name + "]");
            }
            return analyzer;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, CompletionFieldMapper> {
        private boolean preserveSeparators = true;
        private boolean payloads = false;
        private boolean preservePositionIncrements = true;
        private int maxInputLength = 50;
        private SortedMap<String, ContextMapping> contextMapping = ContextMapping.EMPTY_MAPPING;

        public Builder(String name) {
            super(name, new FieldType(Defaults.FIELD_TYPE));
            this.builder = this;
        }

        public Builder payloads(boolean payloads) {
            this.payloads = payloads;
            return this;
        }

        public Builder preserveSeparators(boolean preserveSeparators) {
            this.preserveSeparators = preserveSeparators;
            return this;
        }

        public Builder preservePositionIncrements(boolean preservePositionIncrements) {
            this.preservePositionIncrements = preservePositionIncrements;
            return this;
        }

        public Builder maxInputLength(int maxInputLength) {
            if (maxInputLength <= 0) {
                throw new ElasticsearchIllegalArgumentException(Fields.MAX_INPUT_LENGTH.getPreferredName() + " must be > 0 but was [" + maxInputLength + "]");
            }
            this.maxInputLength = maxInputLength;
            return this;
        }

        public Builder contextMapping(SortedMap<String, ContextMapping> contextMapping) {
            this.contextMapping = contextMapping;
            return this;
        }

        @Override
        public CompletionFieldMapper build(Mapper.BuilderContext context) {
            return new CompletionFieldMapper(this.buildNames(context), this.indexAnalyzer, this.searchAnalyzer, this.postingsProvider, this.similarity, this.payloads, this.preserveSeparators, this.preservePositionIncrements, this.maxInputLength, this.multiFieldsBuilder.build(this, context), this.copyTo, this.contextMapping);
        }
    }

    public static class Fields {
        public static final String ANALYZER = "analyzer";
        public static final ParseField INDEX_ANALYZER = new ParseField("index_analyzer", new String[0]);
        public static final ParseField SEARCH_ANALYZER = new ParseField("search_analyzer", new String[0]);
        public static final ParseField PRESERVE_SEPARATORS = new ParseField("preserve_separators", new String[0]);
        public static final ParseField PRESERVE_POSITION_INCREMENTS = new ParseField("preserve_position_increments", new String[0]);
        public static final String PAYLOADS = "payloads";
        public static final String TYPE = "type";
        public static final ParseField MAX_INPUT_LENGTH = new ParseField("max_input_length", "max_input_len");
        public static final String CONTENT_FIELD_NAME_INPUT = "input";
        public static final String CONTENT_FIELD_NAME_OUTPUT = "output";
        public static final String CONTENT_FIELD_NAME_PAYLOAD = "payload";
        public static final String CONTENT_FIELD_NAME_WEIGHT = "weight";
        public static final String CONTEXT = "context";
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final FieldType FIELD_TYPE = new FieldType(AbstractFieldMapper.Defaults.FIELD_TYPE);
        public static final boolean DEFAULT_PRESERVE_SEPARATORS = true;
        public static final boolean DEFAULT_POSITION_INCREMENTS = true;
        public static final boolean DEFAULT_HAS_PAYLOADS = false;
        public static final int DEFAULT_MAX_INPUT_LENGTH = 50;

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

