/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.ping.multicast;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.util.Constants;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.CachedStreamInput;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.HandlesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.network.MulticastChannel;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.discovery.zen.ping.PingContextProvider;
import org.elasticsearch.discovery.zen.ping.ZenPing;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class MulticastZenPing
extends AbstractLifecycleComponent<ZenPing>
implements ZenPing {
    public static final String ACTION_NAME = "internal:discovery/zen/multicast";
    private static final byte[] INTERNAL_HEADER = new byte[]{1, 9, 8, 4};
    private static final int PING_SIZE_ESTIMATE = 150;
    private final String address;
    private final int port;
    private final String group;
    private final int bufferSize;
    private final int ttl;
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final ClusterName clusterName;
    private final NetworkService networkService;
    private final Version version;
    private volatile PingContextProvider contextProvider;
    private final boolean pingEnabled;
    private volatile MulticastChannel multicastChannel;
    private final AtomicInteger pingIdGenerator = new AtomicInteger();
    private final Map<Integer, ZenPing.PingCollection> receivedResponses = ConcurrentCollections.newConcurrentMap();

    public MulticastZenPing(ThreadPool threadPool, TransportService transportService, ClusterName clusterName, Version version) {
        this(ImmutableSettings.Builder.EMPTY_SETTINGS, threadPool, transportService, clusterName, new NetworkService(ImmutableSettings.Builder.EMPTY_SETTINGS), version);
    }

    public MulticastZenPing(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName, NetworkService networkService, Version version) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = clusterName;
        this.networkService = networkService;
        this.version = version;
        this.address = this.componentSettings.get("address");
        this.port = this.componentSettings.getAsInt("port", (Integer)54328);
        this.group = this.componentSettings.get("group", "224.2.2.4");
        this.bufferSize = this.componentSettings.getAsInt("buffer_size", (Integer)2048);
        this.ttl = this.componentSettings.getAsInt("ttl", (Integer)3);
        this.pingEnabled = this.componentSettings.getAsBoolean("ping.enabled", (Boolean)true);
        this.logger.debug("using group [{}], with port [{}], ttl [{}], and address [{}]", this.group, this.port, this.ttl, this.address);
        this.transportService.registerHandler(ACTION_NAME, new MulticastPingResponseRequestHandler());
    }

    @Override
    public void setPingContextProvider(PingContextProvider nodesProvider) {
        if (this.lifecycle.started()) {
            throw new ElasticsearchIllegalStateException("Can't set nodes provider when started");
        }
        this.contextProvider = nodesProvider;
    }

    @Override
    protected void doStart() throws ElasticsearchException {
        try {
            boolean shared = this.componentSettings.getAsBoolean("shared", (Boolean)Constants.MAC_OS_X);
            this.multicastChannel = MulticastChannel.getChannel(this.nodeName(), shared, new MulticastChannel.Config(this.port, this.group, this.bufferSize, this.ttl, this.networkService.resolvePublishHostAddress(this.address)), new Receiver());
        }
        catch (Throwable t) {
            String msg = "multicast failed to start [{}], disabling. Consider using IPv4 only (by defining env. variable `ES_USE_IPV4`)";
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(msg, t, ExceptionsHelper.detailedMessage(t));
            }
            this.logger.info(msg, ExceptionsHelper.detailedMessage(t));
        }
    }

    @Override
    protected void doStop() throws ElasticsearchException {
        if (this.multicastChannel != null) {
            this.multicastChannel.close();
            this.multicastChannel = null;
        }
    }

    @Override
    protected void doClose() throws ElasticsearchException {
    }

    public ZenPing.PingResponse[] pingAndWait(TimeValue timeout) {
        final AtomicReference response = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        try {
            this.ping(new ZenPing.PingListener(){

                @Override
                public void onPing(ZenPing.PingResponse[] pings) {
                    response.set(pings);
                    latch.countDown();
                }
            }, timeout);
        }
        catch (EsRejectedExecutionException ex) {
            this.logger.debug("Ping execution rejected", ex, new Object[0]);
            return ZenPing.PingResponse.EMPTY;
        }
        try {
            latch.await();
            return (ZenPing.PingResponse[])response.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return ZenPing.PingResponse.EMPTY;
        }
    }

    @Override
    public void ping(final ZenPing.PingListener listener, final TimeValue timeout) {
        if (!this.pingEnabled || this.multicastChannel == null) {
            this.threadPool.generic().execute(new Runnable(){

                @Override
                public void run() {
                    listener.onPing(ZenPing.PingResponse.EMPTY);
                }
            });
            return;
        }
        final int id = this.pingIdGenerator.incrementAndGet();
        try {
            this.receivedResponses.put(id, new ZenPing.PingCollection());
            this.sendPingRequest(id);
            this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 2L), "generic", new AbstractRunnable(){

                @Override
                public void onFailure(Throwable t) {
                    MulticastZenPing.this.logger.warn("[{}] failed to send second ping request", t, id);
                    MulticastZenPing.this.finalizePingCycle(id, listener);
                }

                @Override
                public void doRun() {
                    MulticastZenPing.this.sendPingRequest(id);
                    MulticastZenPing.this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 2L), "generic", new AbstractRunnable(){

                        @Override
                        public void onFailure(Throwable t) {
                            MulticastZenPing.this.logger.warn("[{}] failed to send third ping request", t, id);
                            MulticastZenPing.this.finalizePingCycle(id, listener);
                        }

                        @Override
                        public void doRun() {
                            ZenPing.PingCollection collection = (ZenPing.PingCollection)MulticastZenPing.this.receivedResponses.get(id);
                            FinalizingPingCollection finalizingPingCollection = new FinalizingPingCollection(id, collection, collection.size(), listener);
                            MulticastZenPing.this.receivedResponses.put(id, finalizingPingCollection);
                            MulticastZenPing.this.logger.trace("[{}] sending last pings", id);
                            MulticastZenPing.this.sendPingRequest(id);
                            MulticastZenPing.this.threadPool.schedule(TimeValue.timeValueMillis(timeout.millis() / 4L), "generic", new AbstractRunnable(){

                                @Override
                                public void onFailure(Throwable t) {
                                    MulticastZenPing.this.logger.warn("[{}] failed to finalize ping", t, id);
                                }

                                @Override
                                protected void doRun() throws Exception {
                                    MulticastZenPing.this.finalizePingCycle(id, listener);
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            this.logger.warn("failed to ping", e, new Object[0]);
            this.finalizePingCycle(id, listener);
        }
    }

    private void finalizePingCycle(int id, ZenPing.PingListener listener) {
        ZenPing.PingCollection responses = this.receivedResponses.remove(id);
        if (responses != null) {
            listener.onPing(responses.toArray());
        }
    }

    private void sendPingRequest(int id) {
        try {
            BytesStreamOutput bStream = new BytesStreamOutput(150);
            HandlesStreamOutput out = new HandlesStreamOutput(bStream);
            ((StreamOutput)out).writeBytes(INTERNAL_HEADER);
            Version.writeVersion(this.version, out);
            ((StreamOutput)out).writeInt(id);
            this.clusterName.writeTo(out);
            this.contextProvider.nodes().localNode().writeTo(out);
            ((StreamOutput)out).close();
            this.multicastChannel.send(bStream.bytes());
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] sending ping request", id);
            }
        }
        catch (Exception e) {
            if (this.lifecycle.stoppedOrClosed()) {
                return;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("failed to send multicast ping request", e, new Object[0]);
            }
            this.logger.warn("failed to send multicast ping request: {}", ExceptionsHelper.detailedMessage(e));
        }
    }

    private class Receiver
    implements MulticastChannel.Listener {
        private Receiver() {
        }

        @Override
        public void onMessage(BytesReference data, SocketAddress address) {
            int id = -1;
            DiscoveryNode requestingNodeX = null;
            ClusterName clusterName = null;
            Map<String, Object> externalPingData = null;
            XContentType xContentType = null;
            try {
                boolean internal = false;
                if (data.length() > 4) {
                    int counter;
                    for (counter = 0; counter < INTERNAL_HEADER.length && data.get(counter) == INTERNAL_HEADER[counter]; ++counter) {
                    }
                    if (counter == INTERNAL_HEADER.length) {
                        internal = true;
                    }
                }
                if (internal) {
                    HandlesStreamInput input = CachedStreamInput.cachedHandles(new BytesStreamInput(new BytesArray(data.toBytes(), INTERNAL_HEADER.length, data.length() - INTERNAL_HEADER.length)));
                    Version version = Version.readVersion(input);
                    ((StreamInput)input).setVersion(version);
                    id = ((StreamInput)input).readInt();
                    clusterName = ClusterName.readClusterName(input);
                    requestingNodeX = DiscoveryNode.readNode(input);
                } else {
                    xContentType = XContentFactory.xContentType(data);
                    if (xContentType != null) {
                        externalPingData = XContentFactory.xContent(xContentType).createParser(data).mapAndClose();
                    } else {
                        throw new ElasticsearchIllegalStateException("failed multicast message, probably message from previous version");
                    }
                }
                if (externalPingData != null) {
                    this.handleExternalPingRequest(externalPingData, xContentType, address);
                } else {
                    this.handleNodePingRequest(id, requestingNodeX, clusterName);
                }
            }
            catch (Exception e) {
                if (!MulticastZenPing.this.lifecycle.started() || e instanceof EsRejectedExecutionException) {
                    MulticastZenPing.this.logger.debug("failed to read requesting data from {}", e, address);
                }
                MulticastZenPing.this.logger.warn("failed to read requesting data from {}", e, address);
            }
        }

        private void handleExternalPingRequest(Map<String, Object> externalPingData, XContentType contentType, SocketAddress remoteAddress) {
            String requestClusterName;
            if (externalPingData.containsKey("response")) {
                MulticastZenPing.this.logger.trace("got an external ping response (ignoring) from {}, content {}", remoteAddress, externalPingData);
                return;
            }
            if (MulticastZenPing.this.multicastChannel == null) {
                MulticastZenPing.this.logger.debug("can't send ping response, no socket, from {}, content {}", remoteAddress, externalPingData);
                return;
            }
            Map request = (Map)externalPingData.get("request");
            if (request == null) {
                MulticastZenPing.this.logger.warn("malformed external ping request, no 'request' element from {}, content {}", remoteAddress, externalPingData);
                return;
            }
            String string = request.containsKey("cluster_name") ? request.get("cluster_name").toString() : (requestClusterName = request.containsKey("clusterName") ? request.get("clusterName").toString() : null);
            if (requestClusterName == null) {
                MulticastZenPing.this.logger.warn("malformed external ping request, missing 'cluster_name' element within request, from {}, content {}", remoteAddress, externalPingData);
                return;
            }
            if (!requestClusterName.equals(MulticastZenPing.this.clusterName.value())) {
                MulticastZenPing.this.logger.trace("got request for cluster_name {}, but our cluster_name is {}, from {}, content {}", requestClusterName, MulticastZenPing.this.clusterName.value(), remoteAddress, externalPingData);
                return;
            }
            if (MulticastZenPing.this.logger.isTraceEnabled()) {
                MulticastZenPing.this.logger.trace("got external ping request from {}, content {}", remoteAddress, externalPingData);
            }
            try {
                DiscoveryNode localNode = MulticastZenPing.this.contextProvider.nodes().localNode();
                XContentBuilder builder = XContentFactory.contentBuilder(contentType);
                builder.startObject().startObject("response");
                builder.field("cluster_name", MulticastZenPing.this.clusterName.value());
                builder.startObject("version").field("number", MulticastZenPing.this.version.number()).field("snapshot_build", (Object)((MulticastZenPing)MulticastZenPing.this).version.snapshot).endObject();
                builder.field("transport_address", localNode.address().toString());
                if (MulticastZenPing.this.contextProvider.nodeService() != null) {
                    for (Map.Entry attr : MulticastZenPing.this.contextProvider.nodeService().attributes().entrySet()) {
                        builder.field((String)attr.getKey(), (String)attr.getValue());
                    }
                }
                builder.startObject("attributes");
                for (Map.Entry attr : localNode.attributes().entrySet()) {
                    builder.field((String)attr.getKey(), (String)attr.getValue());
                }
                builder.endObject();
                builder.endObject().endObject();
                MulticastZenPing.this.multicastChannel.send(builder.bytes());
                if (MulticastZenPing.this.logger.isTraceEnabled()) {
                    MulticastZenPing.this.logger.trace("sending external ping response {}", builder.string());
                }
            }
            catch (Exception e) {
                MulticastZenPing.this.logger.warn("failed to send external multicast response", e, new Object[0]);
            }
        }

        private void handleNodePingRequest(int id, DiscoveryNode requestingNodeX, ClusterName requestClusterName) {
            if (!MulticastZenPing.this.pingEnabled || MulticastZenPing.this.multicastChannel == null) {
                return;
            }
            DiscoveryNodes discoveryNodes = MulticastZenPing.this.contextProvider.nodes();
            final DiscoveryNode requestingNode = requestingNodeX;
            if (requestingNode.id().equals(discoveryNodes.localNodeId())) {
                return;
            }
            if (!requestClusterName.equals(MulticastZenPing.this.clusterName)) {
                if (MulticastZenPing.this.logger.isTraceEnabled()) {
                    MulticastZenPing.this.logger.trace("[{}] received ping_request from [{}], but wrong cluster_name [{}], expected [{}], ignoring", id, requestingNode, requestClusterName.value(), MulticastZenPing.this.clusterName.value());
                }
                return;
            }
            if (!discoveryNodes.localNode().shouldConnectTo(requestingNode)) {
                if (MulticastZenPing.this.logger.isTraceEnabled()) {
                    MulticastZenPing.this.logger.trace("[{}] received ping_request from [{}], both are client nodes, ignoring", id, requestingNode, requestClusterName);
                }
                return;
            }
            final MulticastPingResponse multicastPingResponse = new MulticastPingResponse();
            multicastPingResponse.id = id;
            multicastPingResponse.pingResponse = new ZenPing.PingResponse(discoveryNodes.localNode(), discoveryNodes.masterNode(), MulticastZenPing.this.clusterName, MulticastZenPing.this.contextProvider.nodeHasJoinedClusterOnce());
            if (MulticastZenPing.this.logger.isTraceEnabled()) {
                MulticastZenPing.this.logger.trace("[{}] received ping_request from [{}], sending {}", id, requestingNode, multicastPingResponse.pingResponse);
            }
            if (!MulticastZenPing.this.transportService.nodeConnected(requestingNode)) {
                MulticastZenPing.this.threadPool.generic().execute(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                MulticastZenPing.this.transportService.connectToNode(requestingNode);
                                MulticastZenPing.this.transportService.sendRequest(requestingNode, MulticastZenPing.ACTION_NAME, multicastPingResponse, new EmptyTransportResponseHandler("same"){

                                    @Override
                                    public void handleException(TransportException exp) {
                                        MulticastZenPing.this.logger.warn("failed to receive confirmation on sent ping response to [{}]", exp, requestingNode);
                                    }
                                });
                            }
                            catch (Exception e) {
                                if (!MulticastZenPing.this.lifecycle.started()) break block2;
                                MulticastZenPing.this.logger.warn("failed to connect to requesting node {}", e, requestingNode);
                            }
                        }
                    }
                });
            } else {
                MulticastZenPing.this.transportService.sendRequest(requestingNode, MulticastZenPing.ACTION_NAME, multicastPingResponse, new EmptyTransportResponseHandler("same"){

                    @Override
                    public void handleException(TransportException exp) {
                        if (MulticastZenPing.this.lifecycle.started()) {
                            MulticastZenPing.this.logger.warn("failed to receive confirmation on sent ping response to [{}]", exp, requestingNode);
                        }
                    }
                });
            }
        }
    }

    static class MulticastPingResponse
    extends TransportRequest {
        int id;
        ZenPing.PingResponse pingResponse;

        MulticastPingResponse() {
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readInt();
            this.pingResponse = ZenPing.PingResponse.readPingResponse(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeInt(this.id);
            this.pingResponse.writeTo(out);
        }
    }

    class MulticastPingResponseRequestHandler
    extends BaseTransportRequestHandler<MulticastPingResponse> {
        MulticastPingResponseRequestHandler() {
        }

        @Override
        public MulticastPingResponse newInstance() {
            return new MulticastPingResponse();
        }

        @Override
        public void messageReceived(MulticastPingResponse request, TransportChannel channel) throws Exception {
            ZenPing.PingCollection responses;
            if (MulticastZenPing.this.logger.isTraceEnabled()) {
                MulticastZenPing.this.logger.trace("[{}] received {}", request.id, request.pingResponse);
            }
            if ((responses = (ZenPing.PingCollection)MulticastZenPing.this.receivedResponses.get(request.id)) == null) {
                MulticastZenPing.this.logger.warn("received ping response {} with no matching id [{}]", request.pingResponse, request.id);
            } else {
                responses.addPing(request.pingResponse);
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    class FinalizingPingCollection
    extends ZenPing.PingCollection {
        private final ZenPing.PingCollection internalCollection;
        private final int expectedResponses;
        private final AtomicInteger responseCount;
        private final ZenPing.PingListener listener;
        private final int id;

        public FinalizingPingCollection(int id, ZenPing.PingCollection internalCollection, int expectedResponses, ZenPing.PingListener listener) {
            this.id = id;
            this.internalCollection = internalCollection;
            this.expectedResponses = expectedResponses;
            this.responseCount = new AtomicInteger();
            this.listener = listener;
        }

        @Override
        public synchronized boolean addPing(ZenPing.PingResponse ping) {
            if (this.internalCollection.addPing(ping)) {
                if (this.responseCount.incrementAndGet() >= this.expectedResponses) {
                    MulticastZenPing.this.logger.trace("[{}] all nodes responded", this.id);
                    this.finish();
                }
                return true;
            }
            return false;
        }

        @Override
        public synchronized void addPings(ZenPing.PingResponse[] pings) {
            this.internalCollection.addPings(pings);
        }

        @Override
        public synchronized ZenPing.PingResponse[] toArray() {
            return this.internalCollection.toArray();
        }

        void finish() {
            MulticastZenPing.this.threadPool.generic().execute(new AbstractRunnable(){

                @Override
                public void onFailure(Throwable t) {
                    MulticastZenPing.this.logger.error("failed to call ping listener", t, new Object[0]);
                }

                @Override
                protected void doRun() throws Exception {
                    MulticastZenPing.this.finalizePingCycle(FinalizingPingCollection.this.id, FinalizingPingCollection.this.listener);
                }
            });
        }
    }
}

