/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.Scroll;

public class SearchScrollRequest
extends ActionRequest<SearchScrollRequest> {
    private String scrollId;
    private Scroll scroll;

    public SearchScrollRequest() {
    }

    public SearchScrollRequest(String scrollId) {
        this.scrollId = scrollId;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scrollId == null) {
            validationException = ValidateActions.addValidationError("scrollId is missing", validationException);
        }
        return validationException;
    }

    public String scrollId() {
        return this.scrollId;
    }

    public SearchScrollRequest scrollId(String scrollId) {
        this.scrollId = scrollId;
        return this;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchScrollRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchScrollRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchScrollRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue(keepAlive, null)));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().before(Version.V_1_2_0)) {
            in.readByte();
        }
        this.scrollId = in.readString();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_1_2_0)) {
            out.writeByte((byte)2);
        }
        out.writeString(this.scrollId);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
    }
}

