/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.ArrayList;
import org.elasticsearch.Version;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.support.replication.ShardReplicationOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class BulkShardRequest
extends ShardReplicationOperationRequest<BulkShardRequest> {
    private int shardId;
    private BulkItemRequest[] items;
    private boolean refresh;

    BulkShardRequest() {
    }

    BulkShardRequest(BulkRequest bulkRequest, String index, int shardId, boolean refresh, BulkItemRequest[] items) {
        super(bulkRequest);
        this.index = index;
        this.shardId = shardId;
        this.items = items;
        this.refresh = refresh;
    }

    boolean refresh() {
        return this.refresh;
    }

    int shardId() {
        return this.shardId;
    }

    BulkItemRequest[] items() {
        return this.items;
    }

    @Override
    public String[] indices() {
        ArrayList<String> indices = new ArrayList<String>();
        for (BulkItemRequest item : this.items) {
            if (item == null) continue;
            indices.add(item.index());
        }
        return indices.toArray(new String[indices.size()]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.shardId);
        out.writeVInt(this.items.length);
        for (BulkItemRequest item : this.items) {
            if (item != null) {
                if (item.isIgnoreOnReplica() && out.getVersion().before(Version.V_1_3_3)) {
                    out.writeBoolean(false);
                    continue;
                }
                out.writeBoolean(true);
                item.writeTo(out);
                continue;
            }
            out.writeBoolean(false);
        }
        out.writeBoolean(this.refresh);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = in.readVInt();
        this.items = new BulkItemRequest[in.readVInt()];
        for (int i = 0; i < this.items.length; ++i) {
            if (!in.readBoolean()) continue;
            this.items[i] = BulkItemRequest.readBulkItem(in);
        }
        this.refresh = in.readBoolean();
    }
}

