/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OriginalIndices
implements IndicesRequest {
    public static OriginalIndices EMPTY = new OriginalIndices();
    private final String[] indices;
    private final IndicesOptions indicesOptions;

    private OriginalIndices() {
        this.indices = null;
        this.indicesOptions = null;
    }

    public OriginalIndices(IndicesRequest indicesRequest) {
        this(indicesRequest.indices(), indicesRequest.indicesOptions());
    }

    public OriginalIndices(String[] indices, IndicesOptions indicesOptions) {
        this.indices = indices;
        assert (indicesOptions != null);
        this.indicesOptions = indicesOptions;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public static OriginalIndices readOptionalOriginalIndices(StreamInput in) throws IOException {
        boolean empty;
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) && !(empty = in.readBoolean())) {
            return new OriginalIndices(in.readStringArray(), IndicesOptions.readIndicesOptions(in));
        }
        return EMPTY;
    }

    public static void writeOptionalOriginalIndices(OriginalIndices originalIndices, StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            boolean empty = originalIndices == EMPTY;
            out.writeBoolean(empty);
            if (!empty) {
                out.writeStringArrayNullable(originalIndices.indices);
                originalIndices.indicesOptions.writeIndicesOptions(out);
            }
        }
    }

    public static OriginalIndices readOriginalIndices(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            return new OriginalIndices(in.readStringArray(), IndicesOptions.readIndicesOptions(in));
        }
        return EMPTY;
    }

    public static void writeOriginalIndices(OriginalIndices originalIndices, StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeStringArrayNullable(originalIndices.indices);
            originalIndices.indicesOptions.writeIndicesOptions(out);
        }
    }
}

