/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class JavaAtomicFixnumLibrary
implements Library {
    private static final ObjectAllocator JRUBYREFERENCE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JavaAtomicFixnum(ruby, rubyClass);
        }
    };

    public void load(Ruby ruby, boolean bl) throws IOException {
        RubyModule rubyModule = ruby.defineModule("Concurrent");
        RubyClass rubyClass = rubyModule.defineClassUnder("JavaAtomicFixnum", ruby.getObject(), JRUBYREFERENCE_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(JavaAtomicFixnum.class);
    }

    @JRubyClass(name={"JavaAtomicFixnum"}, parent="Object")
    public static class JavaAtomicFixnum
    extends RubyObject {
        private AtomicLong atomicLong;

        public JavaAtomicFixnum(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext) {
            this.atomicLong = new AtomicLong(0L);
            return threadContext.nil;
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.atomicLong = new AtomicLong(this.rubyFixnumToLong(iRubyObject));
            return threadContext.nil;
        }

        @JRubyMethod(name={"value"})
        public IRubyObject getValue() {
            return this.getRuntime().newFixnum(this.atomicLong.get());
        }

        @JRubyMethod(name={"value="})
        public IRubyObject setValue(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.atomicLong.set(this.rubyFixnumToLong(iRubyObject));
            return threadContext.nil;
        }

        @JRubyMethod(name={"increment", "up"})
        public IRubyObject increment() {
            return this.getRuntime().newFixnum(this.atomicLong.incrementAndGet());
        }

        @JRubyMethod(name={"decrement", "down"})
        public IRubyObject decrement() {
            return this.getRuntime().newFixnum(this.atomicLong.decrementAndGet());
        }

        @JRubyMethod(name={"compare_and_set"})
        public IRubyObject compareAndSet(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return this.getRuntime().newBoolean(this.atomicLong.compareAndSet(this.rubyFixnumToLong(iRubyObject), this.rubyFixnumToLong(iRubyObject2)));
        }

        private long rubyFixnumToLong(IRubyObject iRubyObject) {
            if (iRubyObject instanceof RubyFixnum) {
                RubyFixnum rubyFixnum = (RubyFixnum)iRubyObject;
                return rubyFixnum.getLongValue();
            }
            throw this.getRuntime().newArgumentError("initial value must be a Fixnum");
        }
    }
}

