/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class FlipNode
extends Node {
    private final Node beginNode;
    private final Node endNode;
    private final boolean exclusive;
    private final int location;

    public FlipNode(ISourcePosition position, Node beginNode, Node endNode, boolean exclusive2, int location) {
        super(position);
        assert (beginNode != null) : "beginNode is not null";
        assert (endNode != null) : "endNode is not null";
        this.beginNode = beginNode;
        this.endNode = endNode;
        this.exclusive = exclusive2;
        this.location = location;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.FLIPNODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitFlipNode(this);
    }

    public Node getBeginNode() {
        return this.beginNode;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.beginNode, this.endNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self2, Block aBlock) {
        DynamicScope scope = context.getCurrentScope();
        IRubyObject nil = runtime.getNil();
        int index2 = this.getIndex();
        DynamicScope flipScope = scope.getFlipScope();
        flipScope.growIfNeeded();
        IRubyObject result2 = flipScope.getValueDepthZeroOrNil(index2, nil);
        if (this.exclusive) {
            if (result2 == null || !result2.isTrue()) {
                result2 = FlipNode.trueIfTrue(runtime, this.beginNode.interpret(runtime, context, self2, aBlock));
                flipScope.setValueDepthZero(result2, index2);
                return result2;
            }
            if (this.endNode.interpret(runtime, context, self2, aBlock).isTrue()) {
                flipScope.setValueDepthZero(runtime.getFalse(), index2);
            }
            return runtime.getTrue();
        }
        if (result2 == null || !result2.isTrue()) {
            if (this.beginNode.interpret(runtime, context, self2, aBlock).isTrue()) {
                flipScope.setValueDepthZero(FlipNode.falseIfTrue(runtime, this.endNode.interpret(runtime, context, self2, aBlock)), index2);
                return runtime.getTrue();
            }
            return runtime.getFalse();
        }
        if (this.endNode.interpret(runtime, context, self2, aBlock).isTrue()) {
            flipScope.setValueDepthZero(runtime.getFalse(), index2);
        }
        return runtime.getTrue();
    }

    private static RubyBoolean trueIfTrue(Ruby runtime, IRubyObject truish) {
        return truish.isTrue() ? runtime.getTrue() : runtime.getFalse();
    }

    private static RubyBoolean falseIfTrue(Ruby runtime, IRubyObject truish) {
        return truish.isTrue() ? runtime.getFalse() : runtime.getTrue();
    }
}

