/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.connections.socket;

import com.sun.star.comp.loader.FactoryHelper;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.lib.connections.socket.ConnectionDescriptor;
import com.sun.star.lib.connections.socket.SocketConnection;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.RuntimeException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class socketAcceptor
implements XAcceptor {
    public static final String __serviceName = "com.sun.star.connection.socketAcceptor";
    private static final boolean DEBUG = false;
    private ServerSocket server = null;
    private String acceptingDescription;
    private Boolean tcpNoDelay;

    public static XSingleServiceFactory __getServiceFactory(String string, XMultiServiceFactory xMultiServiceFactory, XRegistryKey xRegistryKey) {
        return string.equals(socketAcceptor.class.getName()) ? FactoryHelper.getServiceFactory(socketAcceptor.class, __serviceName, xMultiServiceFactory, xRegistryKey) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XConnection accept(String string) throws AlreadyAcceptingException, ConnectionSetupException, IllegalArgumentException {
        ServerSocket serverSocket;
        Object object = this;
        synchronized (object) {
            if (this.server == null) {
                ConnectionDescriptor connectionDescriptor = new ConnectionDescriptor(string);
                String string2 = connectionDescriptor.getHost();
                if (string2.equals("0")) {
                    string2 = null;
                }
                try {
                    this.server = new ServerSocket(connectionDescriptor.getPort(), connectionDescriptor.getBacklog(), string2 == null ? null : InetAddress.getByName(string2));
                }
                catch (IOException iOException) {
                    throw new ConnectionSetupException(iOException);
                }
                this.acceptingDescription = string;
                this.tcpNoDelay = connectionDescriptor.getTcpNoDelay();
            } else if (!string.equals(this.acceptingDescription)) {
                throw new AlreadyAcceptingException(this.acceptingDescription + " vs. " + string);
            }
            serverSocket = this.server;
        }
        try {
            object = serverSocket.accept();
            if (this.tcpNoDelay != null) {
                ((Socket)object).setTcpNoDelay(this.tcpNoDelay);
            }
            return new SocketConnection(this.acceptingDescription, (Socket)object);
        }
        catch (IOException iOException) {
            throw new ConnectionSetupException(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAccepting() {
        ServerSocket serverSocket;
        socketAcceptor socketAcceptor2 = this;
        synchronized (socketAcceptor2) {
            serverSocket = this.server;
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

