/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml;

import java.awt.Color;
import org.openoffice.xmerge.converter.xml.Style;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.util.Debug;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextStyle
extends Style
implements Cloneable {
    private static final int BOLD = 1;
    private static final int ITALIC = 2;
    private static final int UNDERLINE = 4;
    private static final int STRIKETHRU = 8;
    private static final int SUPERSCRIPT = 16;
    private static final int SUBSCRIPT = 32;
    private int values = 0;
    private int mask = 0;
    private int sizeInPoints = 0;
    private String fontName = null;
    private Color fontColor = null;
    private Color bgColor = null;
    private static String[] ignored = new String[]{"style:text-autospace", "style:text-underline-color", "fo:margin-left", "fo:margin-right", "fo:text-indent", "fo:margin-top", "fo:margin-bottom", "text:line-number", "text:number-lines", "style:country-asian", "style:font-size-asian", "style:font-name-complex", "style:language-complex", "style:country-complex", "style:font-size-complex", "style:punctuation-wrap", "fo:language", "fo:country", "style:font-name-asian", "style:language-asian", "style:line-break", "fo:keep-with-next"};

    public TextStyle(Node node, StyleCatalog styleCatalog) {
        super(node, styleCatalog);
        int n;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                this.handleAttribute(node2.getNodeName(), node2.getNodeValue());
            }
        }
        if (!node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getChildNodes();
        n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap namedNodeMap2;
            Node node3 = nodeList.item(i);
            String string = node3.getNodeName();
            if (!string.equals("style:properties") || (namedNodeMap2 = node3.getAttributes()) == null) continue;
            int n3 = namedNodeMap2.getLength();
            for (int j = 0; j < n3; ++j) {
                Node node4 = namedNodeMap2.item(j);
                this.handleAttribute(node4.getNodeName(), node4.getNodeValue());
            }
        }
    }

    public TextStyle(String string, String string2, String string3, int n, int n2, int n3, String string4, StyleCatalog styleCatalog) {
        super(string, string2, string3, styleCatalog);
        this.mask = n;
        this.values = n2;
        this.sizeInPoints = n3;
        this.fontName = string4;
    }

    private Color parseColorString(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            n = Integer.parseInt(string.substring(1, 3), 16);
            n2 = Integer.parseInt(string.substring(3, 5), 16);
            n3 = Integer.parseInt(string.substring(5, 7), 16);
        }
        catch (NumberFormatException numberFormatException) {
            Debug.log(2, "Problem parsing a color string", numberFormatException);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            Debug.log(2, "Problem parsing a color string", indexOutOfBoundsException);
        }
        return new Color(n, n2, n3);
    }

    private void handleAttribute(String string, String string2) {
        if (string.equals("fo:font-weight")) {
            if (string2.equals("bold")) {
                this.turnAttributesOn(1);
            } else if (string2.equals("normal")) {
                this.turnAttributesOff(1);
            }
        } else if (string.equals("fo:font-style")) {
            if (string2.equals("italic")) {
                this.turnAttributesOn(2);
            } else if (string2.equals("oblique")) {
                this.turnAttributesOn(2);
            } else if (string2.equals("normal")) {
                this.turnAttributesOff(2);
            }
        } else if (string.equals("style:text-underline")) {
            if (string2.equals("none")) {
                this.turnAttributesOff(4);
            } else {
                this.turnAttributesOn(4);
            }
        } else if (string.equals("style:text-crossing-out")) {
            if (string2.equals("none")) {
                this.turnAttributesOff(8);
            } else {
                this.turnAttributesOn(8);
            }
        } else if (string.equals("style:text-position")) {
            if (string2.startsWith("super ")) {
                this.turnAttributesOn(16);
            } else if (string2.startsWith("sub ")) {
                this.turnAttributesOn(32);
            } else if (string2.startsWith("0% ")) {
                this.turnAttributesOff(48);
            } else {
                String string3 = string2.substring(0, string2.indexOf(32));
                if (string3.endsWith("%")) {
                    int n;
                    string3 = string3.substring(0, string2.indexOf(37));
                    try {
                        n = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 0;
                        Debug.log(2, "Problem with style:text-position tag", numberFormatException);
                    }
                    if (n < 0) {
                        this.turnAttributesOn(32);
                    } else if (n > 0) {
                        this.turnAttributesOn(16);
                    }
                }
            }
        } else if (string.equals("fo:font-size")) {
            if (string2.endsWith("pt")) {
                String string4 = string2.substring(0, string2.length() - 2);
                this.sizeInPoints = Integer.parseInt(string4);
            }
        } else if (string.equals("style:font-name")) {
            this.fontName = string2;
        } else if (string.equals("fo:color")) {
            this.fontColor = this.parseColorString(string2);
        } else if (string.equals("style:text-background-color")) {
            this.bgColor = this.parseColorString(string2);
        } else if (!this.isIgnored(string)) {
            Debug.log(1, "TextStyle Unhandled: " + string + "=" + string2);
        }
    }

    public int getFontSize() {
        return this.sizeInPoints;
    }

    public String getFontName() {
        return this.fontName;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public Style getResolved() {
        TextStyle textStyle = null;
        try {
            textStyle = (TextStyle)this.clone();
        }
        catch (Exception exception) {
            Debug.log(2, "Can't clone", exception);
        }
        TextStyle textStyle2 = null;
        if (this.sc != null) {
            if (this.parent != null) {
                textStyle2 = (TextStyle)this.sc.lookup(this.parent, this.family, null, this.getClass());
                if (textStyle2 == null) {
                    Debug.log(2, "parent style lookup of " + this.parent + " failed!");
                } else {
                    textStyle2 = (TextStyle)textStyle2.getResolved();
                }
            } else if (!this.name.equals("DEFAULT_STYLE")) {
                textStyle2 = (TextStyle)this.sc.lookup("DEFAULT_STYLE", null, null, this.getClass());
            }
        }
        if (textStyle2 != null) {
            textStyle2 = (TextStyle)textStyle2.getResolved();
            if (this.sizeInPoints == 0 && textStyle2.sizeInPoints != 0) {
                textStyle.sizeInPoints = textStyle2.sizeInPoints;
            }
            if (this.fontName == null && textStyle2.fontName != null) {
                textStyle.fontName = textStyle2.fontName;
            }
            if (this.fontColor == null && textStyle2.fontColor != null) {
                textStyle.fontColor = textStyle2.fontColor;
            }
            if (this.bgColor == null && textStyle2.bgColor != null) {
                textStyle.bgColor = textStyle2.bgColor;
            }
            for (int i = 1; i <= 32; i <<= 1) {
                if ((this.mask & i) != 0 || (textStyle2.mask & i) == 0) continue;
                textStyle.mask |= i;
                textStyle.values |= textStyle2.mask & i;
            }
        }
        return textStyle;
    }

    private void turnAttributesOn(int n) {
        this.mask |= n;
        this.values |= n;
    }

    private void turnAttributesOff(int n) {
        this.mask |= n;
        this.values &= ~n;
    }

    private static String toCSV(String string) {
        if (string != null) {
            return "\"" + string + "\",";
        }
        return "\"\",";
    }

    private static String toLastCSV(String string) {
        if (string != null) {
            return "\"" + string + "\"";
        }
        return "\"\"";
    }

    public static void dumpHdr() {
        System.out.println(TextStyle.toCSV("Name") + TextStyle.toCSV("Family") + TextStyle.toCSV("parent") + TextStyle.toCSV("Font") + TextStyle.toCSV("Size") + TextStyle.toCSV("Bold") + TextStyle.toCSV("Italic") + TextStyle.toCSV("Underline") + TextStyle.toCSV("Strikethru") + TextStyle.toCSV("Superscript") + TextStyle.toLastCSV("Subscript"));
    }

    public void dumpCSV() {
        String string = "";
        for (int i = 1; i <= 32; i <<= 1) {
            string = (i & this.mask) != 0 ? string + TextStyle.toCSV((i & this.values) != 0 ? "yes" : "no") : string + TextStyle.toCSV(null);
        }
        System.out.println(TextStyle.toCSV(this.name) + TextStyle.toCSV(this.family) + TextStyle.toCSV(this.parent) + TextStyle.toCSV(this.fontName) + TextStyle.toCSV("" + this.sizeInPoints) + string + TextStyle.toLastCSV(null));
    }

    public Node createNode(Document document, String string) {
        Element element = document.createElement(string);
        this.writeAttributes(element);
        return element;
    }

    public boolean isSubset(Style style) {
        if (style.getClass() != this.getClass()) {
            return false;
        }
        TextStyle textStyle = (TextStyle)style;
        if (textStyle.values != this.values) {
            return false;
        }
        if (textStyle.sizeInPoints != 0 && this.sizeInPoints != textStyle.sizeInPoints) {
            return false;
        }
        if (textStyle.fontName != null) {
            if (this.fontName == null) {
                return false;
            }
            if (!this.fontName.equals(textStyle.fontName)) {
                return false;
            }
        }
        if (textStyle.fontColor != null) {
            if (this.fontColor == null) {
                return false;
            }
            if (!this.fontColor.equals(textStyle.fontColor)) {
                return false;
            }
        }
        if (textStyle.bgColor != null) {
            if (this.bgColor == null) {
                return false;
            }
            if (!this.bgColor.equals(textStyle.bgColor)) {
                return false;
            }
        }
        return true;
    }

    private void writeAttributes(Element element) {
        if ((this.mask & 1) != 0 && (this.values & 1) != 0) {
            element.setAttribute("fo:font-weight", "bold");
        }
        if ((this.mask & 2) != 0 && (this.values & 2) != 0) {
            element.setAttribute("fo:font-style", "italic");
        }
        if ((this.mask & 4) != 0 && (this.values & 4) != 0) {
            element.setAttribute("style:text-underline", "single");
        }
        if ((this.mask & 8) != 0 && (this.values & 8) != 0) {
            element.setAttribute("style:text-crossing-out", "single-line");
        }
        if ((this.mask & 0x10) != 0 && (this.values & 0x10) != 0) {
            element.setAttribute("style:text-position", "super 58%");
        }
        if ((this.mask & 0x20) != 0 && (this.values & 0x20) != 0) {
            element.setAttribute("style:text-position", "sub 58%");
        }
        if (this.sizeInPoints != 0) {
            element.setAttribute("fo:font-size", Integer.toString(this.sizeInPoints) + "pt");
        }
        if (this.fontName != null) {
            element.setAttribute("style:font-name", this.fontName);
        }
        if (this.fontColor != null) {
            element.setAttribute("fo:color", this.buildColorString(this.fontColor));
        }
        if (this.bgColor != null) {
            element.setAttribute("style:text-background-color", this.buildColorString(this.bgColor));
        }
    }

    private String buildColorString(Color color) {
        return String.format("#%06X", color.getRGB() & 0xFFFFFF);
    }

    private boolean isIgnored(String string) {
        for (String string2 : ignored) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

