/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.jfree.report.JFreeReportBoot;
import org.libreoffice.report.OutputRepository;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class ManifestWriter {
    public static final String MANIFEST_NS = "urn:oasis:names:tc:opendocument:xmlns:manifest:1.0";
    public static final String TAG_DEF_PREFIX = "org.libreoffice.report.pentaho.output.";
    private final Map<String, String> entries = new HashMap<String, String>();

    public void addEntry(String string, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string2 == null) {
            throw new NullPointerException();
        }
        if ("META-INF/manifest.xml".equals(string)) {
            return;
        }
        this.entries.put(string, string2);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public void write(OutputRepository outputRepository) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        DefaultTagDescription defaultTagDescription = new DefaultTagDescription();
        defaultTagDescription.configure(JFreeReportBoot.getInstance().getGlobalConfig(), TAG_DEF_PREFIX);
        OutputStream outputStream = outputRepository.createOutputStream("META-INF/manifest.xml", "text/xml");
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        XmlWriter xmlWriter = new XmlWriter((Writer)outputStreamWriter, (TagDescription)defaultTagDescription);
        xmlWriter.setAlwaysAddNamespace(true);
        xmlWriter.writeXmlDeclaration("UTF-8");
        AttributeList attributeList = new AttributeList();
        attributeList.addNamespaceDeclaration("manifest", MANIFEST_NS);
        xmlWriter.writeTag(MANIFEST_NS, "manifest", attributeList, false);
        for (Map.Entry<String, String> entry : this.entries.entrySet()) {
            AttributeList attributeList2 = new AttributeList();
            attributeList2.setAttribute(MANIFEST_NS, "media-type", entry.getValue());
            attributeList2.setAttribute(MANIFEST_NS, "full-path", entry.getKey());
            xmlWriter.writeTag(MANIFEST_NS, "file-entry", attributeList2, true);
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
    }
}

