/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XFrame;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import com.sun.star.wizards.common.Properties;
import com.sun.star.wizards.common.PropertyNames;

public class DocumentPreview {
    private XFrame xFrame;
    private final XControl xControl;
    private PropertyValue[] loadArgs;
    private String url;
    public static final int PREVIEW_MODE = 1;

    public DocumentPreview(XMultiServiceFactory xMultiServiceFactory, Object object) throws Exception {
        this.xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)object);
        this.createPreviewFrame(xMultiServiceFactory, this.xControl);
    }

    protected XComponent setDocument(String string, String[] stringArray, Object[] objectArray) throws IllegalArgumentException, IOException {
        this.url = string;
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            properties.put(stringArray[i], objectArray[i]);
        }
        return this.setDocument(this.url, properties.getProperties());
    }

    protected XComponent setDocument(String string, PropertyValue[] propertyValueArray) throws IllegalArgumentException, IOException {
        this.loadArgs = propertyValueArray;
        XComponentLoader xComponentLoader = (XComponentLoader)UnoRuntime.queryInterface(XComponentLoader.class, (Object)this.xFrame);
        this.xFrame.activate();
        return xComponentLoader.loadComponentFromURL(string, "_self", 0, this.loadArgs);
    }

    public void reload(XMultiServiceFactory xMultiServiceFactory) throws IllegalArgumentException, IOException, CloseVetoException, com.sun.star.uno.Exception {
        this.closeFrame();
        this.createPreviewFrame(xMultiServiceFactory, this.xControl);
        this.setDocument(this.url, this.loadArgs);
    }

    private void closeFrame() throws CloseVetoException {
        if (this.xFrame != null) {
            ((XCloseable)UnoRuntime.queryInterface(XCloseable.class, (Object)this.xFrame)).close(false);
        }
    }

    public XComponent setDocument(String string, int n) throws IllegalArgumentException, IOException {
        switch (n) {
            case 1: {
                return this.setDocument(string, new String[]{"Preview", PropertyNames.READ_ONLY}, new Object[]{Boolean.TRUE, Boolean.TRUE});
            }
        }
        return null;
    }

    public void createPreviewFrame(XMultiServiceFactory xMultiServiceFactory, XControl xControl) throws com.sun.star.uno.Exception, IllegalArgumentException {
        XWindowPeer xWindowPeer = xControl.getPeer();
        XWindow xWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xControl);
        Rectangle rectangle = xWindow.getPosSize();
        Object object = xMultiServiceFactory.createInstance("com.sun.star.awt.Toolkit");
        XToolkit xToolkit = (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)object);
        WindowDescriptor windowDescriptor = new WindowDescriptor();
        windowDescriptor.Type = WindowClass.SIMPLE;
        windowDescriptor.WindowServiceName = "window";
        windowDescriptor.ParentIndex = (short)-1;
        windowDescriptor.Parent = xWindowPeer;
        windowDescriptor.Bounds = new Rectangle(0, 0, rectangle.Width, rectangle.Height);
        windowDescriptor.WindowAttributes = 524289;
        XWindowPeer xWindowPeer2 = xToolkit.createWindow(windowDescriptor);
        XWindow xWindow2 = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)xWindowPeer2);
        Object object2 = xMultiServiceFactory.createInstance("com.sun.star.frame.Frame");
        this.xFrame = (XFrame)UnoRuntime.queryInterface(XFrame.class, (Object)object2);
        this.xFrame.initialize(xWindow2);
        xWindow2.setVisible(true);
    }

    public void dispose() {
        try {
            this.closeFrame();
        }
        catch (CloseVetoException closeVetoException) {
            closeVetoException.printStackTrace();
        }
    }
}

