/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.db;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NumberFormatter;
import com.sun.star.wizards.db.BlindtextCreator;
import com.sun.star.wizards.db.CommandMetaData;
import com.sun.star.wizards.db.DBMetaData;

public class FieldColumn {
    protected int ColIndex;
    private Object DefaultValue;
    private String m_sFieldName;
    private String m_sDisplayFieldName;
    private String FieldTitle;
    private String m_sCommandName;
    private int m_nDBFormatKey;
    private int m_nFieldType;
    private XPropertySet m_xColPropertySet;
    private int FieldWidth;
    private int StandardFormatKey;
    private boolean bIsNumberFormat;
    private static boolean bFormatKeysInitialized = false;
    private static int iDateFormatKey;
    private static int iDateTimeFormatKey;
    private static int iNumberFormatKey;
    private static int iTextFormatKey;
    private static int iTimeFormatKey;
    private static int iLogicalFormatKey;
    private CommandMetaData m_aCommandMetaData;

    public FieldColumn(CommandMetaData commandMetaData, String string) {
        this.m_sDisplayFieldName = string;
        this.m_sCommandName = commandMetaData.getCommandName();
        this.FieldTitle = this.m_sFieldName = this.getOnlyFieldName(this.m_sDisplayFieldName, this.m_sCommandName);
        DBMetaData.CommandObject commandObject = commandMetaData.getTableByName(this.m_sCommandName);
        this.initializeFormatKeys(commandMetaData, commandObject.getColumns());
    }

    public FieldColumn(CommandMetaData commandMetaData, String string, String string2, boolean bl) {
        this.m_sCommandName = string2;
        if (bl) {
            this.m_sDisplayFieldName = string;
            this.m_sFieldName = this.getOnlyFieldName(string, string2);
        } else {
            this.m_sFieldName = string;
            this.m_sDisplayFieldName = FieldColumn.composeDisplayFieldName(string2, this.m_sFieldName);
        }
        this.FieldTitle = this.m_sFieldName;
        this.m_aCommandMetaData = commandMetaData;
    }

    public FieldColumn(CommandMetaData commandMetaData, XNameAccess xNameAccess, String string) {
        this.m_sDisplayFieldName = this.m_sFieldName = string;
        this.ColIndex = JavaTools.FieldInList(xNameAccess.getElementNames(), this.m_sFieldName) + 1;
        this.initializeFormatKeys(commandMetaData, xNameAccess);
        try {
            this.m_sCommandName = (String)this.m_xColPropertySet.getPropertyValue("TableName");
        }
        catch (UnknownPropertyException unknownPropertyException) {
        }
        catch (WrappedTargetException wrappedTargetException) {
            // empty catch block
        }
    }

    public int getFieldType() {
        if (this.m_nFieldType == 0) {
            DBMetaData.CommandObject commandObject = this.m_aCommandMetaData.getTableByName(this.m_sCommandName);
            this.initializeFormatKeys(this.m_aCommandMetaData, commandObject.getColumns());
        }
        return this.m_nFieldType;
    }

    public int getFieldWidth() {
        this.getFieldType();
        return this.FieldWidth;
    }

    public int getDBFormatKey() {
        this.getFieldType();
        return this.m_nDBFormatKey;
    }

    public int getStandardFormatKey() {
        this.getFieldType();
        return this.StandardFormatKey;
    }

    public boolean isNumberFormat() {
        this.getFieldType();
        return this.bIsNumberFormat;
    }

    private String getOnlyFieldName(String string, String string2) {
        return string.substring(string2.length() + 1, string.length());
    }

    public static String composeDisplayFieldName(String string, String string2) {
        return string + "." + string2;
    }

    private void initializeFormatKeys(CommandMetaData commandMetaData, XNameAccess xNameAccess) {
        try {
            if (!bFormatKeysInitialized) {
                NumberFormatter numberFormatter = commandMetaData.getNumberFormatter();
                iDateFormatKey = numberFormatter.getDateFormatKey();
                iDateTimeFormatKey = numberFormatter.getDateTimeFormatKey();
                iNumberFormatKey = numberFormatter.getNumberFormatKey();
                iTextFormatKey = numberFormatter.getTextFormatKey();
                iTimeFormatKey = numberFormatter.getTimeFormatKey();
                iLogicalFormatKey = numberFormatter.getLogicalFormatKey();
                bFormatKeysInitialized = true;
            }
            this.m_xColPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xNameAccess.getByName(this.m_sFieldName));
            this.ColIndex = JavaTools.FieldInList(xNameAccess.getElementNames(), this.m_sFieldName) + 1;
            this.m_nFieldType = AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Type"));
            this.getTyperelatedFieldData();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public XPropertySet getXColumnPropertySet() {
        this.getFieldType();
        return this.m_xColPropertySet;
    }

    public void setCommandName(String string) {
        this.m_sCommandName = string;
    }

    public String getDisplayFieldName() {
        return this.m_sDisplayFieldName;
    }

    public String getCommandName() {
        return this.m_sCommandName;
    }

    public String getFieldName() {
        return this.m_sFieldName;
    }

    public String getFieldTitle() {
        return this.FieldTitle;
    }

    public void setFieldTitle(String string) {
        this.FieldTitle = string;
    }

    public static String getCommandName(String string) {
        String string2 = null;
        String[] stringArray = JavaTools.ArrayoutofString(string, ".");
        if (stringArray.length >= 2) {
            String string3 = stringArray[stringArray.length - 1];
            string2 = string.substring(0, string.length() - string3.length() - 1);
        }
        return string2;
    }

    public boolean isBoolean() {
        boolean bl = false;
        switch (this.getFieldType()) {
            case -7: 
            case 16: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private void getTyperelatedFieldData() {
        try {
            switch (this.getFieldType()) {
                case -7: 
                case 16: {
                    this.StandardFormatKey = iLogicalFormatKey;
                    this.FieldWidth = 5;
                    this.bIsNumberFormat = true;
                    break;
                }
                case -6: 
                case 5: {
                    this.StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 5;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 4: {
                    this.StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case -5: {
                    this.StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 15;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 1: {
                    this.StandardFormatKey = iTextFormatKey;
                    this.getTextFieldWidth(10);
                    this.bIsNumberFormat = false;
                    break;
                }
                case 12: {
                    this.StandardFormatKey = iTextFormatKey;
                    this.getTextFieldWidth(30);
                    this.bIsNumberFormat = false;
                    break;
                }
                case -1: {
                    this.StandardFormatKey = iTextFormatKey;
                    this.getTextFieldWidth(60);
                    this.bIsNumberFormat = false;
                    break;
                }
                case 2: {
                    this.StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 20;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    this.StandardFormatKey = iNumberFormatKey;
                    this.FieldWidth = 10 + AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Scale")) + 1;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 91: {
                    this.StandardFormatKey = iDateFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 92: {
                    this.StandardFormatKey = iTimeFormatKey;
                    this.FieldWidth = 10;
                    this.bIsNumberFormat = true;
                    break;
                }
                case 93: {
                    this.StandardFormatKey = iDateTimeFormatKey;
                    this.FieldWidth = 20;
                    this.bIsNumberFormat = true;
                }
            }
            Object object = this.m_xColPropertySet.getPropertyValue("FormatKey");
            this.m_nDBFormatKey = AnyConverter.isVoid((Object)object) ? this.StandardFormatKey : AnyConverter.toInt((Object)object);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
            this.m_nDBFormatKey = this.StandardFormatKey;
        }
    }

    private void getTextFieldWidth(int n) {
        try {
            this.FieldWidth = AnyConverter.toInt((Object)this.m_xColPropertySet.getPropertyValue("Precision"));
            if (this.FieldWidth > 0) {
                if (this.FieldWidth > 2 * n) {
                    this.FieldWidth = 2 * n;
                } else if (this.FieldWidth == 0) {
                    this.FieldWidth = n;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void initDefaultValue() {
        switch (this.getFieldType()) {
            case -7: 
            case 16: {
                this.DefaultValue = Integer.valueOf("1");
                break;
            }
            case -6: {
                this.DefaultValue = Integer.valueOf("98");
                break;
            }
            case 5: {
                this.DefaultValue = Integer.valueOf("987");
                break;
            }
            case 4: {
                this.DefaultValue = Integer.valueOf("9876");
                break;
            }
            case -5: {
                this.DefaultValue = Integer.valueOf("98765");
                break;
            }
            case 1: {
                this.DefaultValue = String.valueOf('x');
                break;
            }
            case -1: 
            case 12: {
                this.DefaultValue = BlindtextCreator.getBlindTextString(this.FieldTitle, this.FieldWidth, this.FieldWidth);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                this.DefaultValue = Double.valueOf("9876.54");
                break;
            }
            case 91: {
                this.DefaultValue = Double.valueOf("42510");
                break;
            }
            case 92: {
                this.DefaultValue = Double.valueOf("10");
                break;
            }
            case 93: {
                this.DefaultValue = Double.valueOf("5454110");
                break;
            }
        }
    }

    public Object getDefaultValue() {
        if (this.DefaultValue == null) {
            this.initDefaultValue();
        }
        return this.DefaultValue;
    }
}

