/*
 * Decompiled with CFR 0.152.
 */
package gnu.q2.lang;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.Language;
import gnu.expr.NameLookup;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.PairWithPosition;
import gnu.mapping.Symbol;
import gnu.q2.lang.Operator;
import gnu.q2.lang.Q2;
import gnu.q2.lang.Q2Apply;
import gnu.text.SourceMessages;
import java.util.Stack;
import kawa.lang.SyntaxForm;
import kawa.lang.Translator;
import kawa.standard.SchemeCompilation;

public class Q2Translator
extends SchemeCompilation {
    public Q2Translator(Language language, SourceMessages messages, NameLookup lexical) {
        super(language, messages, lexical);
    }

    public static Object partition(Object p, Translator tr) {
        Stack<Object> st = new Stack<Object>();
        st.add(Operator.FENCE);
        Object larg = p;
        Pair prev = null;
        while (true) {
            Pair pp2;
            if (p instanceof SyntaxForm) {
                // empty if block
            }
            Operator op = null;
            if (p == LList.Empty) {
                op = Operator.FENCE;
                pp2 = null;
            } else {
                Object value;
                Declaration decl;
                Expression func;
                if (!(p instanceof Pair)) {
                    tr.error('e', "unexpected non-list");
                    break;
                }
                pp2 = (Pair)p;
                Object obj = pp2.getCar();
                if (obj instanceof Symbol && !Q2.instance.selfEvaluatingSymbol(obj) && (func = tr.rewrite(obj, true)) instanceof ReferenceExp && (decl = ((ReferenceExp)func).getBinding()) != null && (value = decl.getConstantValue()) instanceof Operator) {
                    op = (Operator)value;
                }
            }
            if (op != null) {
                if (prev == null) {
                    larg = LList.Empty;
                } else {
                    prev.setCdrBackdoor(LList.Empty);
                }
                int stsz = st.size();
                Operator topop = (Operator)st.get(stsz - 1);
                while (op.lprio <= topop.rprio) {
                    larg = topop.combine((LList)st.get(stsz - 3), larg, (PairWithPosition)st.get(stsz - 2));
                    st.setSize(stsz -= 3);
                    topop = (Operator)st.get(stsz - 1);
                }
                if (pp2 == null) break;
                st.add(larg);
                st.add(pp2);
                st.add(op);
                larg = pp2.getCdr();
                prev = null;
            } else {
                prev = pp2;
            }
            p = pp2.getCdr();
        }
        return larg;
    }

    @Override
    public void scanForm(Object st, ScopeExp defs) {
        if (st instanceof LList) {
            st = Q2Translator.partition(st, this);
        }
        if (st != LList.Empty) {
            super.scanForm(st, defs);
        }
    }

    @Override
    public Expression rewrite(Object exp, boolean function2) {
        if (exp == LList.Empty) {
            return QuoteExp.voidExp;
        }
        return super.rewrite(exp, function2);
    }

    @Override
    public Expression rewrite_pair(Pair p, boolean function2) {
        Object partitioned = Q2Translator.partition(p, this);
        if (partitioned instanceof Pair) {
            return super.rewrite_pair((Pair)partitioned, function2);
        }
        return this.rewrite(partitioned, function2);
    }

    @Override
    public Expression applyFunction(Expression func) {
        return new QuoteExp(Q2Apply.q2Apply);
    }

    @Override
    public boolean isApplyFunction(Expression exp) {
        return exp.valueIfConstant() == Q2Apply.q2Apply;
    }
}

