/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.io;

import gnu.kawa.io.FilePath;
import gnu.kawa.io.URIPath;
import gnu.kawa.io.URLPath;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongType;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.tools.FileObject;

public abstract class Path
implements FileObject {
    public static final FilePath userDirPath = FilePath.valueOf(System.getProperty("user.dir"));
    public static final ThreadLocal<Path> pathLocation = new InheritableThreadLocal<Path>(){

        @Override
        protected Path initialValue() {
            return userDirPath;
        }

        @Override
        public void set(Path path) {
            if (path == null) {
                super.remove();
            } else {
                if (!path.isAbsolute()) {
                    path = path.getAbsolute();
                }
                super.set(path);
            }
        }
    };
    public static final Object PATH_CURRENT = new String("<current>");
    public static final Object PATH_RELATIVE = new String("<relative>");

    protected Path() {
    }

    public static Path currentPath() {
        return pathLocation.get();
    }

    public static void setCurrentPath(Path path) {
        pathLocation.set(path);
    }

    public static Path coerceToPathOrNull(Object path) {
        if (path instanceof Path) {
            return (Path)path;
        }
        if (path instanceof URL) {
            return URLPath.valueOf((URL)path);
        }
        if (path instanceof URI) {
            return URIPath.valueOf((URI)path);
        }
        if (path instanceof File) {
            return FilePath.valueOf((File)path);
        }
        if (!(path instanceof CharSequence)) {
            return null;
        }
        String str = path.toString();
        if (Path.uriSchemeSpecified(str)) {
            return URIPath.valueOf(str);
        }
        return FilePath.valueOf(str);
    }

    public static Path valueOf(Object arg) {
        Path path = Path.coerceToPathOrNull(arg);
        if (path == null) {
            throw new WrongType((String)null, -4, arg, "path");
        }
        return path;
    }

    public static URL toURL(String str) {
        try {
            if (!Path.uriSchemeSpecified(str)) {
                Path cur = Path.currentPath();
                Path path = cur.resolve(str);
                if (path.isAbsolute()) {
                    return path.toURL();
                }
                str = path.toString();
            }
            return new URL(str);
        }
        catch (Exception ex) {
            throw WrappedException.wrapIfNeeded(ex);
        }
    }

    public static int uriSchemeLength(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char ch = uri.charAt(i);
            if (ch == ':') {
                return i;
            }
            if (!(i == 0 ? !Character.isLetter(ch) : !Character.isLetterOrDigit(ch) && ch != '+' && ch != '-' && ch != '.')) continue;
            return -1;
        }
        return -1;
    }

    public static boolean uriSchemeSpecified(String name) {
        int ulen = Path.uriSchemeLength(name);
        if (ulen == 1 && File.separatorChar == '\\') {
            char drive = name.charAt(0);
            return !(drive >= 'a' && drive <= 'z' || drive >= 'A' && drive <= 'Z');
        }
        return ulen > 0;
    }

    public abstract boolean isAbsolute();

    public boolean isDirectory() {
        char last;
        String str = this.toString();
        int len = str.length();
        return len > 0 && ((last = str.charAt(len - 1)) == '/' || last == File.separatorChar);
    }

    @Override
    public boolean delete() {
        try {
            this.deleteFile();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void deleteFile() throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean exists() {
        return this.getLastModified() != 0L;
    }

    @Override
    public abstract long getLastModified();

    public long getContentLength() {
        return -1L;
    }

    public abstract String getScheme();

    public String getAuthority() {
        return null;
    }

    public String getUserInfo() {
        return null;
    }

    public String getHost() {
        return null;
    }

    public abstract String getPath();

    public Path getDirectory() {
        if (this.isDirectory()) {
            return this;
        }
        return this.resolve("");
    }

    public Path getParent() {
        return this.resolve(this.isDirectory() ? ".." : "");
    }

    public String getLast() {
        int len;
        String p = this.getPath();
        if (p == null) {
            return null;
        }
        int end = len = p.length();
        int i = len;
        while (true) {
            if (--i <= 0) {
                return "";
            }
            char c = p.charAt(i);
            if (c != '/' && (!(this instanceof FilePath) || c != File.separatorChar)) continue;
            if (i + 1 != len) break;
            end = i;
        }
        return p.substring(i + 1, end);
    }

    public String getExtension() {
        boolean sawDot;
        int len;
        String p = this.getPath();
        if (p == null) {
            return null;
        }
        int i = len = p.length();
        do {
            if (--i <= 0) {
                return null;
            }
            char c = p.charAt(i);
            sawDot = false;
            if (c == '.') {
                c = p.charAt(i - 1);
                sawDot = true;
            }
            if (c != '/' && (!(this instanceof FilePath) || c != File.separatorChar)) continue;
            return null;
        } while (!sawDot);
        return p.substring(i + 1);
    }

    public int getPort() {
        return -1;
    }

    public String getQuery() {
        return null;
    }

    public String getFragment() {
        return null;
    }

    public abstract URL toURL();

    @Override
    public abstract URI toUri();

    public final URI toURI() {
        return this.toUri();
    }

    public String toURIString() {
        return this.toUri().toString();
    }

    public Path resolve(Path relative) {
        if (relative.isAbsolute()) {
            return relative;
        }
        return this.resolve(relative.toString());
    }

    public abstract Path resolve(String var1);

    public static InputStream openInputStream(Object uri) throws IOException {
        return Path.valueOf(uri).openInputStream();
    }

    @Override
    public abstract InputStream openInputStream() throws IOException;

    @Override
    public abstract OutputStream openOutputStream() throws IOException;

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Writer openWriter() throws IOException {
        return new OutputStreamWriter(this.openOutputStream());
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        byte[] bytes = this.readAllBytes();
        return new String(bytes, Charset.defaultCharset());
    }

    public byte[] readAllBytes() throws IOException {
        int cnt;
        long len = this.getContentLength();
        if (len > 0x7FFFFFF7L) {
            throw new Error("path contents too big");
        }
        int ilen = (int)len;
        byte[] buffer = new byte[ilen];
        InputStream in = this.openInputStream();
        for (int sofar = 0; sofar < ilen; sofar += cnt) {
            cnt = in.read(buffer, sofar, ilen - sofar);
            if (cnt > 0) continue;
            throw new IOException("unable to read enture file");
        }
        return buffer;
    }

    public static String relativize(String in, String base2) throws URISyntaxException, IOException {
        char ci;
        char cb;
        int i;
        String baseStr = base2;
        String inStr = in;
        baseStr = new URI(baseStr).normalize().toString();
        inStr = URLPath.valueOf(in).toURI().normalize().toString();
        int baseLen = baseStr.length();
        int inLen = inStr.length();
        int sl = 0;
        int colon = 0;
        for (i = 0; i < baseLen && i < inLen && (cb = baseStr.charAt(i)) == (ci = inStr.charAt(i)); ++i) {
            if (cb == '/') {
                sl = i;
            }
            if (cb != ':') continue;
            colon = i;
        }
        if (colon <= 0 || sl <= colon + 2 && baseLen > colon + 2 && baseStr.charAt(colon + 2) == '/') {
            return in;
        }
        baseStr = baseStr.substring(sl + 1);
        inStr = inStr.substring(sl + 1);
        StringBuilder sbuf = new StringBuilder();
        sl = 0;
        i = baseLen = baseStr.length();
        while (--i >= 0) {
            if (baseStr.charAt(i) != '/') continue;
            sbuf.append("../");
        }
        sbuf.append(inStr);
        return sbuf.toString();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    public Path getAbsolute() {
        if (this == userDirPath) {
            return this.resolve("");
        }
        return Path.currentPath().resolve(this);
    }

    public Path getCanonical() {
        return this.getAbsolute();
    }

    public java.nio.file.Path toNPath() throws FileSystemNotFoundException {
        return Paths.get(this.toUri());
    }

    public String probeContentType() {
        String contentType;
        try {
            contentType = Files.probeContentType(this.getAbsolute().toNPath());
        }
        catch (Exception ex) {
            contentType = null;
        }
        if (contentType == null) {
            contentType = URLConnection.guessContentTypeFromName(this.getPath());
        }
        return contentType;
    }

    public static Object[] search(Object[] searchPath, String filename, String base2) {
        for (int i = 0; i < searchPath.length; ++i) {
            Object spath = searchPath[i];
            if (spath == PATH_RELATIVE) {
                String tpath = base2;
                spath = tpath == null || tpath.startsWith("/dev/") ? PATH_CURRENT : tpath;
            }
            Path path = spath == PATH_CURRENT ? Path.currentPath() : Path.valueOf(spath);
            try {
                InputStream istrm = path.resolve(filename).openInputStream();
                return new Object[]{istrm, path};
            }
            catch (Exception exception) {
                continue;
            }
        }
        return null;
    }
}

