/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.hash;

import com.oracle.truffle.api.CompilerDirectives;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jruby.truffle.nodes.core.hash.HashNodes;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.util.cli.Options;

public abstract class PackedArrayStrategy {
    public static final int MAX_ENTRIES = (Integer)Options.TRUFFLE_HASH_PACKED_ARRAY_MAX.load();
    public static final int ELEMENTS_PER_ENTRY = 3;
    public static final int MAX_ELEMENTS = MAX_ENTRIES * 3;

    public static Object[] createStore(int hashed, Object key, Object value) {
        Object[] store = PackedArrayStrategy.createStore();
        PackedArrayStrategy.setHashedKeyValue(store, 0, hashed, key, value);
        return store;
    }

    public static Object[] createStore() {
        return new Object[MAX_ELEMENTS];
    }

    public static Object[] copyStore(Object[] store) {
        Object[] copied = PackedArrayStrategy.createStore();
        System.arraycopy(store, 0, copied, 0, MAX_ELEMENTS);
        return copied;
    }

    public static int getHashed(Object[] store, int n) {
        return (Integer)store[n * 3];
    }

    public static Object getKey(Object[] store, int n) {
        return store[n * 3 + 1];
    }

    public static Object getValue(Object[] store, int n) {
        return store[n * 3 + 2];
    }

    public static void setHashed(Object[] store, int n, int hashed) {
        store[n * 3] = hashed;
    }

    public static void setKey(Object[] store, int n, Object key) {
        store[n * 3 + 1] = key;
    }

    public static void setValue(Object[] store, int n, Object value) {
        store[n * 3 + 2] = value;
    }

    public static void setHashedKeyValue(Object[] store, int n, int hashed, Object key, Object value) {
        PackedArrayStrategy.setHashed(store, n, hashed);
        PackedArrayStrategy.setKey(store, n, key);
        PackedArrayStrategy.setValue(store, n, value);
    }

    public static void removeEntry(Object[] store, int n) {
        for (int i = 0; i < MAX_ELEMENTS; i += 3) {
            assert (store[i] == null || store[i] instanceof Integer);
        }
        int index = n * 3;
        System.arraycopy(store, index + 3, store, index, MAX_ELEMENTS - 3 - index);
        for (int i = 0; i < MAX_ELEMENTS; i += 3) {
            assert (store[i] == null || store[i] instanceof Integer);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void promoteToBuckets(RubyBasicObject hash, Object[] store, int size) {
        Entry[] buckets = new Entry[BucketsStrategy.capacityGreaterThan(size)];
        Entry firstInSequence = null;
        Entry previousInSequence = null;
        Entry lastInSequence = null;
        for (int n = 0; n < size; ++n) {
            int hashed = PackedArrayStrategy.getHashed(store, n);
            Entry entry = new Entry(hashed, PackedArrayStrategy.getKey(store, n), PackedArrayStrategy.getValue(store, n));
            if (previousInSequence == null) {
                firstInSequence = entry;
            } else {
                previousInSequence.setNextInSequence(entry);
                entry.setPreviousInSequence(previousInSequence);
            }
            previousInSequence = entry;
            lastInSequence = entry;
            int bucketIndex = BucketsStrategy.getBucketIndex(hashed, buckets.length);
            Entry previousInLookup = buckets[bucketIndex];
            if (previousInLookup == null) {
                buckets[bucketIndex] = entry;
                continue;
            }
            while (previousInLookup.getNextInLookup() != null) {
                previousInLookup = previousInLookup.getNextInLookup();
            }
            previousInLookup.setNextInLookup(entry);
        }
        HashNodes.setStore(hash, buckets, size, firstInSequence, lastInSequence);
        assert (HashNodes.verifyStore(hash));
    }

    @CompilerDirectives.TruffleBoundary
    public static Iterator<Map.Entry<Object, Object>> iterateKeyValues(final Object[] store, final int size) {
        return new Iterator<Map.Entry<Object, Object>>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < size;
            }

            @Override
            public Map.Entry<Object, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                final int finalIndex = this.index++;
                Map.Entry<Object, Object> entryResult = new Map.Entry<Object, Object>(){

                    @Override
                    public Object getKey() {
                        return PackedArrayStrategy.getKey(store, finalIndex);
                    }

                    @Override
                    public Object getValue() {
                        return PackedArrayStrategy.getValue(store, finalIndex);
                    }

                    @Override
                    public Object setValue(Object value) {
                        throw new UnsupportedOperationException();
                    }
                };
                return entryResult;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

