/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import com.oracle.truffle.api.CompilerDirectives;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jruby.truffle.nodes.core.SymbolNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.util.ByteList;

public class SymbolTable {
    private final RubyContext context;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final WeakHashMap<ByteList, WeakReference<RubyBasicObject>> symbolsTable = new WeakHashMap();

    public SymbolTable(RubyContext context) {
        this.context = context;
    }

    @CompilerDirectives.TruffleBoundary
    public RubyBasicObject getSymbol(String string) {
        return this.getSymbol(ByteList.create((CharSequence)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public RubyBasicObject getSymbol(ByteList bytes) {
        RubyBasicObject symbol;
        WeakReference<RubyBasicObject> symbolReference;
        this.lock.readLock().lock();
        try {
            symbolReference = this.symbolsTable.get(bytes);
            if (symbolReference != null && (symbol = (RubyBasicObject)symbolReference.get()) != null) {
                RubyBasicObject rubyBasicObject = symbol;
                return rubyBasicObject;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        this.lock.writeLock().lock();
        try {
            symbolReference = this.symbolsTable.get(bytes);
            if (symbolReference != null && (symbol = (RubyBasicObject)symbolReference.get()) != null) {
                RubyBasicObject rubyBasicObject = symbol;
                return rubyBasicObject;
            }
            ByteList storedBytes = bytes.dup();
            RubyBasicObject newSymbol = new RubyBasicObject(this.context.getCoreLibrary().getSymbolClass(), SymbolNodes.SYMBOL_FACTORY.newInstance(storedBytes.toString(), storedBytes, storedBytes.toString().hashCode(), 0, null));
            this.symbolsTable.put(storedBytes, new WeakReference<RubyBasicObject>(newSymbol));
            RubyBasicObject rubyBasicObject = newSymbol;
            return rubyBasicObject;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public Collection<RubyBasicObject> allSymbols() {
        Collection<WeakReference<RubyBasicObject>> symbolReferences;
        this.lock.readLock().lock();
        try {
            symbolReferences = this.symbolsTable.values();
        }
        finally {
            this.lock.readLock().unlock();
        }
        ArrayList<RubyBasicObject> symbols = new ArrayList<RubyBasicObject>(symbolReferences.size());
        for (WeakReference<RubyBasicObject> reference : symbolReferences) {
            RubyBasicObject symbol = (RubyBasicObject)reference.get();
            if (symbol == null) continue;
            symbols.add(symbol);
        }
        return symbols;
    }
}

