/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.core;

import org.jcodings.Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;

public class StringCodeRangeableWrapper
implements CodeRangeable {
    private final RubyBasicObject string;

    public StringCodeRangeableWrapper(RubyBasicObject string) {
        assert (RubyGuards.isRubyString(string));
        this.string = string;
    }

    public int getCodeRange() {
        return StringNodes.getCodeRange(this.string);
    }

    public int scanForCodeRange() {
        return StringNodes.scanForCodeRange(this.string);
    }

    public boolean isCodeRangeValid() {
        return StringNodes.isCodeRangeValid(this.string);
    }

    public final void setCodeRange(int newCodeRange) {
        StringNodes.setCodeRange(this.string, newCodeRange);
    }

    public final void clearCodeRange() {
        StringNodes.clearCodeRange(this.string);
    }

    public final void keepCodeRange() {
        StringNodes.keepCodeRange(this.string);
    }

    public final void modify() {
        StringNodes.modify(this.string);
    }

    public final void modify(int length) {
        StringNodes.modify(this.string, length);
    }

    public final void modifyAndKeepCodeRange() {
        StringNodes.modifyAndKeepCodeRange(this.string);
    }

    public Encoding checkEncoding(CodeRangeable other) {
        return StringNodes.checkEncoding(this.string, other);
    }

    public ByteList getByteList() {
        return StringNodes.getByteList(this.string);
    }
}

