/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.methods.MarkerNode;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.methods.InternalMethod;

public final class RubyArguments {
    public static final int METHOD_INDEX = 0;
    public static final int DECLARATION_FRAME_INDEX = 1;
    public static final int SELF_INDEX = 2;
    public static final int BLOCK_INDEX = 3;
    public static final int RUNTIME_ARGUMENT_COUNT = 4;

    public static Object[] pack(InternalMethod method, MaterializedFrame declarationFrame, Object self, RubyBasicObject block, Object[] arguments) {
        assert (block == null || RubyGuards.isRubyProc(block));
        Object[] packed = new Object[arguments.length + 4];
        packed[0] = method;
        packed[1] = declarationFrame;
        packed[2] = self;
        packed[3] = block;
        ArrayUtils.arraycopy(arguments, 0, packed, 4, arguments.length);
        return packed;
    }

    public static Object getOptimizedKeywordArgument(Object[] arguments, int index) {
        return arguments[arguments.length - 1 + index];
    }

    public static boolean isKwOptimized(Object[] arguments) {
        return arguments[arguments.length - 1] instanceof MarkerNode.Marker;
    }

    public static InternalMethod getMethod(Object[] arguments) {
        return (InternalMethod)arguments[0];
    }

    public static Object getSelf(Object[] arguments) {
        return arguments[2];
    }

    public static RubyBasicObject getBlock(Object[] arguments) {
        return (RubyBasicObject)arguments[3];
    }

    public static Object[] extractUserArguments(Object[] arguments) {
        return ArrayUtils.extractRange(arguments, 4, arguments.length);
    }

    public static Object[] extractUserArgumentsWithUnshift(Object first, Object[] arguments) {
        Object[] range = ArrayUtils.extractRange(arguments, 3, arguments.length);
        range[0] = first;
        return range;
    }

    public static int getUserArgumentsCount(Object[] internalArguments) {
        return internalArguments.length - 4;
    }

    public static int getNamedUserArgumentsCount(Object[] internalArguments) {
        if (RubyArguments.isKwOptimized(internalArguments)) {
            return RubyArguments.getUserArgumentsCount(internalArguments) - RubyArguments.getMethod(internalArguments).getSharedMethodInfo().getArity().getKeywordArguments().size() - 1;
        }
        return RubyArguments.getUserArgumentsCount(internalArguments);
    }

    public static Object getUserArgument(Object[] internalArguments, int index) {
        return internalArguments[4 + index];
    }

    public static void setUserArgument(Object[] internalArguments, int index, Object value) {
        internalArguments[4 + index] = value;
    }

    public static RubyBasicObject getUserKeywordsHash(Object[] internalArguments, int minArgumentCount) {
        int argumentCount = RubyArguments.getUserArgumentsCount(internalArguments);
        if (argumentCount <= minArgumentCount) {
            return null;
        }
        Object lastArgument = RubyArguments.getUserArgument(internalArguments, argumentCount - 1);
        if (RubyGuards.isRubyHash(lastArgument)) {
            return (RubyBasicObject)lastArgument;
        }
        return null;
    }

    public static MaterializedFrame getDeclarationFrame(Object[] arguments) {
        return (MaterializedFrame)arguments[1];
    }

    public static MaterializedFrame getDeclarationFrame(VirtualFrame frame, int level) {
        assert (level > 0);
        MaterializedFrame parentFrame = RubyArguments.getDeclarationFrame(frame.getArguments());
        return RubyArguments.getDeclarationFrame(parentFrame, level - 1);
    }

    @ExplodeLoop
    private static MaterializedFrame getDeclarationFrame(MaterializedFrame frame, int level) {
        assert (frame != null);
        assert (level >= 0);
        MaterializedFrame parentFrame = frame;
        for (int n = 0; n < level; ++n) {
            parentFrame = RubyArguments.getDeclarationFrame(parentFrame.getArguments());
        }
        return parentFrame;
    }
}

