/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.parser;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.pack.nodes.PackRootNode;
import org.jruby.truffle.pack.nodes.SourceNode;
import org.jruby.truffle.pack.nodes.control.AtNode;
import org.jruby.truffle.pack.nodes.control.BackNode;
import org.jruby.truffle.pack.nodes.control.NNode;
import org.jruby.truffle.pack.nodes.control.SequenceNode;
import org.jruby.truffle.pack.nodes.control.StarNode;
import org.jruby.truffle.pack.nodes.read.ReadDoubleNodeGen;
import org.jruby.truffle.pack.nodes.read.ReadLongOrBigIntegerNodeGen;
import org.jruby.truffle.pack.nodes.read.ReadStringNodeGen;
import org.jruby.truffle.pack.nodes.read.ReadValueNodeGen;
import org.jruby.truffle.pack.nodes.type.AsSinglePrecisionNodeGen;
import org.jruby.truffle.pack.nodes.type.ReinterpretLongNodeGen;
import org.jruby.truffle.pack.nodes.type.ToLongNode;
import org.jruby.truffle.pack.nodes.type.ToLongNodeGen;
import org.jruby.truffle.pack.nodes.write.PNode;
import org.jruby.truffle.pack.nodes.write.Write16BigNodeGen;
import org.jruby.truffle.pack.nodes.write.Write16LittleNodeGen;
import org.jruby.truffle.pack.nodes.write.Write32BigNodeGen;
import org.jruby.truffle.pack.nodes.write.Write32LittleNodeGen;
import org.jruby.truffle.pack.nodes.write.Write64BigNodeGen;
import org.jruby.truffle.pack.nodes.write.Write64LittleNodeGen;
import org.jruby.truffle.pack.nodes.write.Write8NodeGen;
import org.jruby.truffle.pack.nodes.write.WriteBERNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteBase64StringNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteBinaryStringNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteBitStringNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteByteNode;
import org.jruby.truffle.pack.nodes.write.WriteHexStringNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteMIMEStringNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteUTF8CharacterNodeGen;
import org.jruby.truffle.pack.nodes.write.WriteUUStringNodeGen;
import org.jruby.truffle.pack.parser.PackTokenizer;
import org.jruby.truffle.pack.runtime.Endianness;
import org.jruby.truffle.pack.runtime.PackEncoding;
import org.jruby.truffle.pack.runtime.Signedness;
import org.jruby.truffle.pack.runtime.exceptions.FormatException;
import org.jruby.truffle.runtime.RubyContext;

public class PackParser {
    private final RubyContext context;
    private PackEncoding encoding = PackEncoding.DEFAULT;

    public PackParser(RubyContext context) {
        this.context = context;
    }

    public CallTarget parse(String format, boolean extended) {
        if (format.length() > 32) {
            format = this.recoverLoop(format);
            extended = true;
        }
        PackTokenizer tokenizer = new PackTokenizer(format, extended);
        PackNode body = this.parse(tokenizer, false);
        return Truffle.getRuntime().createCallTarget(new PackRootNode(PackParser.describe(format), this.encoding, body));
    }

    public PackNode parse(PackTokenizer tokenizer, boolean inParens) {
        Object token;
        ArrayList<PackNode> sequenceChildren = new ArrayList<PackNode>();
        block59: while ((token = tokenizer.next()) != null) {
            PackNode node;
            if (token instanceof Character) {
                block0 : switch (((Character)token).charValue()) {
                    case '(': {
                        node = this.parse(tokenizer, true);
                        break;
                    }
                    case ')': {
                        if (inParens) break block59;
                        throw new UnsupportedOperationException("unbalanced parens");
                    }
                    case 'C': 
                    case 'c': {
                        node = this.writeInteger(8, PackParser.nativeEndianness());
                        break;
                    }
                    case 'I': 
                    case 'L': 
                    case 'Q': 
                    case 'S': 
                    case 'i': 
                    case 'l': 
                    case 'q': 
                    case 's': {
                        int size = 0;
                        Signedness signedness = null;
                        Endianness endianness = PackParser.nativeEndianness();
                        switch (((Character)token).charValue()) {
                            case 'S': {
                                size = 16;
                                signedness = Signedness.UNSIGNED;
                                break;
                            }
                            case 'I': 
                            case 'L': {
                                size = 32;
                                signedness = Signedness.UNSIGNED;
                                break;
                            }
                            case 'Q': {
                                size = 64;
                                signedness = Signedness.UNSIGNED;
                                break;
                            }
                            case 's': {
                                size = 16;
                                signedness = Signedness.SIGNED;
                                break;
                            }
                            case 'i': 
                            case 'l': {
                                size = 32;
                                signedness = Signedness.SIGNED;
                                break;
                            }
                            case 'q': {
                                size = 64;
                                signedness = Signedness.SIGNED;
                                break;
                            }
                        }
                        if (tokenizer.peek('_') || tokenizer.peek('!')) {
                            switch (((Character)token).charValue()) {
                                case 'S': 
                                case 's': {
                                    size = 16;
                                    break;
                                }
                                case 'I': 
                                case 'i': {
                                    size = 32;
                                    break;
                                }
                                case 'L': 
                                case 'l': {
                                    size = 64;
                                    break;
                                }
                                default: {
                                    throw new UnsupportedOperationException();
                                }
                            }
                            tokenizer.next();
                        }
                        if (tokenizer.peek('<')) {
                            endianness = Endianness.LITTLE;
                            tokenizer.next();
                        } else if (tokenizer.peek('>')) {
                            endianness = Endianness.BIG;
                            tokenizer.next();
                        }
                        node = this.writeInteger(size, endianness);
                        break;
                    }
                    case 'n': {
                        node = this.writeInteger(16, Endianness.BIG);
                        break;
                    }
                    case 'N': {
                        node = this.writeInteger(32, Endianness.BIG);
                        break;
                    }
                    case 'v': {
                        node = this.writeInteger(16, Endianness.LITTLE);
                        break;
                    }
                    case 'V': {
                        node = this.writeInteger(32, Endianness.LITTLE);
                        break;
                    }
                    case 'A': 
                    case 'Z': 
                    case 'a': {
                        boolean appendNull;
                        boolean takeAll;
                        int width;
                        boolean pad;
                        byte padding;
                        this.encoding = this.encoding.unifyWith(PackEncoding.ASCII_8BIT);
                        boolean padOnNull = true;
                        switch (((Character)token).charValue()) {
                            case 'A': {
                                padding = 32;
                                break;
                            }
                            case 'Z': 
                            case 'a': {
                                padding = 0;
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException();
                            }
                        }
                        if (tokenizer.peek() instanceof Integer) {
                            pad = true;
                            width = (Integer)tokenizer.next();
                        } else {
                            pad = false;
                            width = 1;
                        }
                        if (tokenizer.peek('*')) {
                            tokenizer.next();
                            takeAll = true;
                            appendNull = ((Character)token).charValue() == 'Z';
                            switch (((Character)token).charValue()) {
                                case 'A': 
                                case 'a': {
                                    padOnNull = false;
                                    break;
                                }
                            }
                        } else {
                            takeAll = false;
                            appendNull = false;
                        }
                        node = WriteBinaryStringNodeGen.create(this.context, pad, padOnNull, width, padding, takeAll, appendNull, ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode()));
                        break;
                    }
                    case 'H': 
                    case 'h': {
                        Endianness endianness;
                        switch (((Character)token).charValue()) {
                            case 'H': {
                                endianness = Endianness.BIG;
                                break;
                            }
                            case 'h': {
                                endianness = Endianness.LITTLE;
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException();
                            }
                        }
                        int length = tokenizer.peek('*') ? -1 : (tokenizer.peek() instanceof Integer ? (Integer)tokenizer.next() : 1);
                        node = WriteHexStringNodeGen.create(this.context, endianness, length, ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode()));
                        break;
                    }
                    case 'B': 
                    case 'b': {
                        int length;
                        boolean star;
                        Endianness endianness;
                        switch (((Character)token).charValue()) {
                            case 'B': {
                                endianness = Endianness.BIG;
                                break;
                            }
                            case 'b': {
                                endianness = Endianness.LITTLE;
                                break;
                            }
                            default: {
                                throw new UnsupportedOperationException();
                            }
                        }
                        if (tokenizer.peek() instanceof Integer) {
                            star = false;
                            length = (Integer)tokenizer.next();
                        } else if (tokenizer.peek('*')) {
                            star = true;
                            length = 0;
                            tokenizer.next();
                        } else {
                            star = false;
                            length = 1;
                        }
                        node = WriteBitStringNodeGen.create(this.context, endianness, star, length, ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode()));
                        break;
                    }
                    case 'M': {
                        int length;
                        this.encoding = this.encoding.unifyWith(PackEncoding.US_ASCII);
                        if (tokenizer.peek() instanceof Integer) {
                            length = (Integer)tokenizer.next();
                            if (length <= 1) {
                                length = 72;
                            }
                        } else {
                            length = 72;
                        }
                        node = WriteMIMEStringNodeGen.create(this.context, length, ReadStringNodeGen.create(this.context, true, "to_s", true, this.context.getCoreLibrary().getNilObject(), new SourceNode()));
                        break;
                    }
                    case 'm': 
                    case 'u': {
                        this.encoding = this.encoding.unifyWith(PackEncoding.US_ASCII);
                        int length = 1;
                        boolean ignoreStar = false;
                        if (tokenizer.peek() instanceof Integer) {
                            length = (Integer)tokenizer.next();
                        } else if (tokenizer.peek('*')) {
                            tokenizer.next();
                            length = 0;
                            ignoreStar = true;
                        }
                        switch (((Character)token).charValue()) {
                            case 'm': {
                                node = WriteBase64StringNodeGen.create(this.context, length, ignoreStar, ReadStringNodeGen.create(this.context, false, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode()));
                                break block0;
                            }
                            case 'u': {
                                node = WriteUUStringNodeGen.create(this.context, length, ignoreStar, ReadStringNodeGen.create(this.context, false, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode()));
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException();
                    }
                    case 'U': {
                        this.encoding = this.encoding.unifyWith(PackEncoding.UTF_8);
                        node = WriteUTF8CharacterNodeGen.create(this.context, ToLongNodeGen.create(this.context, ReadValueNodeGen.create(this.context, new SourceNode())));
                        break;
                    }
                    case 'X': {
                        node = new BackNode(this.context);
                        break;
                    }
                    case 'x': {
                        node = new WriteByteNode(this.context, 0);
                        break;
                    }
                    case '@': {
                        int position = tokenizer.peek() instanceof Integer ? (Integer)tokenizer.next() : 1;
                        node = new AtNode(this.context, position);
                        break;
                    }
                    case 'D': 
                    case 'd': {
                        node = this.writeInteger(64, PackParser.nativeEndianness(), ReinterpretLongNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode())));
                        break;
                    }
                    case 'F': 
                    case 'f': {
                        node = this.writeInteger(32, PackParser.nativeEndianness(), ReinterpretLongNodeGen.create(this.context, AsSinglePrecisionNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode()))));
                        break;
                    }
                    case 'E': {
                        node = this.writeInteger(64, Endianness.LITTLE, ReinterpretLongNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode())));
                        break;
                    }
                    case 'e': {
                        node = this.writeInteger(32, Endianness.LITTLE, ReinterpretLongNodeGen.create(this.context, AsSinglePrecisionNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode()))));
                        break;
                    }
                    case 'G': {
                        node = this.writeInteger(64, Endianness.BIG, ReinterpretLongNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode())));
                        break;
                    }
                    case 'g': {
                        node = this.writeInteger(32, Endianness.BIG, ReinterpretLongNodeGen.create(this.context, AsSinglePrecisionNodeGen.create(this.context, ReadDoubleNodeGen.create(this.context, new SourceNode()))));
                        break;
                    }
                    case 'P': 
                    case 'p': {
                        node = this.writeInteger(64, PackParser.nativeEndianness(), new PNode(this.context));
                        break;
                    }
                    case 'w': {
                        node = WriteBERNodeGen.create(this.context, ReadLongOrBigIntegerNodeGen.create(this.context, new SourceNode()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("unexpected token %s", token));
                    }
                }
                if (tokenizer.peek('_') || tokenizer.peek('!')) {
                    throw new FormatException("'" + tokenizer.next() + "' allowed only after types sSiIlLqQ");
                }
            } else {
                throw new UnsupportedOperationException(String.format("unexpected token %s", token));
            }
            if (tokenizer.peek('*')) {
                tokenizer.next();
                if (node instanceof BackNode) continue;
                node = new StarNode(this.context, node);
            }
            if (tokenizer.peek() instanceof Integer) {
                node = new NNode(this.context, (Integer)tokenizer.next(), node);
            }
            sequenceChildren.add(node);
        }
        return new SequenceNode(this.context, sequenceChildren.toArray(new PackNode[sequenceChildren.size()]));
    }

    private String recoverLoop(String format) {
        int break_point = 0;
        while (break_point < format.length()) {
            if ("0123456789*".indexOf(format.charAt(break_point)) != -1) {
                ++break_point;
                continue;
            }
            int max_repeated_length = -1;
            for (int repeated_length = 1; repeated_length <= break_point && break_point + repeated_length <= format.length(); ++repeated_length) {
                if (!format.substring(break_point - repeated_length, break_point).equals(format.substring(break_point, break_point + repeated_length))) continue;
                max_repeated_length = repeated_length;
            }
            if (max_repeated_length == -1) {
                ++break_point;
                continue;
            }
            String repeated = format.substring(break_point, break_point + max_repeated_length);
            int count = 2;
            int rep_point = break_point + max_repeated_length;
            while (rep_point + max_repeated_length <= format.length() && format.substring(rep_point, rep_point + max_repeated_length).equals(repeated)) {
                ++count;
                rep_point += max_repeated_length;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(format.substring(0, break_point - max_repeated_length));
            builder.append('(');
            builder.append(repeated);
            builder.append(')');
            builder.append(count);
            builder.append(format.substring(rep_point));
            format = builder.toString();
        }
        return format;
    }

    public static String describe(String format) {
        if ((format = format.replace("\\s+", "")).length() > 10) {
            format = format.substring(0, 10) + "\u2026";
        }
        return format;
    }

    private static Endianness nativeEndianness() {
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            return Endianness.BIG;
        }
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            return Endianness.LITTLE;
        }
        throw new UnsupportedOperationException(String.format("unknown byte order %s", ByteOrder.nativeOrder()));
    }

    private PackNode writeInteger(int size, Endianness endianness) {
        ToLongNode readNode = ToLongNodeGen.create(this.context, ReadValueNodeGen.create(this.context, new SourceNode()));
        return this.writeInteger(size, endianness, readNode);
    }

    private PackNode writeInteger(int size, Endianness endianness, PackNode readNode) {
        switch (size) {
            case 8: {
                return Write8NodeGen.create(this.context, readNode);
            }
            case 16: {
                switch (endianness) {
                    case LITTLE: {
                        return Write16LittleNodeGen.create(this.context, readNode);
                    }
                    case BIG: {
                        return Write16BigNodeGen.create(this.context, readNode);
                    }
                }
            }
            case 32: {
                switch (endianness) {
                    case LITTLE: {
                        return Write32LittleNodeGen.create(this.context, readNode);
                    }
                    case BIG: {
                        return Write32BigNodeGen.create(this.context, readNode);
                    }
                }
            }
            case 64: {
                switch (endianness) {
                    case LITTLE: {
                        return Write64LittleNodeGen.create(this.context, readNode);
                    }
                    case BIG: {
                        return Write64BigNodeGen.create(this.context, readNode);
                    }
                }
            }
        }
        throw new UnsupportedOperationException();
    }
}

