/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.parser;

import org.jruby.truffle.pack.parser.FormatDirective;
import org.jruby.util.ByteList;

public class FormatTokenizer {
    private static final String TYPE_CHARS = "%-sdiuxXfgGeE";
    private final ByteList format;
    private int position;
    private Object peek;

    public FormatTokenizer(ByteList format) {
        this.format = format;
    }

    public Object peek() {
        if (this.peek == null) {
            this.peek = this.next();
        }
        return this.peek;
    }

    public Object next() {
        char type;
        int precision;
        int zeroPadding;
        int spacePadding;
        if (this.peek != null) {
            Object token = this.peek;
            this.peek = null;
            return token;
        }
        if (this.position >= this.format.length()) {
            return null;
        }
        char c = this.format.charAt(this.position);
        if (c != '%') {
            int stringStart = this.position++;
            while (this.position < this.format.length() && this.format.charAt(this.position) != '%') {
                ++this.position;
            }
            return this.format.subSequence(stringStart, this.position);
        }
        ++this.position;
        boolean leftJustified = false;
        if (this.format.charAt(this.position) == '-') {
            leftJustified = true;
            ++this.position;
        }
        if (this.format.charAt(this.position) == ' ') {
            ++this.position;
            spacePadding = this.readInt();
            zeroPadding = -1;
        } else if (this.format.charAt(this.position) == '0') {
            spacePadding = -1;
            zeroPadding = this.readInt();
        } else if (Character.isDigit(this.format.charAt(this.position))) {
            spacePadding = this.readInt();
            zeroPadding = -1;
        } else {
            spacePadding = -1;
            if (this.format.charAt(this.position) == '0') {
                ++this.position;
                zeroPadding = this.readInt();
            } else {
                zeroPadding = -1;
            }
        }
        if (this.format.charAt(this.position) == '.') {
            ++this.position;
            precision = this.readInt();
        } else {
            precision = -1;
        }
        if (Character.isDigit(this.format.charAt(this.position))) {
            spacePadding = this.readInt();
        }
        if (TYPE_CHARS.indexOf(type = this.format.charAt(this.position)) == -1) {
            throw new UnsupportedOperationException("Unknown format type '" + this.format.charAt(this.position) + "'");
        }
        ++this.position;
        return new FormatDirective(spacePadding, zeroPadding, leftJustified, precision, type);
    }

    private int readInt() {
        int start = this.position;
        while (Character.isDigit(this.format.charAt(this.position))) {
            ++this.position;
        }
        return Integer.parseInt(this.format.subSequence(start, this.position).toString());
    }
}

