/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.pack.nodes.write;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.math.BigInteger;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.pack.nodes.PackGuards;
import org.jruby.truffle.pack.nodes.PackNode;
import org.jruby.truffle.pack.runtime.exceptions.CantCompressNegativeException;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.util.ByteList;

@NodeChildren(value={@NodeChild(value="value", type=PackNode.class)})
public abstract class WriteBERNode
extends PackNode {
    public WriteBERNode(RubyContext context) {
        super(context);
    }

    @Specialization
    public Object doWrite(VirtualFrame frame, int value) {
        if (value < 0) {
            CompilerDirectives.transferToInterpreter();
            throw new CantCompressNegativeException();
        }
        this.writeBytes(frame, this.encode(value));
        return null;
    }

    @Specialization
    public Object doWrite(VirtualFrame frame, long value) {
        if (value < 0L) {
            CompilerDirectives.transferToInterpreter();
            throw new CantCompressNegativeException();
        }
        this.writeBytes(frame, this.encode(value));
        return null;
    }

    @Specialization(guards={"isRubyBignum(value)"})
    public Object doWrite(VirtualFrame frame, RubyBasicObject value) {
        if (BignumNodes.getBigIntegerValue(value).signum() < 0) {
            CompilerDirectives.transferToInterpreter();
            throw new CantCompressNegativeException();
        }
        this.writeBytes(frame, this.encode(value));
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private ByteList encode(Object from) {
        long l;
        ByteList buf;
        block11: {
            buf = new ByteList();
            if (PackGuards.isRubyBignum(from)) {
                BigInteger big128 = BigInteger.valueOf(128L);
                from = BignumNodes.getBigIntegerValue((RubyBasicObject)from);
                while (true) {
                    BigInteger bignum = (BigInteger)from;
                    BigInteger[] ary = bignum.divideAndRemainder(big128);
                    buf.append((byte)(ary[1].longValue() | 0x80L) & 0xFF);
                    if (ary[0].compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
                        l = ary[0].longValue();
                        break block11;
                    }
                    from = ary[0];
                }
            }
            if (from instanceof Integer) {
                l = ((Integer)from).intValue();
            } else if (from instanceof Long) {
                l = (Long)from;
            } else {
                throw new UnsupportedOperationException();
            }
        }
        while (l != 0L) {
            buf.append((byte)((l & 0x7FL | 0x80L) & 0xFFL));
            l >>= 7;
        }
        int left = 0;
        int right = buf.getRealSize() - 1;
        if (right >= 0) {
            byte[] byArray = buf.getUnsafeBytes();
            byArray[0] = (byte)(byArray[0] & 0x7F);
        } else {
            buf.append(0);
        }
        while (left < right) {
            byte tmp = buf.getUnsafeBytes()[left];
            buf.getUnsafeBytes()[left] = buf.getUnsafeBytes()[right];
            buf.getUnsafeBytes()[right] = tmp;
            ++left;
            --right;
        }
        return buf;
    }
}

