/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.ArrayList;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInteger;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.core.EncodingNodes;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.util.ByteList;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertBytes;
import org.jruby.util.StringSupport;

public abstract class StringPrimitiveNodes {

    @RubiniusPrimitive(name="string_from_bytearray", needsSelf=false, lowerFixnumParameters={1, 2})
    public static abstract class StringFromByteArrayPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringFromByteArrayPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubiniusByteArray(bytes)"})
        public RubyBasicObject stringFromByteArray(RubyBasicObject bytes, int start, int count) {
            ByteList byteList = ByteArrayNodes.getBytes(bytes);
            return this.createString(new ByteList(byteList, start, count));
        }
    }

    @RubiniusPrimitive(name="string_substring")
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract Object execute(VirtualFrame var1, RubyBasicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public Object stringSubstringSingleByteOptimizable(RubyBasicObject string, int beg, int len) {
            if (len < 0) {
                return this.nil();
            }
            int length = StringNodes.getByteList(string).getRealSize();
            if (length == 0) {
                len = 0;
            }
            if (beg > length) {
                return this.nil();
            }
            if (beg < 0 && (beg += length) < 0) {
                return this.nil();
            }
            if (beg + len > length) {
                len = length - beg;
            }
            if (len <= 0) {
                len = 0;
                beg = 0;
            }
            return this.makeSubstring(string, beg, len);
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public Object stringSubstring(RubyBasicObject string, int beg, int len) {
            int p;
            if (len < 0) {
                return this.nil();
            }
            int length = StringNodes.getByteList(string).getRealSize();
            if (length == 0) {
                len = 0;
            }
            if (beg + len > length) {
                len = length - beg;
            }
            ByteList value = StringNodes.getByteList(string);
            Encoding enc = value.getEncoding();
            int s = value.getBegin();
            int end = s + length;
            byte[] bytes = value.getUnsafeBytes();
            if (beg < 0) {
                if (len > -beg) {
                    len = -beg;
                }
                if (-beg * enc.maxLength() < length >>> 3) {
                    beg = -beg;
                    int e = end;
                    while (beg-- > len && (e = enc.prevCharHead(bytes, s, e, e)) != -1) {
                    }
                    int p2 = e;
                    if (p2 == -1) {
                        return this.nil();
                    }
                    while (len-- > 0 && (p2 = enc.prevCharHead(bytes, s, p2, e)) != -1) {
                    }
                    if (p2 == -1) {
                        return this.nil();
                    }
                    return this.makeSubstring(string, p2 - s, e - p2);
                }
                if ((beg += StringSupport.strLengthFromRubyString((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)enc)) < 0) {
                    return this.nil();
                }
            } else if (beg > 0 && beg > StringSupport.strLengthFromRubyString((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)enc)) {
                return this.nil();
            }
            if (len == 0) {
                p = 0;
            } else if (StringNodes.isCodeRangeValid(string) && enc instanceof UTF8Encoding) {
                p = StringSupport.utf8Nth((byte[])bytes, (int)s, (int)end, (int)beg);
                len = StringSupport.utf8Offset((byte[])bytes, (int)p, (int)end, (int)len);
            } else if (enc.isFixedWidth()) {
                int w = enc.maxLength();
                p = s + beg * w;
                if (p > end) {
                    p = end;
                    len = 0;
                } else {
                    len = len * w > end - p ? end - p : (len *= w);
                }
            } else {
                p = StringSupport.nth((Encoding)enc, (byte[])bytes, (int)s, (int)end, (int)beg);
                len = p == end ? 0 : StringSupport.offset((Encoding)enc, (byte[])bytes, (int)p, (int)end, (int)len);
            }
            return this.makeSubstring(string, p - s, len);
        }

        private RubyBasicObject makeSubstring(RubyBasicObject string, int beg, int len) {
            assert (RubyGuards.isRubyString(string));
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            RubyBasicObject ret = StringNodes.createString(string.getLogicalClass(), new ByteList(StringNodes.getByteList(string), beg, len));
            StringNodes.getByteList(ret).setEncoding(StringNodes.getByteList(string).getEncoding());
            this.taintResultNode.maybeTaint(string, ret);
            return ret;
        }
    }

    @RubiniusPrimitive(name="string_byte_append")
    public static abstract class StringByteAppendPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringByteAppendPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(other)"})
        public RubyBasicObject stringByteAppend(RubyBasicObject string, RubyBasicObject other) {
            StringNodes.getByteList(string).append(StringNodes.getByteList(other));
            return string;
        }
    }

    @RubiniusPrimitive(name="string_to_inum")
    public static abstract class StringToInumPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringToInumPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringToInum(RubyBasicObject string, int fixBase, boolean strict) {
            try {
                RubyInteger result = ConvertBytes.byteListToInum19((Ruby)this.getContext().getRuntime(), (ByteList)StringNodes.getByteList(string), (int)fixBase, (boolean)strict);
                return this.getContext().toTruffle((IRubyObject)result);
            }
            catch (RaiseException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().toTruffle(e.getException(), this));
            }
        }
    }

    @RubiniusPrimitive(name="string_pattern", lowerFixnumParameters={0, 1})
    public static abstract class StringPatternPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringPatternPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"value == 0"})
        public RubyBasicObject stringPatternZero(RubyClass stringClass, int size, int value) {
            return StringNodes.createString(stringClass, new ByteList(new byte[size]));
        }

        @Specialization(guards={"value != 0"})
        public RubyBasicObject stringPattern(RubyClass stringClass, int size, int value) {
            byte[] bytes = new byte[size];
            Arrays.fill(bytes, (byte)value);
            return StringNodes.createString(stringClass, new ByteList(bytes));
        }

        @Specialization(guards={"isRubyString(string)"})
        public RubyBasicObject stringPattern(RubyClass stringClass, int size, RubyBasicObject string) {
            byte[] bytes = new byte[size];
            ByteList byteList = StringNodes.getByteList(string);
            if (byteList.length() > 0) {
                for (int n = 0; n < size; n += byteList.length()) {
                    System.arraycopy(byteList.unsafeBytes(), byteList.begin(), bytes, n, Math.min(byteList.length(), size - n));
                }
            }
            return StringNodes.createString(stringClass, new ByteList(bytes));
        }
    }

    @RubiniusPrimitive(name="string_rindex", lowerFixnumParameters={1})
    public static abstract class StringRindexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringRindexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringRindex(RubyBasicObject string, RubyBasicObject pattern, int start) {
            int pos = start;
            if (pos < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative start given", this));
            }
            ByteList buf = StringNodes.getByteList(string);
            int total = buf.getRealSize();
            int matchSize = StringNodes.getByteList(pattern).getRealSize();
            if (pos >= total) {
                pos = total - 1;
            }
            switch (matchSize) {
                case 0: {
                    return start;
                }
                case 1: {
                    int matcher = StringNodes.getByteList(pattern).get(0);
                    while (pos >= 0) {
                        if (buf.get(pos) == matcher) {
                            return pos;
                        }
                        --pos;
                    }
                    return this.nil();
                }
            }
            if (total - pos < matchSize) {
                pos = total - matchSize;
            }
            for (int cur = pos; cur >= 0; --cur) {
                if (ByteList.memcmp((byte[])StringNodes.getByteList(string).getUnsafeBytes(), (int)cur, (byte[])StringNodes.getByteList(pattern).getUnsafeBytes(), (int)0, (int)matchSize) != 0) continue;
                return cur;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_resize_capacity", needsSelf=false, lowerFixnumParameters={1})
    public static abstract class StringResizeCapacityPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringResizeCapacityPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject stringResizeCapacity(RubyBasicObject string, int capacity) {
            StringNodes.getByteList(string).ensure(capacity);
            return string;
        }
    }

    @RubiniusPrimitive(name="string_copy_from", needsSelf=false, lowerFixnumParameters={2, 3, 4})
    public static abstract class StringCopyFromPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringCopyFromPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(other)"})
        public RubyBasicObject stringCopyFrom(RubyBasicObject string, RubyBasicObject other, int start, int size, int dest) {
            ByteList stringBytes;
            int sz;
            int src = start;
            int dst = dest;
            int cnt = size;
            ByteList otherBytes = StringNodes.getByteList(other);
            int osz = otherBytes.length();
            if (src >= osz) {
                return string;
            }
            if (cnt < 0) {
                return string;
            }
            if (src < 0) {
                src = 0;
            }
            if (cnt > osz - src) {
                cnt = osz - src;
            }
            if (dst >= (sz = (stringBytes = StringNodes.getByteList(string)).unsafeBytes().length - stringBytes.begin())) {
                return string;
            }
            if (dst < 0) {
                dst = 0;
            }
            if (cnt > sz - dst) {
                cnt = sz - dst;
            }
            System.arraycopy(otherBytes.unsafeBytes(), otherBytes.begin() + src, stringBytes.getUnsafeBytes(), stringBytes.begin() + dest, cnt);
            return string;
        }
    }

    @RubiniusPrimitive(name="string_previous_byte_index")
    public static abstract class StringPreviousByteIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringPreviousByteIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object stringPreviousByteIndex(RubyBasicObject string, int index) {
            if (index < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative index given", this));
            }
            ByteList bytes = StringNodes.getByteList(string);
            int p = bytes.getBegin();
            int end = p + bytes.getRealSize();
            int b = bytes.getEncoding().prevCharHead(bytes.getUnsafeBytes(), p, p + index, end);
            if (b == -1) {
                return this.nil();
            }
            return b - p;
        }
    }

    @RubiniusPrimitive(name="string_byte_index", needsSelf=false, lowerFixnumParameters={1, 2})
    public static abstract class StringByteIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringByteIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object stringByteIndex(RubyBasicObject string, int index, int start) {
            int i;
            ByteList bytes = StringNodes.getByteList(string);
            Encoding enc = bytes.getEncoding();
            int p = bytes.getBegin();
            int e = p + bytes.getRealSize();
            int k = index;
            if (k < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("character index is negative", this));
            }
            for (i = 0; i < k && p < e; ++i) {
                int c = StringSupport.preciseLength((Encoding)enc, (byte[])bytes.getUnsafeBytes(), (int)p, (int)e);
                if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    ++p;
                    continue;
                }
                p += StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            }
            if (i < k) {
                return this.nil();
            }
            return p;
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringByteIndex(RubyBasicObject string, RubyBasicObject pattern, int offset) {
            int match_size = StringNodes.getByteList(pattern).length();
            if (offset < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative start given", this));
            }
            if (match_size == 0) {
                return offset;
            }
            if (StringNodes.scanForCodeRange(string) == 48) {
                return this.nil();
            }
            Encoding encoding = StringNodes.checkEncoding(string, StringNodes.getCodeRangeable(pattern), this);
            int p = StringNodes.getByteList(string).getBegin();
            int e = p + StringNodes.getByteList(string).getRealSize();
            int pp = StringNodes.getByteList(pattern).getBegin();
            int pe = pp + StringNodes.getByteList(pattern).getRealSize();
            byte[] stringBytes = StringNodes.getByteList(string).getUnsafeBytes();
            byte[] patternBytes = StringNodes.getByteList(pattern).getUnsafeBytes();
            int s = p;
            int ss = pp;
            while (p < e) {
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                        ++p;
                        ++pp;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        int c = StringSupport.preciseLength((Encoding)encoding, (byte[])stringBytes, (int)s, (int)e);
                        if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                            return s;
                        }
                        return this.nil();
                    }
                }
                s = ++p;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_character_index", needsSelf=false, lowerFixnumParameters={2})
    public static abstract class StringCharacterIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringCharacterIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringCharacterIndex(RubyBasicObject string, RubyBasicObject pattern, int offset) {
            int index;
            int c;
            if (offset < 0) {
                return this.nil();
            }
            int total = StringNodes.getByteList(string).length();
            int p = StringNodes.getByteList(string).getBegin();
            int e = p + total;
            int pp = StringNodes.getByteList(pattern).getBegin();
            int pe = pp + StringNodes.getByteList(pattern).length();
            byte[] stringBytes = StringNodes.getByteList(string).getUnsafeBytes();
            byte[] patternBytes = StringNodes.getByteList(pattern).getUnsafeBytes();
            if (StringSupport.isSingleByteOptimizable((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)StringNodes.getByteList(string).getEncoding())) {
                int s = p += offset;
                int ss = pp;
                while (p < e) {
                    if (stringBytes[p] == patternBytes[pp]) {
                        while (p < e && pp < pe && stringBytes[p] == patternBytes[pp]) {
                            ++p;
                            ++pp;
                        }
                        if (pp < pe) {
                            p = s;
                            pp = ss;
                        } else {
                            return s;
                        }
                    }
                    s = ++p;
                }
                return this.nil();
            }
            Encoding enc = StringNodes.getByteList(string).getEncoding();
            for (index = 0; p < e && index < offset; p += c, ++index) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    continue;
                }
                return this.nil();
            }
            int s = p;
            int ss = pp;
            while (p < e) {
                c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e);
                if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                    return this.nil();
                }
                if (stringBytes[p] == patternBytes[pp]) {
                    while (p < e && pp < pe) {
                        boolean breakOut = false;
                        int pc = p + c;
                        while (p < e && p < pc && pp < pe) {
                            if (stringBytes[p] == patternBytes[pp]) {
                                ++p;
                                ++pp;
                                continue;
                            }
                            breakOut = true;
                            break;
                        }
                        if (!breakOut && StringSupport.MBCLEN_CHARFOUND_P((int)(c = StringSupport.preciseLength((Encoding)enc, (byte[])stringBytes, (int)p, (int)e)))) continue;
                        break;
                    }
                    if (pp < pe) {
                        p = s;
                        pp = ss;
                    } else {
                        return index;
                    }
                }
                s = p += c;
                ++index;
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="string_byte_character_index", needsSelf=false)
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringByteCharacterIndexNode
    extends RubiniusPrimitiveNode {
        public StringByteCharacterIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public abstract int executeStringBytCharacterIndex(VirtualFrame var1, RubyBasicObject var2, int var3, int var4);

        @Specialization(guards={"isSingleByteOptimizableOrAsciiOnly(string)"})
        public int stringByteCharacterIndexSingleByte(RubyBasicObject string, int index, int start) {
            return index;
        }

        @Specialization(guards={"!isSingleByteOptimizableOrAsciiOnly(string)", "isFixedWidthEncoding(string)", "!isValidUtf8(string)"})
        public int stringByteCharacterIndexFixedWidth(RubyBasicObject string, int index, int start) {
            return index / StringNodes.getByteList(string).getEncoding().minLength();
        }

        @Specialization(guards={"!isSingleByteOptimizableOrAsciiOnly(string)", "!isFixedWidthEncoding(string)", "isValidUtf8(string)"})
        public int stringByteCharacterIndexValidUtf8(RubyBasicObject string, int index, int start) {
            return this.stringByteCharacterIndex(string, index, start);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!isSingleByteOptimizableOrAsciiOnly(string)", "!isFixedWidthEncoding(string)", "!isValidUtf8(string)"})
        public int stringByteCharacterIndex(RubyBasicObject string, int index, int start) {
            ByteList bytes = StringNodes.getByteList(string);
            Encoding encoding = bytes.getEncoding();
            int p = bytes.begin() + start;
            int end = bytes.begin() + bytes.realSize();
            int charIndex = 0;
            while (p < end && index > 0) {
                int charLen = StringSupport.length((Encoding)encoding, (byte[])bytes.getUnsafeBytes(), (int)p, (int)end);
                p += charLen;
                index -= charLen;
                ++charIndex;
            }
            return charIndex;
        }
    }

    @RubiniusPrimitive(name="string_character_byte_index", needsSelf=false, lowerFixnumParameters={1, 2})
    @ImportStatic(value={StringGuards.class})
    public static abstract class CharacterByteIndexNode
    extends RubiniusPrimitiveNode {
        public CharacterByteIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndex(RubyBasicObject string, int index, int start) {
            return start + index;
        }

        @Specialization(guards={"!isSingleByteOptimizable(string)"})
        public int stringCharacterByteIndexMultiByteEncoding(RubyBasicObject string, int index, int start) {
            ByteList bytes = StringNodes.getByteList(string);
            return StringSupport.nth((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)(bytes.getBegin() + start), (int)(bytes.getBegin() + bytes.getRealSize()), (int)index) - bytes.begin();
        }
    }

    @RubiniusPrimitive(name="string_index", lowerFixnumParameters={1})
    public static abstract class StringIndexPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        StringByteCharacterIndexNode byteIndexToCharIndexNode;

        public StringIndexPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(pattern)"})
        public Object stringIndex(VirtualFrame frame, RubyBasicObject string, RubyBasicObject pattern, int start) {
            if (this.byteIndexToCharIndexNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.byteIndexToCharIndexNode = this.insert(StringPrimitiveNodesFactory.StringByteCharacterIndexNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            int charIndex = this.byteIndexToCharIndexNode.executeStringBytCharacterIndex(frame, string, start, 0);
            int index = StringSupport.index((CodeRangeable)StringNodes.getCodeRangeable(string), (CodeRangeable)StringNodes.getCodeRangeable(pattern), (int)charIndex, (Encoding)StringNodes.getByteList(string).getEncoding());
            if (index == -1) {
                return this.nil();
            }
            return index;
        }
    }

    @RubiniusPrimitive(name="string_to_f", needsSelf=false)
    public static abstract class StringToFPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringToFPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object stringToF(RubyBasicObject string) {
            try {
                return Double.parseDouble(string.toString());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    @RubiniusPrimitive(name="string_from_codepoint", needsSelf=false)
    public static abstract class StringFromCodepointPrimitiveNode
    extends RubiniusPrimitiveNode {
        public StringFromCodepointPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyEncoding(encoding)", "isSimple(code, encoding)"})
        public RubyBasicObject stringFromCodepointSimple(int code, RubyBasicObject encoding) {
            return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(new byte[]{(byte)code}, EncodingNodes.getEncoding(encoding)));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyEncoding(encoding)", "!isSimple(code, encoding)"})
        public RubyBasicObject stringFromCodepoint(int code, RubyBasicObject encoding) {
            int length;
            try {
                length = EncodingNodes.getEncoding(encoding).codeToMbcLength(code);
            }
            catch (EncodingException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            if (length <= 0) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            byte[] bytes = new byte[length];
            try {
                EncodingNodes.getEncoding(encoding).codeToMbc(code, bytes, 0);
            }
            catch (EncodingException e) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(code, encoding, this));
            }
            return StringNodes.createString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(bytes, EncodingNodes.getEncoding(encoding)));
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public RubyBasicObject stringFromCodepointSimple(long code, RubyBasicObject encoding) {
            if (code < Integer.MIN_VALUE || code > Integer.MAX_VALUE) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            return this.stringFromCodepointSimple((int)code, encoding);
        }

        protected boolean isSimple(int code, RubyBasicObject encoding) {
            return EncodingNodes.getEncoding(encoding) == ASCIIEncoding.INSTANCE && code >= 0 && code <= 255;
        }
    }

    @RubiniusPrimitive(name="string_find_character")
    @ImportStatic(value={StringGuards.class})
    public static abstract class StringFindCharacterNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringFindCharacterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isSingleByte(string)"})
        public Object stringFindCharacterSingleByte(RubyBasicObject string, int offset) {
            if (offset < 0) {
                return this.nil();
            }
            ByteList byteList = StringNodes.getByteList(string);
            if (offset >= byteList.getRealSize()) {
                return this.nil();
            }
            RubyBasicObject ret = StringNodes.createString(string.getLogicalClass(), new ByteList(byteList, offset, 1));
            return this.propagate(string, ret);
        }

        @Specialization(guards={"!isSingleByte(string)"})
        public Object stringFindCharacter(RubyBasicObject string, int offset) {
            if (offset < 0) {
                return this.nil();
            }
            ByteList byteList = StringNodes.getByteList(string);
            if (offset >= byteList.getRealSize()) {
                return this.nil();
            }
            ByteList bytes = byteList;
            Encoding enc = bytes.getEncoding();
            int clen = StringSupport.preciseLength((Encoding)enc, (byte[])bytes.getUnsafeBytes(), (int)bytes.begin(), (int)(bytes.begin() + bytes.realSize()));
            RubyBasicObject ret = StringSupport.MBCLEN_CHARFOUND_P((int)clen) ? StringNodes.createString(string.getLogicalClass(), new ByteList(byteList, offset, clen)) : StringNodes.createString(string.getLogicalClass(), new ByteList(byteList, offset, 1));
            return this.propagate(string, ret);
        }

        private Object propagate(RubyBasicObject string, RubyBasicObject ret) {
            StringNodes.getByteList(ret).setEncoding(StringNodes.getByteList(string).getEncoding());
            StringNodes.setCodeRange(ret, StringNodes.getCodeRange(string));
            return this.maybeTaint(string, ret);
        }

        private Object maybeTaint(RubyBasicObject source, RubyBasicObject value) {
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            return this.taintResultNode.maybeTaint(source, value);
        }
    }

    @RubiniusPrimitive(name="string_equal", needsSelf=true)
    public static abstract class StringEqualPrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile incompatibleEncodingProfile = ConditionProfile.createBinaryProfile();

        public StringEqualPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(other)"})
        public boolean stringEqual(RubyBasicObject string, RubyBasicObject other) {
            ByteList a = StringNodes.getByteList(string);
            ByteList b = StringNodes.getByteList(other);
            if (this.incompatibleEncodingProfile.profile(a.getEncoding() != b.getEncoding() && RubyEncoding.areCompatible((CodeRangeable)StringNodes.getCodeRangeable(string), (CodeRangeable)StringNodes.getCodeRangeable(other)) == null)) {
                return false;
            }
            return a.equal(b);
        }
    }

    @RubiniusPrimitive(name="string_compare_substring")
    public static abstract class StringCompareSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile startTooLargeProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile startTooSmallProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private StringNodes.SizeNode sizeNode;

        public StringCompareSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sizeNode = StringNodesFactory.SizeNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        @Specialization(guards={"isRubyString(other)"})
        public int stringCompareSubstring(VirtualFrame frame, RubyBasicObject string, RubyBasicObject other, int start, int size) {
            int stringLength = this.sizeNode.executeInteger(frame, string);
            int otherLength = this.sizeNode.executeInteger(frame, other);
            if (start < 0) {
                start += otherLength;
            }
            if (this.startTooLargeProfile.profile(start > otherLength)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", start), this));
            }
            if (this.startTooSmallProfile.profile(start < 0)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(String.format("index %d out of string", start), this));
            }
            if (start + size > otherLength) {
                size = otherLength - start;
            }
            if (size > stringLength) {
                size = stringLength;
            }
            ByteList bytes = StringNodes.getByteList(string);
            ByteList otherBytes = StringNodes.getByteList(other);
            return ByteList.memcmp((byte[])bytes.getUnsafeBytes(), (int)bytes.getBegin(), (int)size, (byte[])otherBytes.getUnsafeBytes(), (int)(otherBytes.getBegin() + start), (int)size);
        }
    }

    @RubiniusPrimitive(name="string_chr_at")
    public static abstract class StringChrAtPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private StringByteSubstringPrimitiveNode stringByteSubstringNode;

        public StringChrAtPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object stringChrAt(RubyBasicObject string, int byteIndex) {
            ByteList bytes = StringNodes.getByteList(string);
            if (byteIndex < 0 || byteIndex >= bytes.getRealSize()) {
                return this.nil();
            }
            int p = bytes.getBegin() + byteIndex;
            int end = bytes.getBegin() + bytes.getRealSize();
            int c = StringSupport.preciseLength((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)p, (int)end);
            if (!StringSupport.MBCLEN_CHARFOUND_P((int)c)) {
                return this.nil();
            }
            int n = StringSupport.MBCLEN_CHARFOUND_LEN((int)c);
            if (n + byteIndex > end) {
                return this.nil();
            }
            if (this.stringByteSubstringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.stringByteSubstringNode = this.insert(StringPrimitiveNodesFactory.StringByteSubstringPrimitiveNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.stringByteSubstringNode.stringByteSubstring(string, byteIndex, n);
        }
    }

    @RubiniusPrimitive(name="string_check_null_safe", needsSelf=false)
    public static abstract class StringCheckNullSafePrimitiveNode
    extends RubiniusPrimitiveNode {
        private final ConditionProfile nullByteProfile = ConditionProfile.createBinaryProfile();

        public StringCheckNullSafePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyBasicObject stringCheckNullSafe(RubyBasicObject string) {
            ByteList byteList = StringNodes.getByteList(string);
            for (int i = 0; i < byteList.length(); ++i) {
                if (!this.nullByteProfile.profile(byteList.get(i) == 0)) continue;
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("string contains NULL byte", this));
            }
            return string;
        }
    }

    @RubiniusPrimitive(name="string_byte_substring")
    public static abstract class StringByteSubstringPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringByteSubstringPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, int index, NotProvided length) {
            Object subString = this.stringByteSubstring(string, index, 1);
            if (subString == this.nil()) {
                return subString;
            }
            if (StringNodes.getByteList((RubyBasicObject)subString).length() == 0) {
                return this.nil();
            }
            return subString;
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, int index, int length) {
            ByteList bytes = StringNodes.getByteList(string);
            if (length < 0) {
                return this.nil();
            }
            int normalizedIndex = StringNodes.normalizeIndex(string, index);
            if (normalizedIndex < 0 || normalizedIndex > bytes.length()) {
                return this.nil();
            }
            if (normalizedIndex + length > bytes.length()) {
                length = bytes.length() - normalizedIndex;
            }
            RubyBasicObject result = StringNodes.createString(string.getLogicalClass(), new ByteList(bytes, normalizedIndex, length));
            return this.taintResultNode.maybeTaint(string, result);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, int index, double length) {
            return this.stringByteSubstring(string, index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, double index, NotProvided length) {
            return this.stringByteSubstring(string, (int)index, 1);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, long index, int length) {
            return this.stringByteSubstring(string, index, (long)length);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, int index, long length) {
            return this.stringByteSubstring(string, (long)index, length);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, long index, long length) {
            if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("index out of int range", this));
            }
            if (length > Integer.MAX_VALUE || length < Integer.MIN_VALUE) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("length out of int range", this));
            }
            return this.stringByteSubstring(string, (int)index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, double index, double length) {
            return this.stringByteSubstring(string, (int)index, (int)length);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, double index, int length) {
            return this.stringByteSubstring(string, (int)index, length);
        }

        @Specialization
        public Object stringByteSubstring(RubyBasicObject string, RubyRange range, NotProvided length) {
            return null;
        }

        @Specialization(guards={"!isRubyRange(indexOrRange)"})
        public Object stringByteSubstring(RubyBasicObject string, Object indexOrRange, Object length) {
            return null;
        }
    }

    @RubiniusPrimitive(name="string_awk_split")
    public static abstract class StringAwkSplitPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public StringAwkSplitPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject stringAwkSplit(RubyBasicObject string, int lim) {
            int p;
            ArrayList<RubyBasicObject> ret = new ArrayList<RubyBasicObject>();
            ByteList value = StringNodes.getByteList(string);
            boolean limit = lim > 0;
            int i = lim > 0 ? 1 : 0;
            byte[] bytes = value.getUnsafeBytes();
            int ptr = p = value.getBegin();
            int len = value.getRealSize();
            int end = p + len;
            Encoding enc = value.getEncoding();
            boolean skip = true;
            int e = 0;
            int b = 0;
            boolean singlebyte = StringSupport.isSingleByteOptimizable((CodeRangeable)StringNodes.getCodeRangeable(string), (Encoding)enc);
            while (p < end) {
                int c;
                if (singlebyte) {
                    c = bytes[p++] & 0xFF;
                } else {
                    try {
                        c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)p, (int)end);
                    }
                    catch (RaiseException ex) {
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().toTruffle(ex.getException(), this));
                    }
                    p += StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
                }
                if (skip) {
                    if (enc.isSpace(c)) {
                        b = p - ptr;
                        continue;
                    }
                    e = p - ptr;
                    skip = false;
                    if (!limit || lim > i) continue;
                    break;
                }
                if (enc.isSpace(c)) {
                    ret.add(this.makeString(string, b, e - b));
                    skip = true;
                    b = p - ptr;
                    if (!limit) continue;
                    ++i;
                    continue;
                }
                e = p - ptr;
            }
            if (len > 0 && (limit || len > b || lim < 0)) {
                ret.add(this.makeString(string, b, len - b));
            }
            return ArrayNodes.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), ret.toArray());
        }

        private RubyBasicObject makeString(RubyBasicObject source, int index, int length) {
            assert (RubyGuards.isRubyString(source));
            ByteList bytes = new ByteList(StringNodes.getByteList(source), index, length);
            bytes.setEncoding(StringNodes.getByteList(source).getEncoding());
            RubyBasicObject ret = StringNodes.createString(source.getLogicalClass(), bytes);
            this.taintResultNode.maybeTaint(source, ret);
            return ret;
        }
    }

    @RubiniusPrimitive(name="character_ascii_p")
    public static abstract class CharacterAsciiPrimitiveNode
    extends RubiniusPrimitiveNode {
        public CharacterAsciiPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean isCharacterAscii(RubyBasicObject character) {
            ByteList bytes = StringNodes.getByteList(character);
            int codepoint = StringSupport.preciseCodePoint((Encoding)bytes.getEncoding(), (byte[])bytes.getUnsafeBytes(), (int)bytes.getBegin(), (int)(bytes.getBegin() + bytes.getRealSize()));
            boolean found = codepoint != -1;
            return found && Encoding.isAscii((int)codepoint);
        }
    }
}

