/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.util.Locale;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.array.ArrayNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;

public abstract class FloatPrimitiveNodes {

    @RubiniusPrimitive(name="float_round")
    public static abstract class FloatRoundPrimitiveNode
    extends RubiniusPrimitiveNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;
        private final BranchProfile greaterZero = BranchProfile.create();
        private final BranchProfile lessZero = BranchProfile.create();

        public FloatRoundPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        @Specialization
        public Object round(double n) {
            if (Double.isInfinite(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("Infinity", this));
            }
            if (Double.isNaN(n)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().floatDomainError("NaN", this));
            }
            double f = n;
            if (f > 0.0) {
                this.greaterZero.enter();
                f = Math.floor(f);
                if (n - f >= 0.5) {
                    f += 1.0;
                }
            } else if (f < 0.0) {
                this.lessZero.enter();
                f = Math.ceil(f);
                if (f - n >= 0.5) {
                    f -= 1.0;
                }
            }
            return this.fixnumOrBignum.fixnumOrBignum(f);
        }
    }

    @RubiniusPrimitive(name="float_negative")
    public static abstract class FloatNegativePrimitiveNode
    extends RubiniusPrimitiveNode {
        public FloatNegativePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean floatNegative(double value) {
            return Double.doubleToLongBits(value) >>> 63 == 1L;
        }
    }

    @RubiniusPrimitive(name="float_dtoa")
    public static abstract class FloatDToAPrimitiveNode
    extends RubiniusPrimitiveNode {
        public FloatDToAPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyBasicObject dToA(double value) {
            int decimal;
            String string = String.format(Locale.ENGLISH, "%.9f", value);
            if (string.toLowerCase(Locale.ENGLISH).contains("e")) {
                throw new UnsupportedOperationException();
            }
            if ((string = string.replace("-", "")).startsWith("0.")) {
                string = string.replace("0.", "");
                decimal = 0;
            } else {
                decimal = string.indexOf(46);
                if (decimal == -1) {
                    throw new UnsupportedOperationException();
                }
                string = string.replace(".", "");
            }
            int sign = value < 0.0 ? 1 : 0;
            return ArrayNodes.createArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{this.createString(string), decimal, sign, string.length()}, 4);
        }
    }
}

