/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeGen;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;

@NodeChild(value="value", type=RubyNode.class)
public abstract class SingletonClassNode
extends RubyNode {
    @Node.Child
    IsFrozenNode isFrozenNode;
    @Node.Child
    FreezeNode freezeNode;

    public SingletonClassNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract RubyClass executeSingletonClass(VirtualFrame var1, Object var2);

    @Specialization(guards={"value"})
    protected RubyClass singletonClassTrue(boolean value) {
        return this.getContext().getCoreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected RubyClass singletonClassFalse(boolean value) {
        return this.getContext().getCoreLibrary().getFalseClass();
    }

    @Specialization(guards={"isNil(value)"})
    protected RubyClass singletonClassNil(RubyBasicObject value) {
        return this.getContext().getCoreLibrary().getNilClass();
    }

    @Specialization
    protected RubyClass singletonClass(int value) {
        return this.noSingletonClass();
    }

    @Specialization
    protected RubyClass singletonClass(long value) {
        return this.noSingletonClass();
    }

    @Specialization
    protected RubyClass singletonClass(double value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"isRubyBignum(value)"})
    protected RubyClass singletonClassBignum(RubyBasicObject value) {
        return this.noSingletonClass();
    }

    @Specialization(guards={"isRubySymbol(value)"})
    protected RubyClass singletonClassSymbol(RubyBasicObject value) {
        return this.noSingletonClass();
    }

    @Specialization
    protected RubyClass singletonClass(RubyClass rubyClass) {
        CompilerAsserts.neverPartOfCompilation();
        return rubyClass.getSingletonClass();
    }

    @Specialization(guards={"!isNil(object)", "!isRubyBignum(object)", "!isRubySymbol(object)", "!isRubyClass(object)"})
    protected RubyClass singletonClass(RubyBasicObject object) {
        return this.getNormalObjectSingletonClass(object);
    }

    public RubyClass getNormalObjectSingletonClass(RubyBasicObject object) {
        CompilerAsserts.neverPartOfCompilation();
        if (object instanceof RubyClass) {
            return ((RubyClass)object).getSingletonClass();
        }
        if (object.getMetaClass().isSingleton()) {
            return object.getMetaClass();
        }
        CompilerDirectives.transferToInterpreter();
        RubyClass logicalClass = object.getLogicalClass();
        RubyModule attached = null;
        if (object instanceof RubyModule) {
            attached = (RubyModule)object;
        }
        String name = String.format("#<Class:#<%s:0x%x>>", logicalClass.getName(), object.verySlowGetObjectID());
        RubyClass singletonClass = RubyClass.createSingletonClassOfObject(this.getContext(), logicalClass, attached, name);
        this.propagateFrozen(object, singletonClass);
        object.setMetaClass(singletonClass);
        return singletonClass;
    }

    private void propagateFrozen(Object object, RubyClass singletonClass) {
        if (this.isFrozenNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.isFrozenNode = this.insert(IsFrozenNodeGen.create(this.getContext(), this.getSourceSection(), null));
            this.freezeNode = this.insert(FreezeNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        if (this.isFrozenNode.executeIsFrozen(object)) {
            this.freezeNode.executeFreeze(singletonClass);
        }
    }

    private RubyClass noSingletonClass() {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantDefineSingleton(this));
    }
}

