/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;

@GeneratedBy(value=MetaClassNode.class)
public final class MetaClassNodeGen
extends MetaClassNode
implements SpecializedNode {
    @Node.Child
    private RubyNode object_;
    @CompilerDirectives.CompilationFinal
    private Class<?> objectType_;
    @Node.Child
    private BaseNode_ specialization_;

    private MetaClassNodeGen(RubyContext context, SourceSection sourceSection, RubyNode object) {
        super(context, sourceSection);
        this.object_ = object;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public RubyClass executeMetaClass(VirtualFrame frameValue, Object objectValue) {
        return this.specialization_.executeRubyClass(frameValue, objectValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
        return this.specialization_.executeRubyBasicObject(frameValue);
    }

    @Override
    public RubyModule executeRubyModule(VirtualFrame frameValue) {
        return this.specialization_.executeRubyModule(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    public static MetaClassNode create(RubyContext context, SourceSection sourceSection, RubyNode object) {
        return new MetaClassNodeGen(context, sourceSection, object);
    }

    @GeneratedBy(methodName="singletonClass(RubyBasicObject)", value=MetaClassNode.class)
    private static final class SingletonClass3Node_
    extends BaseNode_ {
        SingletonClass3Node_(MetaClassNodeGen root) {
            super(root, 6);
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue, Object objectValue) {
            if (objectValue instanceof RubyBasicObject) {
                RubyBasicObject objectValue_ = (RubyBasicObject)objectValue;
                return this.root.singletonClass(objectValue_);
            }
            return this.getNext().executeRubyClass(frameValue, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new SingletonClass3Node_(root);
        }
    }

    @GeneratedBy(methodName="singletonClass(double)", value=MetaClassNode.class)
    private static final class SingletonClass2Node_
    extends BaseNode_ {
        SingletonClass2Node_(MetaClassNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double objectValue_;
            try {
                objectValue_ = this.root.object_.executeDouble(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyClass(frameValue, ex.getResult());
            }
            return this.root.singletonClass(objectValue_);
        }

        @Override
        public RubyModule executeRubyModule(VirtualFrame frameValue) {
            return (RubyModule)this.execute(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            return (RubyBasicObject)this.execute(frameValue);
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue, Object objectValue) {
            if (objectValue instanceof Double) {
                double objectValue_ = (Double)objectValue;
                return this.root.singletonClass(objectValue_);
            }
            return this.getNext().executeRubyClass(frameValue, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new SingletonClass2Node_(root);
        }
    }

    @GeneratedBy(methodName="singletonClass(long)", value=MetaClassNode.class)
    private static final class SingletonClass1Node_
    extends BaseNode_ {
        private final Class<?> objectImplicitType;

        SingletonClass1Node_(MetaClassNodeGen root, Object objectValue) {
            super(root, 4);
            this.objectImplicitType = RubyTypesGen.getImplicitLongClass(objectValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.objectImplicitType == ((SingletonClass1Node_)other).objectImplicitType;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long objectValue_;
            block4: {
                try {
                    if (this.objectImplicitType == Long.TYPE) {
                        objectValue_ = this.root.object_.executeLong(frameValue);
                        break block4;
                    }
                    if (this.objectImplicitType == Integer.TYPE) {
                        objectValue_ = RubyTypes.int2long(this.root.object_.executeInteger(frameValue));
                        break block4;
                    }
                    Object objectValue__ = this.executeObject_(frameValue);
                    throw new UnexpectedResultException(objectValue__);
                }
                catch (UnexpectedResultException ex) {
                    return this.getNext().executeRubyClass(frameValue, ex.getResult());
                }
            }
            return this.root.singletonClass(objectValue_);
        }

        @Override
        public RubyModule executeRubyModule(VirtualFrame frameValue) {
            return (RubyModule)this.execute(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            return (RubyBasicObject)this.execute(frameValue);
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue, Object objectValue) {
            if (RubyTypesGen.isImplicitLong(objectValue, this.objectImplicitType)) {
                long objectValue_ = RubyTypesGen.asImplicitLong(objectValue, this.objectImplicitType);
                return this.root.singletonClass(objectValue_);
            }
            return this.getNext().executeRubyClass(frameValue, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root, Object objectValue) {
            return new SingletonClass1Node_(root, objectValue);
        }
    }

    @GeneratedBy(methodName="singletonClass(int)", value=MetaClassNode.class)
    private static final class SingletonClass0Node_
    extends BaseNode_ {
        SingletonClass0Node_(MetaClassNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int objectValue_;
            try {
                objectValue_ = this.root.object_.executeInteger(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyClass(frameValue, ex.getResult());
            }
            return this.root.singletonClass(objectValue_);
        }

        @Override
        public RubyModule executeRubyModule(VirtualFrame frameValue) {
            return (RubyModule)this.execute(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            return (RubyBasicObject)this.execute(frameValue);
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue, Object objectValue) {
            if (objectValue instanceof Integer) {
                int objectValue_ = (Integer)objectValue;
                return this.root.singletonClass(objectValue_);
            }
            return this.getNext().executeRubyClass(frameValue, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new SingletonClass0Node_(root);
        }
    }

    @GeneratedBy(methodName="singletonClassFalse(boolean)", value=MetaClassNode.class)
    private static final class SingletonClassFalseNode_
    extends BaseNode_ {
        SingletonClassFalseNode_(MetaClassNodeGen root) {
            super(root, 2);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean objectValue_;
            try {
                objectValue_ = this.root.object_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyClass(frameValue, ex.getResult());
            }
            if (!objectValue_) {
                return this.root.singletonClassFalse(objectValue_);
            }
            return this.getNext().executeRubyClass(frameValue, objectValue_);
        }

        @Override
        public RubyModule executeRubyModule(VirtualFrame frameValue) {
            return (RubyModule)this.execute(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            return (RubyBasicObject)this.execute(frameValue);
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue, Object objectValue) {
            boolean objectValue_;
            if (objectValue instanceof Boolean && !(objectValue_ = ((Boolean)objectValue).booleanValue())) {
                return this.root.singletonClassFalse(objectValue_);
            }
            return this.getNext().executeRubyClass(frameValue, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new SingletonClassFalseNode_(root);
        }
    }

    @GeneratedBy(methodName="singletonClassTrue(boolean)", value=MetaClassNode.class)
    private static final class SingletonClassTrueNode_
    extends BaseNode_ {
        SingletonClassTrueNode_(MetaClassNodeGen root) {
            super(root, 1);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean objectValue_;
            try {
                objectValue_ = this.root.object_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().executeRubyClass(frameValue, ex.getResult());
            }
            if (objectValue_) {
                return this.root.singletonClassTrue(objectValue_);
            }
            return this.getNext().executeRubyClass(frameValue, objectValue_);
        }

        @Override
        public RubyModule executeRubyModule(VirtualFrame frameValue) {
            return (RubyModule)this.execute(frameValue);
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            return (RubyBasicObject)this.execute(frameValue);
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue, Object objectValue) {
            boolean objectValue_;
            if (objectValue instanceof Boolean && (objectValue_ = ((Boolean)objectValue).booleanValue())) {
                return this.root.singletonClassTrue(objectValue_);
            }
            return this.getNext().executeRubyClass(frameValue, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new SingletonClassTrueNode_(root);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(MetaClassNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object objectValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, objectValue));
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue, Object objectValue) {
            return this.getNext().executeRubyClass(frameValue, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(MetaClassNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public RubyClass executeRubyClass(VirtualFrame frameValue, Object objectValue) {
            return (RubyClass)this.uninitialized((Frame)frameValue, objectValue);
        }

        static BaseNode_ create(MetaClassNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=MetaClassNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        protected final MetaClassNodeGen root;

        BaseNode_(MetaClassNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.object_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object objectValue) {
            return this.executeRubyClass((VirtualFrame)frameValue, objectValue);
        }

        public abstract RubyClass executeRubyClass(VirtualFrame var1, Object var2);

        public Object execute(VirtualFrame frameValue) {
            Object objectValue_ = this.executeObject_(frameValue);
            return this.executeRubyClass(frameValue, objectValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) {
            return (RubyBasicObject)this.execute(frameValue);
        }

        public RubyModule executeRubyModule(VirtualFrame frameValue) {
            return (RubyModule)this.executeRubyBasicObject(frameValue);
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object objectValue) {
            if (objectValue instanceof Boolean) {
                boolean objectValue_ = (Boolean)objectValue;
                if (objectValue_) {
                    return SingletonClassTrueNode_.create(this.root);
                }
                return SingletonClassFalseNode_.create(this.root);
            }
            if (objectValue instanceof Integer) {
                return SingletonClass0Node_.create(this.root);
            }
            if (RubyTypesGen.isImplicitLong(objectValue)) {
                return SingletonClass1Node_.create(this.root, objectValue);
            }
            if (objectValue instanceof Double) {
                return SingletonClass2Node_.create(this.root);
            }
            if (objectValue instanceof RubyBasicObject) {
                return SingletonClass3Node_.create(this.root);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeObject_(Frame frameValue) {
            Object object;
            Class objectType_ = this.root.objectType_;
            if (objectType_ == Boolean.TYPE) {
                return this.root.object_.executeBoolean((VirtualFrame)frameValue);
            }
            if (objectType_ == Double.TYPE) {
                return this.root.object_.executeDouble((VirtualFrame)frameValue);
            }
            if (objectType_ == Integer.TYPE) {
                return this.root.object_.executeInteger((VirtualFrame)frameValue);
            }
            if (objectType_ == Long.TYPE) {
                return this.root.object_.executeLong((VirtualFrame)frameValue);
            }
            if (objectType_ != null) return this.root.object_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.object_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.objectType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.objectType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.objectType_ = _type;
            return object;
        }
    }
}

