/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyModule;

public class SetMethodDeclarationContext
extends RubyNode {
    @Node.Child
    private RubyNode child;
    final Visibility visibility;
    final String what;

    public SetMethodDeclarationContext(RubyContext context, SourceSection sourceSection, Visibility visibility, String what, RubyNode child) {
        super(context, sourceSection);
        this.child = child;
        this.visibility = visibility;
        this.what = what;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        FrameSlot slot = frame.getFrameDescriptor().findOrAddFrameSlot(RubyModule.VISIBILITY_FRAME_SLOT_ID, "visibility for " + this.what, FrameSlotKind.Object);
        Object oldVisibility = frame.getValue(slot);
        try {
            frame.setObject(slot, this.visibility);
            Object object = this.child.execute(frame);
            return object;
        }
        finally {
            frame.setObject(slot, oldVisibility);
        }
    }
}

